pkgfiles_all = {
    "/usr/share/man/man8/apt-config.8.gz": "DPKGFILE",
    "/usr/share/doc/tar/NEWS.Debian.gz": "DPKGFILE",
    "/usr/share/base-files/staff-group-for-usr-local": "DPKGFILE",
    "/usr/share/doc/apt/examples/configure-index.gz": "DPKGFILE",
    "/usr/share/man/man1/dirname.1.gz": "DPKGFILE",
    "/usr/share/man/man8/grpconv.8.gz": "DPKGFILE",
    "/lib/x86_64-linux-gnu/security/pam_tty_audit.so": "DPKGFILE",
}

pkgs_all = {
    "libsystemd0": "232-25+deb9u12",
    "tar": "1.29b-1.1",
    "bsdutils": "1:2.29.2-1+deb9u1",
    "multiarch-support": "2.24-11+deb9u4",
    "findutils": "4.6.0+git+20161106-2",
    "liblz4-1": "0.0~r131-2+b1",
    "libc6": "2.24-11+deb9u4",
    "libapt-pkg5.0": "1.4.10",
    "libcap-ng0": "0.7.7-3+b1",
}

pkgs_allinfo = {
    "adduser": {
        "arch": "all",
        "cpes": ["cpe:2.3:a:adduser:adduser:3.115:*:*:*:*:*:*:*"],
        "license": "GPL-2",
        "origin": "Debian Adduser Developers <adduser-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "849000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "3.115",
    },
    "apt": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:apt:apt:1.4.10:*:*:*:*:*:*:*"],
        "license": "GPL-2 GPLv2+",
        "origin": "APT Development Team <deity@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "3539000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "1.4.10",
    },
    "base-files": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:base-files:base-files:9.9+deb9u13:*:*:*:*:*:*:*",
            "cpe:2.3:a:base_files:base-files:9.9+deb9u13:*:*:*:*:*:*:*",
            "cpe:2.3:a:base-files:base_files:9.9+deb9u13:*:*:*:*:*:*:*",
            "cpe:2.3:a:base_files:base_files:9.9+deb9u13:*:*:*:*:*:*:*",
            "cpe:2.3:a:base:base-files:9.9+deb9u13:*:*:*:*:*:*:*",
            "cpe:2.3:a:base:base_files:9.9+deb9u13:*:*:*:*:*:*:*",
        ],
        "license": "GPL",
        "origin": "Santiago Vila <sanvila@debian.org> (maintainer)",
        "release": "N/A",
        "size": "333000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "9.9+deb9u13",
    },
    "base-passwd": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:base-passwd:base-passwd:3.5.43:*:*:*:*:*:*:*",
            "cpe:2.3:a:base_passwd:base-passwd:3.5.43:*:*:*:*:*:*:*",
            "cpe:2.3:a:base-passwd:base_passwd:3.5.43:*:*:*:*:*:*:*",
            "cpe:2.3:a:base_passwd:base_passwd:3.5.43:*:*:*:*:*:*:*",
            "cpe:2.3:a:base:base-passwd:3.5.43:*:*:*:*:*:*:*",
            "cpe:2.3:a:base:base_passwd:3.5.43:*:*:*:*:*:*:*",
        ],
        "license": "GPL-2 PD",
        "origin": "Colin Watson <cjwatson@debian.org> (maintainer)",
        "release": "N/A",
        "size": "229000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "3.5.43",
    },
    "bash": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:bash:bash:4.4-5:*:*:*:*:*:*:*"],
        "license": "GPL-3",
        "origin": "Matthias Klose <doko@debian.org> (maintainer)",
        "release": "N/A",
        "size": "5798000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "4.4-5",
    },
    "bsdutils": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:bsdutils:bsdutils:1:2.29.2-1+deb9u1:*:*:*:*:*:*:*"],
        "license": "BSD-2-clause BSD-3-clause BSD-4-clause GPL-2 GPL-2+ GPL-3 GPL-3+ LGPL LGPL-2 LGPL-2+ LGPL-2.1 LGPL-2.1+ LGPL-3 LGPL-3+ MIT public-domain",
        "origin": "Debian util-linux Maintainers <ah-util-linux@debian.org> (maintainer)",
        "release": "N/A",
        "size": "238000",
        "sourcepkg": "util-linux",
        "type": "dpkg",
        "version": "1:2.29.2-1+deb9u1",
    },
    "coreutils": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:coreutils:coreutils:8.26-3:*:*:*:*:*:*:*"],
        "license": "GPL-3",
        "origin": "Michael Stone <mstone@debian.org> (maintainer)",
        "release": "N/A",
        "size": "15103000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "8.26-3",
    },
    "cron-apt": {
        "arch": "all",
        "cpes": [
            "cpe:2.3:a:cron_apt:cron-apt:0.10.0:*:*:*:*:*:*:*",
            "cpe:2.3:a:cron-apt:cron-apt:0.10.0:*:*:*:*:*:*:*",
            "cpe:2.3:a:cron_apt:cron_apt:0.10.0:*:*:*:*:*:*:*",
            "cpe:2.3:a:cron-apt:cron_apt:0.10.0:*:*:*:*:*:*:*",
            "cpe:2.3:a:cron:cron-apt:0.10.0:*:*:*:*:*:*:*",
            "cpe:2.3:a:cron:cron_apt:0.10.0:*:*:*:*:*:*:*",
        ],
        "license": "GPL",
        "origin": "Ola Lundqvist <opal@debian.org> (maintainer)",
        "release": "N/A",
        "size": "167000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "0.10.0",
    },
    "dash": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:dash:dash:0.5.8-2.4:*:*:*:*:*:*:*"],
        "license": "GPL",
        "origin": "Gerrit Pape <pape@smarden.org> (maintainer)",
        "release": "N/A",
        "size": "204000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "0.5.8-2.4",
    },
    "debconf": {
        "arch": "all",
        "cpes": ["cpe:2.3:a:debconf:debconf:1.5.61:*:*:*:*:*:*:*"],
        "license": "BSD-2-clause",
        "origin": "Debconf Developers <debconf-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "558000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "1.5.61",
    },
    "debian-archive-keyring": {
        "arch": "all",
        "cpes": [
            "cpe:2.3:a:debian-archive-keyring:debian_archive_keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:debian-archive-keyring:debian-archive-keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:debian_archive_keyring:debian_archive_keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:debian_archive_keyring:debian-archive-keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:debian-archive:debian_archive_keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:debian-archive:debian-archive-keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:debian_archive:debian_archive_keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:debian_archive:debian-archive-keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:debian:debian_archive_keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:debian:debian-archive-keyring:2017.5+deb9u1:*:*:*:*:*:*:*",
        ],
        "license": "GPL",
        "origin": "Debian Release Team <packages@release.debian.org> (maintainer)",
        "release": "N/A",
        "size": "148000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "2017.5+deb9u1",
    },
    "debianutils": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:debianutils:debianutils:4.8.1.1:*:*:*:*:*:*:*"],
        "license": "GPL",
        "origin": "Clint Adams <clint@debian.org> (maintainer)",
        "release": "N/A",
        "size": "213000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "4.8.1.1",
    },
    "diffutils": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:diffutils:diffutils:1:3.5-3:*:*:*:*:*:*:*"],
        "license": "GFDL GPL",
        "origin": "Santiago Vila <sanvila@debian.org> (maintainer)",
        "release": "N/A",
        "size": "1327000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "1:3.5-3",
    },
    "dpkg": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:dpkg:dpkg:1.18.25:*:*:*:*:*:*:*"],
        "license": "BSD-2-clause GPL-2 GPL-2+ public-domain-md5 public-domain-s-s-d",
        "origin": "Dpkg Developers <debian-dpkg@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "6778000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "1.18.25",
    },
    "e2fslibs": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:e2fslibs:e2fslibs:1.43.4-2+deb9u2:*:*:*:*:*:*:*"],
        "license": "GPL-2 LGPL-2",
        "origin": "Theodore Y. Ts'o <tytso@mit.edu> (maintainer)",
        "release": "N/A",
        "size": "450000",
        "sourcepkg": "e2fsprogs",
        "type": "dpkg",
        "version": "1.43.4-2+deb9u2",
    },
    "e2fsprogs": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:e2fsprogs:e2fsprogs:1.43.4-2+deb9u2:*:*:*:*:*:*:*"],
        "license": "GPL-2 LGPL-2",
        "origin": "Theodore Y. Ts'o <tytso@mit.edu> (maintainer)",
        "release": "N/A",
        "size": "4027000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "1.43.4-2+deb9u2",
    },
    "findutils": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:findutils:findutils:4.6.0+git+20161106-2:*:*:*:*:*:*:*"],
        "license": "GFDL-1.3 GPL-3",
        "origin": "Andreas Metzler <ametzler@debian.org> (maintainer)",
        "release": "N/A",
        "size": "1854000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "4.6.0+git+20161106-2",
    },
    "gcc-6-base": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:gcc-6-base:gcc_6_base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gcc-6-base:gcc-6-base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gcc_6_base:gcc_6_base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gcc_6_base:gcc-6-base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gcc-6:gcc_6_base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gcc-6:gcc-6-base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gcc_6:gcc_6_base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gcc_6:gcc-6-base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gcc:gcc_6_base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gcc:gcc-6-base:6.3.0-18+deb9u1:*:*:*:*:*:*:*",
        ],
        "license": "Artistic GFDL-1.2 GPL GPL-2 GPL-3",
        "origin": "Debian GCC Maintainers <debian-gcc@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "209000",
        "sourcepkg": "gcc-6",
        "type": "dpkg",
        "version": "6.3.0-18+deb9u1",
    },
    "gpgv": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:gpgv:gpgv:2.1.18-8~deb9u4:*:*:*:*:*:*:*"],
        "license": "BSD-3-clause Expat GPL-3 GPL-3+ LGPL-2.1 LGPL-2.1+ LGPL-3 LGPL-3+ RFC-Reference TinySCHEME permissive",
        "origin": "Debian GnuPG Maintainers <pkg-gnupg-maint@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "721000",
        "sourcepkg": "gnupg2",
        "type": "dpkg",
        "version": "2.1.18-8~deb9u4",
    },
    "grep": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:grep:grep:2.27-2:*:*:*:*:*:*:*"],
        "license": "GPL-3 GPL-3+",
        "origin": "Anibal Monsalve Salazar <anibal@debian.org> (maintainer)",
        "release": "N/A",
        "size": "1131000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "2.27-2",
    },
    "gzip": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:gzip:gzip:1.6-5+b1:*:*:*:*:*:*:*"],
        "license": "GPL",
        "origin": "Bdale Garbee <bdale@gag.com> (maintainer)",
        "release": "N/A",
        "size": "231000",
        "sourcepkg": "gzip",
        "type": "dpkg",
        "version": "1.6-5+b1",
    },
    "hostname": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:hostname:hostname:3.18+b1:*:*:*:*:*:*:*"],
        "license": "GPL-2",
        "origin": "Debian Hostname Team <hostname-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "47000",
        "sourcepkg": "hostname",
        "type": "dpkg",
        "version": "3.18+b1",
    },
    "init-system-helpers": {
        "arch": "all",
        "cpes": [
            "cpe:2.3:a:init-system-helpers:init-system-helpers:1.48:*:*:*:*:*:*:*",
            "cpe:2.3:a:init-system-helpers:init_system_helpers:1.48:*:*:*:*:*:*:*",
            "cpe:2.3:a:init_system_helpers:init-system-helpers:1.48:*:*:*:*:*:*:*",
            "cpe:2.3:a:init_system_helpers:init_system_helpers:1.48:*:*:*:*:*:*:*",
            "cpe:2.3:a:init-system:init-system-helpers:1.48:*:*:*:*:*:*:*",
            "cpe:2.3:a:init-system:init_system_helpers:1.48:*:*:*:*:*:*:*",
            "cpe:2.3:a:init_system:init-system-helpers:1.48:*:*:*:*:*:*:*",
            "cpe:2.3:a:init_system:init_system_helpers:1.48:*:*:*:*:*:*:*",
            "cpe:2.3:a:init:init-system-helpers:1.48:*:*:*:*:*:*:*",
            "cpe:2.3:a:init:init_system_helpers:1.48:*:*:*:*:*:*:*",
        ],
        "license": "BSD-3-clause GPL-2 GPL-2+",
        "origin": "Debian systemd Maintainers <pkg-systemd-maintainers@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "131000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "1.48",
    },
    "libacl1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libacl1:libacl1:2.2.52-3+b1:*:*:*:*:*:*:*"],
        "license": "GPL LGPL-2.1",
        "origin": "Anibal Monsalve Salazar <anibal@debian.org> (maintainer)",
        "release": "N/A",
        "size": "62000",
        "sourcepkg": "acl",
        "type": "dpkg",
        "version": "2.2.52-3+b1",
    },
    "libapt-pkg5.0": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:libapt-pkg5.0:libapt-pkg5.0:1.4.10:*:*:*:*:*:*:*",
            "cpe:2.3:a:libapt_pkg5.0:libapt-pkg5.0:1.4.10:*:*:*:*:*:*:*",
            "cpe:2.3:a:libapt-pkg5.0:libapt_pkg5.0:1.4.10:*:*:*:*:*:*:*",
            "cpe:2.3:a:libapt_pkg5.0:libapt_pkg5.0:1.4.10:*:*:*:*:*:*:*",
            "cpe:2.3:a:libapt:libapt-pkg5.0:1.4.10:*:*:*:*:*:*:*",
            "cpe:2.3:a:libapt:libapt_pkg5.0:1.4.10:*:*:*:*:*:*:*",
        ],
        "license": "GPL-2 GPLv2+",
        "origin": "APT Development Team <deity@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "3056000",
        "sourcepkg": "apt",
        "type": "dpkg",
        "version": "1.4.10",
    },
    "libattr1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libattr1:libattr1:1:2.4.47-2+b2:*:*:*:*:*:*:*"],
        "license": "GPL-2 LGPL-2.1",
        "origin": "Anibal Monsalve Salazar <anibal@debian.org> (maintainer)",
        "release": "N/A",
        "size": "42000",
        "sourcepkg": "attr",
        "type": "dpkg",
        "version": "1:2.4.47-2+b2",
    },
    "libaudit-common": {
        "arch": "all",
        "cpes": [
            "cpe:2.3:a:libaudit-common:libaudit-common:1:2.6.7-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libaudit_common:libaudit-common:1:2.6.7-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libaudit-common:libaudit_common:1:2.6.7-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libaudit_common:libaudit_common:1:2.6.7-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libaudit:libaudit-common:1:2.6.7-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libaudit:libaudit_common:1:2.6.7-2:*:*:*:*:*:*:*",
        ],
        "license": "GPL-1 GPL-2 LGPL-2.1",
        "origin": "Laurent Bigonville <bigon@debian.org> (maintainer)",
        "release": "N/A",
        "size": "30000",
        "sourcepkg": "audit",
        "type": "dpkg",
        "version": "1:2.6.7-2",
    },
    "libaudit1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libaudit1:libaudit1:1:2.6.7-2:*:*:*:*:*:*:*"],
        "license": "GPL-1 GPL-2 LGPL-2.1",
        "origin": "Laurent Bigonville <bigon@debian.org> (maintainer)",
        "release": "N/A",
        "size": "150000",
        "sourcepkg": "audit",
        "type": "dpkg",
        "version": "1:2.6.7-2",
    },
    "libblkid1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libblkid1:libblkid1:2.29.2-1+deb9u1:*:*:*:*:*:*:*"],
        "license": "BSD-2-clause BSD-3-clause BSD-4-clause GPL-2 GPL-2+ GPL-3 GPL-3+ LGPL LGPL-2 LGPL-2+ LGPL-2.1 LGPL-2.1+ LGPL-3 LGPL-3+ MIT public-domain",
        "origin": "Debian util-linux Maintainers <ah-util-linux@debian.org> (maintainer)",
        "release": "N/A",
        "size": "367000",
        "sourcepkg": "util-linux",
        "type": "dpkg",
        "version": "2.29.2-1+deb9u1",
    },
    "libbz2-1.0": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:libbz2-1.0:libbz2-1.0:1.0.6-8.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libbz2_1.0:libbz2-1.0:1.0.6-8.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libbz2-1.0:libbz2_1.0:1.0.6-8.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libbz2_1.0:libbz2_1.0:1.0.6-8.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libbz2:libbz2-1.0:1.0.6-8.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libbz2:libbz2_1.0:1.0.6-8.1:*:*:*:*:*:*:*",
        ],
        "license": "GPL-2",
        "origin": "Anibal Monsalve Salazar <anibal@debian.org> (maintainer)",
        "release": "N/A",
        "size": "96000",
        "sourcepkg": "bzip2",
        "type": "dpkg",
        "version": "1.0.6-8.1",
    },
    "libc-bin": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:libc-bin:libc-bin:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:libc_bin:libc-bin:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:libc-bin:libc_bin:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:libc_bin:libc_bin:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:libc:libc-bin:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:libc:libc_bin:2.24-11+deb9u4:*:*:*:*:*:*:*",
        ],
        "license": "GPL-2 LGPL-2.1",
        "origin": "GNU Libc Maintainers <debian-glibc@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "3366000",
        "sourcepkg": "glibc",
        "type": "dpkg",
        "version": "2.24-11+deb9u4",
    },
    "libc6": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libc6:libc6:2.24-11+deb9u4:*:*:*:*:*:*:*"],
        "license": "GPL-2 LGPL-2.1",
        "origin": "GNU Libc Maintainers <debian-glibc@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "10686000",
        "sourcepkg": "glibc",
        "type": "dpkg",
        "version": "2.24-11+deb9u4",
    },
    "libcap-ng0": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:libcap-ng0:libcap-ng0:0.7.7-3+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap_ng0:libcap-ng0:0.7.7-3+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap-ng0:libcap_ng0:0.7.7-3+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap_ng0:libcap_ng0:0.7.7-3+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap:libcap-ng0:0.7.7-3+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap:libcap_ng0:0.7.7-3+b1:*:*:*:*:*:*:*",
        ],
        "license": "GPL-2 GPL-3 LGPL-2.1",
        "origin": "Pierre Chifflier <pollux@debian.org> (maintainer)",
        "release": "N/A",
        "size": "43000",
        "sourcepkg": "libcap-ng",
        "type": "dpkg",
        "version": "0.7.7-3+b1",
    },
    "libcomerr2": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libcomerr2:libcomerr2:1.43.4-2+deb9u2:*:*:*:*:*:*:*"],
        "license": "Unknown",
        "origin": "Theodore Y. Ts'o <tytso@mit.edu> (maintainer)",
        "release": "N/A",
        "size": "84000",
        "sourcepkg": "e2fsprogs",
        "type": "dpkg",
        "version": "1.43.4-2+deb9u2",
    },
    "libdb5.3": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libdb5.3:libdb5.3:5.3.28-12+deb9u1:*:*:*:*:*:*:*"],
        "license": "Unknown",
        "origin": "Debian Berkeley DB Group <pkg-db-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "1814000",
        "sourcepkg": "db5.3",
        "type": "dpkg",
        "version": "5.3.28-12+deb9u1",
    },
    "libdebconfclient0": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libdebconfclient0:libdebconfclient0:0.227:*:*:*:*:*:*:*"],
        "license": "Unknown",
        "origin": "Debian Install System Team <debian-boot@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "67000",
        "sourcepkg": "cdebconf",
        "type": "dpkg",
        "version": "0.227",
    },
    "libfdisk1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libfdisk1:libfdisk1:2.29.2-1+deb9u1:*:*:*:*:*:*:*"],
        "license": "BSD-2-clause BSD-3-clause BSD-4-clause GPL-2 GPL-2+ GPL-3 GPL-3+ LGPL LGPL-2 LGPL-2+ LGPL-2.1 LGPL-2.1+ LGPL-3 LGPL-3+ MIT public-domain",
        "origin": "Debian util-linux Maintainers <ah-util-linux@debian.org> (maintainer)",
        "release": "N/A",
        "size": "469000",
        "sourcepkg": "util-linux",
        "type": "dpkg",
        "version": "2.29.2-1+deb9u1",
    },
    "libgcc1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libgcc1:libgcc1:1:6.3.0-18+deb9u1:*:*:*:*:*:*:*"],
        "license": "Artistic GFDL-1.2 GPL GPL-2 GPL-3",
        "origin": "Debian GCC Maintainers <debian-gcc@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "108000",
        "sourcepkg": "gcc-6",
        "type": "dpkg",
        "version": "1:6.3.0-18+deb9u1",
    },
    "libgcrypt20": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libgcrypt20:libgcrypt20:1.7.6-2+deb9u3:*:*:*:*:*:*:*"],
        "license": "GPL-2 LGPL",
        "origin": "Debian GnuTLS Maintainers <pkg-gnutls-maint@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "1266000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "1.7.6-2+deb9u3",
    },
    "libgpg-error0": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:libgpg-error0:libgpg-error0:1.26-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg_error0:libgpg-error0:1.26-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg-error0:libgpg_error0:1.26-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg_error0:libgpg_error0:1.26-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg:libgpg-error0:1.26-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg:libgpg_error0:1.26-2:*:*:*:*:*:*:*",
        ],
        "license": "GPL-2.1+ LGPL-2.1",
        "origin": "Debian GnuPG Maintainers <pkg-gnupg-maint@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "572000",
        "sourcepkg": "libgpg-error",
        "type": "dpkg",
        "version": "1.26-2",
    },
    "liblz4-1": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:liblz4-1:liblz4-1:0.0~r131-2+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:liblz4_1:liblz4-1:0.0~r131-2+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:liblz4-1:liblz4_1:0.0~r131-2+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:liblz4_1:liblz4_1:0.0~r131-2+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:liblz4:liblz4-1:0.0~r131-2+b1:*:*:*:*:*:*:*",
            "cpe:2.3:a:liblz4:liblz4_1:0.0~r131-2+b1:*:*:*:*:*:*:*",
        ],
        "license": "BSD-2-clause GPL-2 GPL-2+",
        "origin": "Nobuhiro Iwamatsu <iwamatsu@debian.org> (maintainer)",
        "release": "N/A",
        "size": "93000",
        "sourcepkg": "lz4",
        "type": "dpkg",
        "version": "0.0~r131-2+b1",
    },
    "liblzma5": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:liblzma5:liblzma5:5.2.2-1.2+b1:*:*:*:*:*:*:*"],
        "license": "Autoconf GPL-2 GPL-2+ GPL-3 LGPL-2 LGPL-2.1 LGPL-2.1+ PD PD-debian config-h noderivs permissive-fsf permissive-nowarranty probably-PD",
        "origin": "Jonathan Nieder <jrnieder@gmail.com> (maintainer)",
        "release": "N/A",
        "size": "339000",
        "sourcepkg": "xz-utils",
        "type": "dpkg",
        "version": "5.2.2-1.2+b1",
    },
    "libmount1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libmount1:libmount1:2.29.2-1+deb9u1:*:*:*:*:*:*:*"],
        "license": "BSD-2-clause BSD-3-clause BSD-4-clause GPL-2 GPL-2+ GPL-3 GPL-3+ LGPL LGPL-2 LGPL-2+ LGPL-2.1 LGPL-2.1+ LGPL-3 LGPL-3+ MIT public-domain",
        "origin": "Debian util-linux Maintainers <ah-util-linux@debian.org> (maintainer)",
        "release": "N/A",
        "size": "403000",
        "sourcepkg": "util-linux",
        "type": "dpkg",
        "version": "2.29.2-1+deb9u1",
    },
    "libncursesw5": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:libncursesw5:libncursesw5:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*"
        ],
        "license": "Unknown",
        "origin": "Craig Small <csmall@debian.org> (maintainer)",
        "release": "N/A",
        "size": "347000",
        "sourcepkg": "ncurses",
        "type": "dpkg",
        "version": "6.0+20161126-1+deb9u2",
    },
    "libpam-modules": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:libpam-modules:libpam_modules:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam_modules:libpam_modules:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam-modules:libpam-modules:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam_modules:libpam-modules:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam:libpam_modules:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam:libpam-modules:1.1.8-3.6:*:*:*:*:*:*:*",
        ],
        "license": "GPL",
        "origin": "Steve Langasek <vorlon@debian.org> (maintainer)",
        "release": "N/A",
        "size": "874000",
        "sourcepkg": "pam",
        "type": "dpkg",
        "version": "1.1.8-3.6",
    },
    "libpam-modules-bin": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:libpam-modules-bin:libpam_modules_bin:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam-modules-bin:libpam-modules-bin:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam_modules_bin:libpam_modules_bin:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam_modules_bin:libpam-modules-bin:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam-modules:libpam_modules_bin:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam-modules:libpam-modules-bin:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam_modules:libpam_modules_bin:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam_modules:libpam-modules-bin:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam:libpam_modules_bin:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam:libpam-modules-bin:1.1.8-3.6:*:*:*:*:*:*:*",
        ],
        "license": "GPL",
        "origin": "Steve Langasek <vorlon@debian.org> (maintainer)",
        "release": "N/A",
        "size": "220000",
        "sourcepkg": "pam",
        "type": "dpkg",
        "version": "1.1.8-3.6",
    },
    "libpam-runtime": {
        "arch": "all",
        "cpes": [
            "cpe:2.3:a:libpam_runtime:libpam-runtime:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam-runtime:libpam-runtime:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam_runtime:libpam_runtime:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam-runtime:libpam_runtime:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam:libpam-runtime:1.1.8-3.6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libpam:libpam_runtime:1.1.8-3.6:*:*:*:*:*:*:*",
        ],
        "license": "GPL",
        "origin": "Steve Langasek <vorlon@debian.org> (maintainer)",
        "release": "N/A",
        "size": "1016000",
        "sourcepkg": "pam",
        "type": "dpkg",
        "version": "1.1.8-3.6",
    },
    "libpam0g": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libpam0g:libpam0g:1.1.8-3.6:*:*:*:*:*:*:*"],
        "license": "GPL",
        "origin": "Steve Langasek <vorlon@debian.org> (maintainer)",
        "release": "N/A",
        "size": "229000",
        "sourcepkg": "pam",
        "type": "dpkg",
        "version": "1.1.8-3.6",
    },
    "libpcre3": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libpcre3:libpcre3:2:8.39-3:*:*:*:*:*:*:*"],
        "license": "Unknown",
        "origin": "Matthew Vernon <matthew@debian.org> (maintainer)",
        "release": "N/A",
        "size": "668000",
        "sourcepkg": "pcre3",
        "type": "dpkg",
        "version": "2:8.39-3",
    },
    "libselinux1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libselinux1:libselinux1:2.6-3+b3:*:*:*:*:*:*:*"],
        "license": "GPL-2 LGPL-2.1",
        "origin": "Debian SELinux maintainers <selinux-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "209000",
        "sourcepkg": "libselinux",
        "type": "dpkg",
        "version": "2.6-3+b3",
    },
    "libsemanage-common": {
        "arch": "all",
        "cpes": [
            "cpe:2.3:a:libsemanage-common:libsemanage-common:2.6-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libsemanage_common:libsemanage-common:2.6-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libsemanage-common:libsemanage_common:2.6-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libsemanage_common:libsemanage_common:2.6-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libsemanage:libsemanage-common:2.6-2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libsemanage:libsemanage_common:2.6-2:*:*:*:*:*:*:*",
        ],
        "license": "GPL LGPL",
        "origin": "Debian SELinux maintainers <selinux-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "39000",
        "sourcepkg": "libsemanage",
        "type": "dpkg",
        "version": "2.6-2",
    },
    "libsemanage1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libsemanage1:libsemanage1:2.6-2:*:*:*:*:*:*:*"],
        "license": "GPL LGPL",
        "origin": "Debian SELinux maintainers <selinux-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "291000",
        "sourcepkg": "libsemanage",
        "type": "dpkg",
        "version": "2.6-2",
    },
    "libsepol1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libsepol1:libsepol1:2.6-2:*:*:*:*:*:*:*"],
        "license": "GPL LGPL",
        "origin": "Debian SELinux maintainers <selinux-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "653000",
        "sourcepkg": "libsepol",
        "type": "dpkg",
        "version": "2.6-2",
    },
    "libsmartcols1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libsmartcols1:libsmartcols1:2.29.2-1+deb9u1:*:*:*:*:*:*:*"],
        "license": "BSD-2-clause BSD-3-clause BSD-4-clause GPL-2 GPL-2+ GPL-3 GPL-3+ LGPL LGPL-2 LGPL-2+ LGPL-2.1 LGPL-2.1+ LGPL-3 LGPL-3+ MIT public-domain",
        "origin": "Debian util-linux Maintainers <ah-util-linux@debian.org> (maintainer)",
        "release": "N/A",
        "size": "257000",
        "sourcepkg": "util-linux",
        "type": "dpkg",
        "version": "2.29.2-1+deb9u1",
    },
    "libss2": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libss2:libss2:1.43.4-2+deb9u2:*:*:*:*:*:*:*"],
        "license": "Unknown",
        "origin": "Theodore Y. Ts'o <tytso@mit.edu> (maintainer)",
        "release": "N/A",
        "size": "96000",
        "sourcepkg": "e2fsprogs",
        "type": "dpkg",
        "version": "1.43.4-2+deb9u2",
    },
    "libstdc++6": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libstdc++6:libstdc++6:6.3.0-18+deb9u1:*:*:*:*:*:*:*"],
        "license": "Artistic GFDL-1.2 GPL GPL-2 GPL-3",
        "origin": "Debian GCC Maintainers <debian-gcc@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "1998000",
        "sourcepkg": "gcc-6",
        "type": "dpkg",
        "version": "6.3.0-18+deb9u1",
    },
    "libsystemd0": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libsystemd0:libsystemd0:232-25+deb9u12:*:*:*:*:*:*:*"],
        "license": "CC0 Expat GPL-2 GPL-2+ LGPL-2.1 LGPL-2.1+ public-domain",
        "origin": "Debian systemd Maintainers <pkg-systemd-maintainers@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "654000",
        "sourcepkg": "systemd",
        "type": "dpkg",
        "version": "232-25+deb9u12",
    },
    "libtinfo5": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libtinfo5:libtinfo5:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*"],
        "license": "Unknown",
        "origin": "Craig Small <csmall@debian.org> (maintainer)",
        "release": "N/A",
        "size": "478000",
        "sourcepkg": "ncurses",
        "type": "dpkg",
        "version": "6.0+20161126-1+deb9u2",
    },
    "libudev1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libudev1:libudev1:232-25+deb9u12:*:*:*:*:*:*:*"],
        "license": "CC0 Expat GPL-2 GPL-2+ LGPL-2.1 LGPL-2.1+ public-domain",
        "origin": "Debian systemd Maintainers <pkg-systemd-maintainers@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "224000",
        "sourcepkg": "systemd",
        "type": "dpkg",
        "version": "232-25+deb9u12",
    },
    "libustr-1.0-1": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:libustr-1.0-1:libustr_1.0_1:1.0.4-6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libustr-1.0-1:libustr-1.0-1:1.0.4-6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libustr_1.0_1:libustr_1.0_1:1.0.4-6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libustr_1.0_1:libustr-1.0-1:1.0.4-6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libustr-1.0:libustr_1.0_1:1.0.4-6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libustr-1.0:libustr-1.0-1:1.0.4-6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libustr_1.0:libustr_1.0_1:1.0.4-6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libustr_1.0:libustr-1.0-1:1.0.4-6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libustr:libustr_1.0_1:1.0.4-6:*:*:*:*:*:*:*",
            "cpe:2.3:a:libustr:libustr-1.0-1:1.0.4-6:*:*:*:*:*:*:*",
        ],
        "license": "BSD-2-clause GPL-2 GPL-2+ LGPL-2+ LGPL-2.1 MIT",
        "origin": "Vaclav Ovsik <vaclav.ovsik@i.cz> (maintainer)",
        "release": "N/A",
        "size": "258000",
        "sourcepkg": "ustr",
        "type": "dpkg",
        "version": "1.0.4-6",
    },
    "libuuid1": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:libuuid1:libuuid1:2.29.2-1+deb9u1:*:*:*:*:*:*:*"],
        "license": "BSD-2-clause BSD-3-clause BSD-4-clause GPL-2 GPL-2+ GPL-3 GPL-3+ LGPL LGPL-2 LGPL-2+ LGPL-2.1 LGPL-2.1+ LGPL-3 LGPL-3+ MIT public-domain",
        "origin": "Debian util-linux Maintainers <ah-util-linux@debian.org> (maintainer)",
        "release": "N/A",
        "size": "107000",
        "sourcepkg": "util-linux",
        "type": "dpkg",
        "version": "2.29.2-1+deb9u1",
    },
    "login": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:login:login:1:4.4-4.1:*:*:*:*:*:*:*"],
        "license": "GPL-2",
        "origin": "Shadow package maintainers <pkg-shadow-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "2747000",
        "sourcepkg": "shadow",
        "type": "dpkg",
        "version": "1:4.4-4.1",
    },
    "lsb-base": {
        "arch": "all",
        "cpes": [
            "cpe:2.3:a:lsb-base:lsb-base:9.20161125:*:*:*:*:*:*:*",
            "cpe:2.3:a:lsb_base:lsb-base:9.20161125:*:*:*:*:*:*:*",
            "cpe:2.3:a:lsb-base:lsb_base:9.20161125:*:*:*:*:*:*:*",
            "cpe:2.3:a:lsb_base:lsb_base:9.20161125:*:*:*:*:*:*:*",
            "cpe:2.3:a:lsb:lsb-base:9.20161125:*:*:*:*:*:*:*",
            "cpe:2.3:a:lsb:lsb_base:9.20161125:*:*:*:*:*:*:*",
        ],
        "license": "BSD-3-clause GPL-2",
        "origin": "Debian LSB Team <debian-lsb@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "49000",
        "sourcepkg": "lsb",
        "type": "dpkg",
        "version": "9.20161125",
    },
    "mawk": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:mawk:mawk:1.3.3-17+b3:*:*:*:*:*:*:*"],
        "license": "GPL-2",
        "origin": "Steve Langasek <vorlon@debian.org> (maintainer)",
        "release": "N/A",
        "size": "183000",
        "sourcepkg": "mawk",
        "type": "dpkg",
        "version": "1.3.3-17+b3",
    },
    "mount": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:mount:mount:2.29.2-1+deb9u1:*:*:*:*:*:*:*"],
        "license": "BSD-2-clause BSD-3-clause BSD-4-clause GPL-2 GPL-2+ GPL-3 GPL-3+ LGPL LGPL-2 LGPL-2+ LGPL-2.1 LGPL-2.1+ LGPL-3 LGPL-3+ MIT public-domain",
        "origin": "Debian util-linux Maintainers <ah-util-linux@debian.org> (maintainer)",
        "release": "N/A",
        "size": "444000",
        "sourcepkg": "util-linux",
        "type": "dpkg",
        "version": "2.29.2-1+deb9u1",
    },
    "multiarch-support": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:multiarch-support:multiarch-support:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:multiarch_support:multiarch-support:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:multiarch-support:multiarch_support:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:multiarch_support:multiarch_support:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:multiarch:multiarch-support:2.24-11+deb9u4:*:*:*:*:*:*:*",
            "cpe:2.3:a:multiarch:multiarch_support:2.24-11+deb9u4:*:*:*:*:*:*:*",
        ],
        "license": "GPL-2 LGPL-2.1",
        "origin": "GNU Libc Maintainers <debian-glibc@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "221000",
        "sourcepkg": "glibc",
        "type": "dpkg",
        "version": "2.24-11+deb9u4",
    },
    "ncurses-base": {
        "arch": "all",
        "cpes": [
            "cpe:2.3:a:ncurses-base:ncurses-base:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses_base:ncurses-base:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses-base:ncurses_base:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses_base:ncurses_base:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses:ncurses-base:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses:ncurses_base:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
        ],
        "license": "Unknown",
        "origin": "Craig Small <csmall@debian.org> (maintainer)",
        "release": "N/A",
        "size": "340000",
        "sourcepkg": "ncurses",
        "type": "dpkg",
        "version": "6.0+20161126-1+deb9u2",
    },
    "ncurses-bin": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:ncurses-bin:ncurses-bin:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses_bin:ncurses-bin:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses-bin:ncurses_bin:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses_bin:ncurses_bin:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses:ncurses-bin:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses:ncurses_bin:6.0+20161126-1+deb9u2:*:*:*:*:*:*:*",
        ],
        "license": "Unknown",
        "origin": "Craig Small <csmall@debian.org> (maintainer)",
        "release": "N/A",
        "size": "536000",
        "sourcepkg": "ncurses",
        "type": "dpkg",
        "version": "6.0+20161126-1+deb9u2",
    },
    "passwd": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:passwd:passwd:1:4.4-4.1:*:*:*:*:*:*:*"],
        "license": "GPL-2",
        "origin": "Shadow package maintainers <pkg-shadow-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "2478000",
        "sourcepkg": "shadow",
        "type": "dpkg",
        "version": "1:4.4-4.1",
    },
    "perl-base": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:perl-base:perl-base:5.24.1-3+deb9u7:*:*:*:*:*:*:*",
            "cpe:2.3:a:perl_base:perl-base:5.24.1-3+deb9u7:*:*:*:*:*:*:*",
            "cpe:2.3:a:perl-base:perl_base:5.24.1-3+deb9u7:*:*:*:*:*:*:*",
            "cpe:2.3:a:perl_base:perl_base:5.24.1-3+deb9u7:*:*:*:*:*:*:*",
            "cpe:2.3:a:perl:perl-base:5.24.1-3+deb9u7:*:*:*:*:*:*:*",
            "cpe:2.3:a:perl:perl_base:5.24.1-3+deb9u7:*:*:*:*:*:*:*",
        ],
        "license": "Artistic Artistic-2 BSD-3-clause BSD-3-clause-GENERIC BSD-3-clause-with-weird-numbering BSD-4-clause-POWERDOG BZIP DONT-CHANGE-THE-GPL Expat GPL-1 GPL-1+ GPL-2 GPL-2+ GPL-3+-WITH-BISON-EXCEPTION HSIEH-BSD HSIEH-DERIVATIVE LGPL-2.1 REGCOMP REGCOMP, RRA-KEEP-THIS-NOTICE S2P SDBM-PUBLIC-DOMAIN TEXT-TABS Unicode ZLIB",
        "origin": "Niko Tyni <ntyni@debian.org> (maintainer)",
        "release": "N/A",
        "size": "7551000",
        "sourcepkg": "perl",
        "type": "dpkg",
        "version": "5.24.1-3+deb9u7",
    },
    "sed": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:sed:sed:4.4-1:*:*:*:*:*:*:*"],
        "license": "GPL-3",
        "origin": "Clint Adams <clint@debian.org> (maintainer)",
        "release": "N/A",
        "size": "799000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "4.4-1",
    },
    "sensible-utils": {
        "arch": "all",
        "cpes": [
            "cpe:2.3:a:sensible-utils:sensible-utils:0.0.9+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:sensible_utils:sensible-utils:0.0.9+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:sensible-utils:sensible_utils:0.0.9+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:sensible_utils:sensible_utils:0.0.9+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:sensible:sensible-utils:0.0.9+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:sensible:sensible_utils:0.0.9+deb9u1:*:*:*:*:*:*:*",
        ],
        "license": "GPL-2",
        "origin": "Anibal Monsalve Salazar <anibal@debian.org> (maintainer)",
        "release": "N/A",
        "size": "62000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "0.0.9+deb9u1",
    },
    "sysvinit-utils": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:sysvinit-utils:sysvinit-utils:2.88dsf-59.9:*:*:*:*:*:*:*",
            "cpe:2.3:a:sysvinit_utils:sysvinit-utils:2.88dsf-59.9:*:*:*:*:*:*:*",
            "cpe:2.3:a:sysvinit-utils:sysvinit_utils:2.88dsf-59.9:*:*:*:*:*:*:*",
            "cpe:2.3:a:sysvinit_utils:sysvinit_utils:2.88dsf-59.9:*:*:*:*:*:*:*",
            "cpe:2.3:a:sysvinit:sysvinit-utils:2.88dsf-59.9:*:*:*:*:*:*:*",
            "cpe:2.3:a:sysvinit:sysvinit_utils:2.88dsf-59.9:*:*:*:*:*:*:*",
        ],
        "license": "GPL-2",
        "origin": "Debian sysvinit maintainers <pkg-sysvinit-devel@lists.alioth.debian.org> (maintainer)",
        "release": "N/A",
        "size": "110000",
        "sourcepkg": "sysvinit",
        "type": "dpkg",
        "version": "2.88dsf-59.9",
    },
    "tar": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:tar:tar:1.29b-1.1:*:*:*:*:*:*:*"],
        "license": "GPL-2 GPL-3",
        "origin": "Bdale Garbee <bdale@gag.com> (maintainer)",
        "release": "N/A",
        "size": "2770000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "1.29b-1.1",
    },
    "tzdata": {
        "arch": "all",
        "cpes": ["cpe:2.3:a:tzdata:tzdata:2020a-0+deb9u1:*:*:*:*:*:*:*"],
        "license": "Unknown",
        "origin": "GNU Libc Maintainers <debian-glibc@lists.debian.org> (maintainer)",
        "release": "N/A",
        "size": "3032000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "2020a-0+deb9u1",
    },
    "util-linux": {
        "arch": "amd64",
        "cpes": [
            "cpe:2.3:a:util_linux:util-linux:2.29.2-1+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:util-linux:util-linux:2.29.2-1+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:util_linux:util_linux:2.29.2-1+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:util-linux:util_linux:2.29.2-1+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:util:util-linux:2.29.2-1+deb9u1:*:*:*:*:*:*:*",
            "cpe:2.3:a:util:util_linux:2.29.2-1+deb9u1:*:*:*:*:*:*:*",
        ],
        "license": "BSD-2-clause BSD-3-clause BSD-4-clause GPL-2 GPL-2+ GPL-3 GPL-3+ LGPL LGPL-2 LGPL-2+ LGPL-2.1 LGPL-2.1+ LGPL-3 LGPL-3+ MIT public-domain",
        "origin": "Debian util-linux Maintainers <ah-util-linux@debian.org> (maintainer)",
        "release": "N/A",
        "size": "3558000",
        "sourcepkg": "N/A",
        "type": "dpkg",
        "version": "2.29.2-1+deb9u1",
    },
    "zlib1g": {
        "arch": "amd64",
        "cpes": ["cpe:2.3:a:zlib1g:zlib1g:1:1.2.8.dfsg-5:*:*:*:*:*:*:*"],
        "license": "Unknown",
        "origin": "Mark Brown <broonie@debian.org> (maintainer)",
        "release": "N/A",
        "size": "156000",
        "sourcepkg": "zlib",
        "type": "dpkg",
        "version": "1:1.2.8.dfsg-5",
    },
}

pkgs_plus_source_all = {
    "util-linux": "2.29.2-1+deb9u1",
    "debianutils": "4.8.1.1",
    "zlib1g": "1:1.2.8.dfsg-5",
    "libtinfo5": "6.0+20161126-1+deb9u2",
    "libgcc1": "1:6.3.0-18+deb9u1",
    "libpam-modules-bin": "1.1.8-3.6",
    "attr": "1:2.4.47-2",
    "lsb": "9.20161125",
    "libcomerr2": "1.43.4-2+deb9u2",
    "libsemanage": "2.6-2",
}
