pkgfiles_all = {
    "/usr/bin/db_hotbackup": "RPMFILE",
    "/usr/lib64/python3.6/email/_encoded_words.py": "RPMFILE",
    "/usr/lib64/python3.6/urllib/response.py": "RPMFILE",
    "/etc/profile.d/gawk.csh": "RPMFILE",
    "/usr/bin/chacl": "RPMFILE",
    "/usr/bin/find": "RPMFILE",
    "/usr/lib64/gconv/ISO8859-3.so": "RPMFILE",
    "/bin": "RPMFILE",
    "/etc/libaudit.conf": "RPMFILE",
}

pkgs_all = {
    "pam": "1.3.1-8.el8",
    "crontabs": "1.11-16.20150630git.el8",
    "rpm": "4.14.2-37.el8",
    "libseccomp": "2.4.1-1.el8",
    "zlib": "1.2.11-13.el8",
    "libfdisk": "2.32.1-22.el8",
    "libnghttp2": "1.33.0-3.el8_2.1",
    "audit-libs": "3.0-0.17.20191104git1c2f876.el8",
    "gmp": "1:6.1.2-10.el8",
    "libdb": "5.3.28-37.el8",
}

pkgs_allinfo = {
    "acl": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:acl:2.2.53-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:acl:acl:2.2.53-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "205740",
        "sourcepkg": "acl-2.2.53-1.el8.src.rpm",
        "type": "rpm",
        "version": "2.2.53",
    },
    "audit-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:audit-libs:audit_libs:3.0-0.17.20191104git1c2f876.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:audit_libs:audit-libs:3.0-0.17.20191104git1c2f876.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:audit_libs:audit_libs:3.0-0.17.20191104git1c2f876.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:audit-libs:audit-libs:3.0-0.17.20191104git1c2f876.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:audit-libs:3.0-0.17.20191104git1c2f876.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:audit_libs:3.0-0.17.20191104git1c2f876.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:audit:audit_libs:3.0-0.17.20191104git1c2f876.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:audit:audit-libs:3.0-0.17.20191104git1c2f876.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "0.17.20191104git1c2f876.el8",
        "size": "283708",
        "sourcepkg": "audit-3.0-0.17.20191104git1c2f876.el8.src.rpm",
        "type": "rpm",
        "version": "3.0",
    },
    "basesystem": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:basesystem:basesystem:11-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:basesystem:11-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "0",
        "sourcepkg": "basesystem-11-5.el8.src.rpm",
        "type": "rpm",
        "version": "11",
    },
    "bash": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:bash:4.4.19-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:bash:bash:4.4.19-10.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "10.el8",
        "size": "6930068",
        "sourcepkg": "bash-4.4.19-10.el8.src.rpm",
        "type": "rpm",
        "version": "4.4.19",
    },
    "bind-export-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:bind_export_libs:bind-export-libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:bind-export-libs:bind-export-libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:bind_export_libs:bind_export_libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:bind-export-libs:bind_export_libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:bind-export:bind-export-libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:bind_export:bind-export-libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:bind-export:bind_export_libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:bind_export:bind_export_libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:bind-export-libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:bind_export_libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:bind:bind-export-libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:bind:bind_export_libs:32:9.11.13-5.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "MPLv2.0",
        "origin": "CentOS",
        "release": "5.el8_2",
        "size": "3067121",
        "sourcepkg": "bind-9.11.13-5.el8_2.src.rpm",
        "type": "rpm",
        "version": "32:9.11.13",
    },
    "binutils": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:binutils:binutils:2.30-73.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:binutils:2.30-73.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "73.el8",
        "size": "24856745",
        "sourcepkg": "binutils-2.30-73.el8.src.rpm",
        "type": "rpm",
        "version": "2.30",
    },
    "bzip2-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:bzip2_libs:bzip2_libs:1.0.6-26.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:bzip2-libs:bzip2-libs:1.0.6-26.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:bzip2_libs:bzip2-libs:1.0.6-26.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:bzip2-libs:bzip2_libs:1.0.6-26.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:bzip2-libs:1.0.6-26.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:bzip2_libs:1.0.6-26.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:bzip2:bzip2_libs:1.0.6-26.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:bzip2:bzip2-libs:1.0.6-26.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "26.el8",
        "size": "77229",
        "sourcepkg": "bzip2-1.0.6-26.el8.src.rpm",
        "type": "rpm",
        "version": "1.0.6",
    },
    "ca-certificates": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:ca-certificates:ca-certificates:2019.2.32-80.0.el8_1:*:*:*:*:*:*:*",
            "cpe:2.3:a:ca_certificates:ca-certificates:2019.2.32-80.0.el8_1:*:*:*:*:*:*:*",
            "cpe:2.3:a:ca-certificates:ca_certificates:2019.2.32-80.0.el8_1:*:*:*:*:*:*:*",
            "cpe:2.3:a:ca_certificates:ca_certificates:2019.2.32-80.0.el8_1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ca-certificates:2019.2.32-80.0.el8_1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ca_certificates:2019.2.32-80.0.el8_1:*:*:*:*:*:*:*",
            "cpe:2.3:a:ca:ca-certificates:2019.2.32-80.0.el8_1:*:*:*:*:*:*:*",
            "cpe:2.3:a:ca:ca_certificates:2019.2.32-80.0.el8_1:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain",
        "origin": "CentOS",
        "release": "80.0.el8_1",
        "size": "993761",
        "sourcepkg": "ca-certificates-2019.2.32-80.0.el8_1.src.rpm",
        "type": "rpm",
        "version": "2019.2.32",
    },
    "centos-gpg-keys": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:centos_gpg_keys:centos-gpg-keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos_gpg_keys:centos_gpg_keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos-gpg-keys:centos_gpg_keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos-gpg-keys:centos-gpg-keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos-gpg:centos_gpg_keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos-gpg:centos-gpg-keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos_gpg:centos-gpg-keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos_gpg:centos_gpg_keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:centos_gpg_keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:centos-gpg-keys:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2",
        "origin": "CentOS",
        "release": "2.2004.0.1.el8",
        "size": "3370",
        "sourcepkg": "centos-release-8.2-2.2004.0.1.el8.src.rpm",
        "type": "rpm",
        "version": "8.2",
    },
    "centos-release": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos-release:centos-release:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos_release:centos-release:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos-release:centos_release:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos_release:centos_release:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:centos-release:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:centos_release:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2",
        "origin": "CentOS",
        "release": "2.2004.0.1.el8",
        "size": "25430",
        "sourcepkg": "centos-release-8.2-2.2004.0.1.el8.src.rpm",
        "type": "rpm",
        "version": "8.2",
    },
    "centos-repos": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos-repos:centos-repos:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos_repos:centos-repos:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos-repos:centos_repos:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos_repos:centos_repos:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:centos-repos:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:centos_repos:8.2-2.2004.0.1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2",
        "origin": "CentOS",
        "release": "2.2004.0.1.el8",
        "size": "9660",
        "sourcepkg": "centos-release-8.2-2.2004.0.1.el8.src.rpm",
        "type": "rpm",
        "version": "8.2",
    },
    "chkconfig": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:chkconfig:chkconfig:1.11-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:chkconfig:1.11-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "791234",
        "sourcepkg": "chkconfig-1.11-1.el8.src.rpm",
        "type": "rpm",
        "version": "1.11",
    },
    "coreutils-single": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:coreutils_single:coreutils-single:8.30-7.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:coreutils-single:coreutils-single:8.30-7.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:coreutils_single:coreutils_single:8.30-7.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:coreutils-single:coreutils_single:8.30-7.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:coreutils:coreutils-single:8.30-7.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:coreutils:coreutils_single:8.30-7.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:coreutils-single:8.30-7.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:coreutils_single:8.30-7.el8_2.1:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "7.el8_2.1",
        "size": "1356273",
        "sourcepkg": "coreutils-8.30-7.el8_2.1.src.rpm",
        "type": "rpm",
        "version": "8.30",
    },
    "cpio": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:cpio:2.12-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cpio:cpio:2.12-8.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "8.el8",
        "size": "989536",
        "sourcepkg": "cpio-2.12-8.el8.src.rpm",
        "type": "rpm",
        "version": "2.12",
    },
    "cracklib": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:cracklib:cracklib:2.9.6-15.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:cracklib:2.9.6-15.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "15.el8",
        "size": "239047",
        "sourcepkg": "cracklib-2.9.6-15.el8.src.rpm",
        "type": "rpm",
        "version": "2.9.6",
    },
    "cronie": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:cronie:cronie:1.5.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:cronie:1.5.2-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT and BSD and ISC and GPLv2+",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "324627",
        "sourcepkg": "cronie-1.5.2-4.el8.src.rpm",
        "type": "rpm",
        "version": "1.5.2",
    },
    "cronie-anacron": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:cronie_anacron:cronie_anacron:1.5.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cronie-anacron:cronie-anacron:1.5.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cronie_anacron:cronie-anacron:1.5.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cronie-anacron:cronie_anacron:1.5.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:cronie-anacron:1.5.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cronie:cronie_anacron:1.5.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cronie:cronie-anacron:1.5.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:cronie_anacron:1.5.2-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT and BSD and ISC and GPLv2+",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "50528",
        "sourcepkg": "cronie-1.5.2-4.el8.src.rpm",
        "type": "rpm",
        "version": "1.5.2",
    },
    "crontabs": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:crontabs:crontabs:1.11-16.20150630git.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:crontabs:1.11-16.20150630git.el8:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain and GPLv2",
        "origin": "CentOS",
        "release": "16.20150630git.el8",
        "size": "21439",
        "sourcepkg": "crontabs-1.11-16.20150630git.el8.src.rpm",
        "type": "rpm",
        "version": "1.11",
    },
    "crypto-policies": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:crypto_policies:crypto-policies:20191128-2.git23e1bf1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:crypto-policies:crypto_policies:20191128-2.git23e1bf1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:crypto-policies:crypto-policies:20191128-2.git23e1bf1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:crypto_policies:crypto_policies:20191128-2.git23e1bf1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:crypto:crypto-policies:20191128-2.git23e1bf1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:crypto_policies:20191128-2.git23e1bf1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:crypto:crypto_policies:20191128-2.git23e1bf1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:crypto-policies:20191128-2.git23e1bf1.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "2.git23e1bf1.el8",
        "size": "190228",
        "sourcepkg": "crypto-policies-20191128-2.git23e1bf1.el8.src.rpm",
        "type": "rpm",
        "version": "20191128",
    },
    "cryptsetup-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:cryptsetup_libs:cryptsetup_libs:2.2.2-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cryptsetup-libs:cryptsetup-libs:2.2.2-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cryptsetup_libs:cryptsetup-libs:2.2.2-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cryptsetup-libs:cryptsetup_libs:2.2.2-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cryptsetup:cryptsetup_libs:2.2.2-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cryptsetup:cryptsetup-libs:2.2.2-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:cryptsetup-libs:2.2.2-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:cryptsetup_libs:2.2.2-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and LGPLv2+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "1871402",
        "sourcepkg": "cryptsetup-2.2.2-1.el8.src.rpm",
        "type": "rpm",
        "version": "2.2.2",
    },
    "curl": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:curl:7.61.1-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:curl:curl:7.61.1-12.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "12.el8",
        "size": "709006",
        "sourcepkg": "curl-7.61.1-12.el8.src.rpm",
        "type": "rpm",
        "version": "7.61.1",
    },
    "cyrus-sasl-lib": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:cyrus-sasl-lib:cyrus-sasl-lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cyrus_sasl_lib:cyrus-sasl-lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cyrus-sasl-lib:cyrus_sasl_lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cyrus_sasl_lib:cyrus_sasl_lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cyrus-sasl:cyrus-sasl-lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cyrus_sasl:cyrus-sasl-lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cyrus-sasl:cyrus_sasl_lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cyrus_sasl:cyrus_sasl_lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:cyrus-sasl-lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:cyrus_sasl_lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cyrus:cyrus-sasl-lib:2.1.27-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:cyrus:cyrus_sasl_lib:2.1.27-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD with advertising",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "734978",
        "sourcepkg": "cyrus-sasl-2.1.27-1.el8.src.rpm",
        "type": "rpm",
        "version": "2.1.27",
    },
    "dbus": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:dbus:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus:dbus:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "(GPLv2+ or AFL) and GPLv2+",
        "origin": "CentOS",
        "release": "10.el8_2",
        "size": "0",
        "sourcepkg": "dbus-1.12.8-10.el8_2.src.rpm",
        "type": "rpm",
        "version": "1:1.12.8",
    },
    "dbus-common": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:dbus_common:dbus-common:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus-common:dbus_common:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus-common:dbus-common:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus_common:dbus_common:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dbus_common:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dbus-common:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus:dbus-common:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus:dbus_common:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "(GPLv2+ or AFL) and GPLv2+",
        "origin": "CentOS",
        "release": "10.el8_2",
        "size": "11131",
        "sourcepkg": "dbus-1.12.8-10.el8_2.src.rpm",
        "type": "rpm",
        "version": "1:1.12.8",
    },
    "dbus-daemon": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:dbus-daemon:dbus-daemon:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus_daemon:dbus-daemon:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus-daemon:dbus_daemon:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus_daemon:dbus_daemon:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dbus-daemon:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dbus_daemon:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus:dbus-daemon:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus:dbus_daemon:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "(GPLv2+ or AFL) and GPLv2+",
        "origin": "CentOS",
        "release": "10.el8_2",
        "size": "560056",
        "sourcepkg": "dbus-1.12.8-10.el8_2.src.rpm",
        "type": "rpm",
        "version": "1:1.12.8",
    },
    "dbus-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:dbus-libs:dbus_libs:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus_libs:dbus_libs:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus-libs:dbus-libs:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus_libs:dbus-libs:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dbus_libs:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dbus-libs:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus:dbus_libs:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus:dbus-libs:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "(GPLv2+ or AFL) and GPLv2+",
        "origin": "CentOS",
        "release": "10.el8_2",
        "size": "380576",
        "sourcepkg": "dbus-1.12.8-10.el8_2.src.rpm",
        "type": "rpm",
        "version": "1:1.12.8",
    },
    "dbus-tools": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:dbus-tools:dbus_tools:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus_tools:dbus_tools:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus-tools:dbus-tools:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus_tools:dbus-tools:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dbus_tools:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dbus-tools:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus:dbus_tools:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dbus:dbus-tools:1:1.12.8-10.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "(GPLv2+ or AFL) and GPLv2+",
        "origin": "CentOS",
        "release": "10.el8_2",
        "size": "125490",
        "sourcepkg": "dbus-1.12.8-10.el8_2.src.rpm",
        "type": "rpm",
        "version": "1:1.12.8",
    },
    "device-mapper": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:device_mapper:device-mapper:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device-mapper:device-mapper:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device_mapper:device_mapper:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device-mapper:device_mapper:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:device-mapper:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device:device-mapper:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:device_mapper:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device:device_mapper:8:1.02.169-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "355102",
        "sourcepkg": "lvm2-2.03.08-3.el8.src.rpm",
        "type": "rpm",
        "version": "8:1.02.169",
    },
    "device-mapper-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:device-mapper-libs:device-mapper-libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device_mapper_libs:device-mapper-libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device-mapper-libs:device_mapper_libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device_mapper_libs:device_mapper_libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device-mapper:device-mapper-libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device_mapper:device-mapper-libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device-mapper:device_mapper_libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device_mapper:device_mapper_libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:device-mapper-libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device:device-mapper-libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:device_mapper_libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:device:device_mapper_libs:8:1.02.169-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "416167",
        "sourcepkg": "lvm2-2.03.08-3.el8.src.rpm",
        "type": "rpm",
        "version": "8:1.02.169",
    },
    "dhcp-client": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:dhcp-client:dhcp_client:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp_client:dhcp-client:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp-client:dhcp-client:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp_client:dhcp_client:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dhcp-client:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dhcp_client:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp:dhcp_client:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp:dhcp-client:12:4.3.6-40.el8:*:*:*:*:*:*:*",
        ],
        "license": "ISC",
        "origin": "CentOS",
        "release": "40.el8",
        "size": "530732",
        "sourcepkg": "dhcp-4.3.6-40.el8.src.rpm",
        "type": "rpm",
        "version": "12:4.3.6",
    },
    "dhcp-common": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:dhcp-common:dhcp_common:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp_common:dhcp_common:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp-common:dhcp-common:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp_common:dhcp-common:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dhcp_common:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dhcp-common:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp:dhcp_common:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp:dhcp-common:12:4.3.6-40.el8:*:*:*:*:*:*:*",
        ],
        "license": "ISC",
        "origin": "CentOS",
        "release": "40.el8",
        "size": "301814",
        "sourcepkg": "dhcp-4.3.6-40.el8.src.rpm",
        "type": "rpm",
        "version": "12:4.3.6",
    },
    "dhcp-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:dhcp_libs:dhcp_libs:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp-libs:dhcp-libs:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp_libs:dhcp-libs:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp-libs:dhcp_libs:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dhcp-libs:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dhcp_libs:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp:dhcp_libs:12:4.3.6-40.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dhcp:dhcp-libs:12:4.3.6-40.el8:*:*:*:*:*:*:*",
        ],
        "license": "ISC",
        "origin": "CentOS",
        "release": "40.el8",
        "size": "161256",
        "sourcepkg": "dhcp-4.3.6-40.el8.src.rpm",
        "type": "rpm",
        "version": "12:4.3.6",
    },
    "dnf": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:centos:dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dnf:dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and GPLv2 and GPL",
        "origin": "CentOS",
        "release": "7.el8_2",
        "size": "1670640",
        "sourcepkg": "dnf-4.2.17-7.el8_2.src.rpm",
        "type": "rpm",
        "version": "4.2.17",
    },
    "dnf-data": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:dnf-data:dnf_data:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dnf_data:dnf_data:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dnf-data:dnf-data:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dnf_data:dnf-data:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dnf_data:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dnf-data:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dnf:dnf_data:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:dnf:dnf-data:4.2.17-7.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and GPLv2 and GPL",
        "origin": "CentOS",
        "release": "7.el8_2",
        "size": "36254",
        "sourcepkg": "dnf-4.2.17-7.el8_2.src.rpm",
        "type": "rpm",
        "version": "4.2.17",
    },
    "dracut": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:dracut:dracut:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dracut:049-70.git20200228.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and LGPLv2+",
        "origin": "CentOS",
        "release": "70.git20200228.el8",
        "size": "1046582",
        "sourcepkg": "dracut-049-70.git20200228.el8.src.rpm",
        "type": "rpm",
        "version": "049",
    },
    "dracut-network": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:dracut_network:dracut_network:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut-network:dracut-network:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut_network:dracut-network:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut-network:dracut_network:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dracut-network:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut:dracut_network:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut:dracut-network:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dracut_network:049-70.git20200228.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and LGPLv2+",
        "origin": "CentOS",
        "release": "70.git20200228.el8",
        "size": "160704",
        "sourcepkg": "dracut-049-70.git20200228.el8.src.rpm",
        "type": "rpm",
        "version": "049",
    },
    "dracut-squash": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:dracut-squash:dracut_squash:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut_squash:dracut_squash:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut-squash:dracut-squash:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut_squash:dracut-squash:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dracut_squash:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut:dracut_squash:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:dracut-squash:049-70.git20200228.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:dracut:dracut-squash:049-70.git20200228.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and LGPLv2+",
        "origin": "CentOS",
        "release": "70.git20200228.el8",
        "size": "3054",
        "sourcepkg": "dracut-049-70.git20200228.el8.src.rpm",
        "type": "rpm",
        "version": "049",
    },
    "elfutils-default-yama-scope": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:elfutils-default-yama-scope:elfutils-default-yama-scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils_default_yama_scope:elfutils-default-yama-scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils_default_yama_scope:elfutils_default_yama_scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils-default-yama-scope:elfutils_default_yama_scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils-default-yama:elfutils-default-yama-scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils-default-yama:elfutils_default_yama_scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils_default_yama:elfutils-default-yama-scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils_default_yama:elfutils_default_yama_scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils_default:elfutils_default_yama_scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils_default:elfutils-default-yama-scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils-default:elfutils-default-yama-scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils-default:elfutils_default_yama_scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils:elfutils_default_yama_scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils:elfutils-default-yama-scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:elfutils_default_yama_scope:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:elfutils-default-yama-scope:0.178-7.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ or LGPLv3+",
        "origin": "CentOS",
        "release": "7.el8",
        "size": "1810",
        "sourcepkg": "elfutils-0.178-7.el8.src.rpm",
        "type": "rpm",
        "version": "0.178",
    },
    "elfutils-libelf": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:elfutils_libelf:elfutils-libelf:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils-libelf:elfutils_libelf:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils-libelf:elfutils-libelf:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils_libelf:elfutils_libelf:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils:elfutils-libelf:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils:elfutils_libelf:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:elfutils_libelf:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:elfutils-libelf:0.178-7.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ or LGPLv3+",
        "origin": "CentOS",
        "release": "7.el8",
        "size": "920699",
        "sourcepkg": "elfutils-0.178-7.el8.src.rpm",
        "type": "rpm",
        "version": "0.178",
    },
    "elfutils-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:elfutils-libs:elfutils_libs:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils_libs:elfutils_libs:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils-libs:elfutils-libs:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils_libs:elfutils-libs:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils:elfutils_libs:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:elfutils:elfutils-libs:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:elfutils_libs:0.178-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:elfutils-libs:0.178-7.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ or LGPLv3+",
        "origin": "CentOS",
        "release": "7.el8",
        "size": "717567",
        "sourcepkg": "elfutils-0.178-7.el8.src.rpm",
        "type": "rpm",
        "version": "0.178",
    },
    "ethtool": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:ethtool:ethtool:2:5.0-2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ethtool:2:5.0-2.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2",
        "origin": "CentOS",
        "release": "2.el8",
        "size": "502623",
        "sourcepkg": "ethtool-5.0-2.el8.src.rpm",
        "type": "rpm",
        "version": "2:5.0",
    },
    "expat": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:expat:2.2.5-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:expat:expat:2.2.5-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "314068",
        "sourcepkg": "expat-2.2.5-3.el8.src.rpm",
        "type": "rpm",
        "version": "2.2.5",
    },
    "file-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:file-libs:file_libs:5.33-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:file_libs:file-libs:5.33-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:file-libs:file-libs:5.33-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:file_libs:file_libs:5.33-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:file-libs:5.33-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:file_libs:5.33-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:file:file_libs:5.33-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:file:file-libs:5.33-13.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "13.el8",
        "size": "6382974",
        "sourcepkg": "file-5.33-13.el8.src.rpm",
        "type": "rpm",
        "version": "5.33",
    },
    "filesystem": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:filesystem:filesystem:3.8-2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:filesystem:3.8-2.el8:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain",
        "origin": "CentOS",
        "release": "2.el8",
        "size": "0",
        "sourcepkg": "filesystem-3.8-2.el8.src.rpm",
        "type": "rpm",
        "version": "3.8",
    },
    "findutils": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:findutils:findutils:1:4.6.0-20.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:findutils:1:4.6.0-20.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "20.el8",
        "size": "1816673",
        "sourcepkg": "findutils-4.6.0-20.el8.src.rpm",
        "type": "rpm",
        "version": "1:4.6.0",
    },
    "gawk": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:gawk:4.2.1-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:gawk:gawk:4.2.1-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+ and GPLv2+ and LGPLv2+ and BSD",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "2717614",
        "sourcepkg": "gawk-4.2.1-1.el8.src.rpm",
        "type": "rpm",
        "version": "4.2.1",
    },
    "gdbm": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:gdbm:1:1.18-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:gdbm:gdbm:1:1.18-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "399977",
        "sourcepkg": "gdbm-1.18-1.el8.src.rpm",
        "type": "rpm",
        "version": "1:1.18",
    },
    "gdbm-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:gdbm-libs:gdbm-libs:1:1.18-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:gdbm_libs:gdbm-libs:1:1.18-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:gdbm-libs:gdbm_libs:1:1.18-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:gdbm_libs:gdbm_libs:1:1.18-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:gdbm-libs:1:1.18-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:gdbm_libs:1:1.18-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:gdbm:gdbm-libs:1:1.18-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:gdbm:gdbm_libs:1:1.18-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "135248",
        "sourcepkg": "gdbm-1.18-1.el8.src.rpm",
        "type": "rpm",
        "version": "1:1.18",
    },
    "glib2": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:glib2:2.56.4-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glib2:glib2:2.56.4-8.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "8.el8",
        "size": "12272168",
        "sourcepkg": "glib2-2.56.4-8.el8.src.rpm",
        "type": "rpm",
        "version": "2.56.4",
    },
    "glibc": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:glibc:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc:glibc:2.28-101.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL",
        "origin": "CentOS",
        "release": "101.el8",
        "size": "17885631",
        "sourcepkg": "glibc-2.28-101.el8.src.rpm",
        "type": "rpm",
        "version": "2.28",
    },
    "glibc-common": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:glibc-common:glibc_common:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc_common:glibc_common:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc-common:glibc-common:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc_common:glibc-common:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:glibc_common:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:glibc-common:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc:glibc_common:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc:glibc-common:2.28-101.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL",
        "origin": "CentOS",
        "release": "101.el8",
        "size": "9531204",
        "sourcepkg": "glibc-2.28-101.el8.src.rpm",
        "type": "rpm",
        "version": "2.28",
    },
    "glibc-minimal-langpack": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:glibc-minimal-langpack:glibc-minimal-langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc_minimal_langpack:glibc-minimal-langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc-minimal-langpack:glibc_minimal_langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc_minimal_langpack:glibc_minimal_langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc-minimal:glibc-minimal-langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc_minimal:glibc-minimal-langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc-minimal:glibc_minimal_langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc_minimal:glibc_minimal_langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:glibc-minimal-langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:glibc_minimal_langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc:glibc-minimal-langpack:2.28-101.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:glibc:glibc_minimal_langpack:2.28-101.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL",
        "origin": "CentOS",
        "release": "101.el8",
        "size": "0",
        "sourcepkg": "glibc-2.28-101.el8.src.rpm",
        "type": "rpm",
        "version": "2.28",
    },
    "gmp": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:gmp:1:6.1.2-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:gmp:gmp:1:6.1.2-10.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv3+ or GPLv2+",
        "origin": "CentOS",
        "release": "10.el8",
        "size": "1678740",
        "sourcepkg": "gmp-6.1.2-10.el8.src.rpm",
        "type": "rpm",
        "version": "1:6.1.2",
    },
    "gnupg2": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:gnupg2:gnupg2:2.2.9-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:gnupg2:2.2.9-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "9632671",
        "sourcepkg": "gnupg2-2.2.9-1.el8.src.rpm",
        "type": "rpm",
        "version": "2.2.9",
    },
    "gnutls": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:gnutls:3.6.8-11.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:gnutls:gnutls:3.6.8-11.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+ and LGPLv2+",
        "origin": "CentOS",
        "release": "11.el8_2",
        "size": "2687433",
        "sourcepkg": "gnutls-3.6.8-11.el8_2.src.rpm",
        "type": "rpm",
        "version": "3.6.8",
    },
    "gpg-pubkey": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:gpg-pubkey:gpg_pubkey:8483c65d-5ccc5b19:*:*:*:*:*:*:*",
            "cpe:2.3:a:gpg_pubkey:gpg_pubkey:8483c65d-5ccc5b19:*:*:*:*:*:*:*",
            "cpe:2.3:a:gpg-pubkey:gpg-pubkey:8483c65d-5ccc5b19:*:*:*:*:*:*:*",
            "cpe:2.3:a:gpg_pubkey:gpg-pubkey:8483c65d-5ccc5b19:*:*:*:*:*:*:*",
            "cpe:2.3:a:gpg:gpg_pubkey:8483c65d-5ccc5b19:*:*:*:*:*:*:*",
            "cpe:2.3:a:gpg:gpg-pubkey:8483c65d-5ccc5b19:*:*:*:*:*:*:*",
        ],
        "license": "pubkey",
        "origin": "(none)",
        "release": "5ccc5b19",
        "size": "0",
        "sourcepkg": "N/A",
        "type": "rpm",
        "version": "8483c65d",
    },
    "gpgme": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:gpgme:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:gpgme:gpgme:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "6.el8.0.1",
        "size": "741097",
        "sourcepkg": "gpgme-1.10.0-6.el8.0.1.src.rpm",
        "type": "rpm",
        "version": "1.10.0",
    },
    "grep": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:grep:3.1-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:grep:grep:3.1-6.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "6.el8",
        "size": "835205",
        "sourcepkg": "grep-3.1-6.el8.src.rpm",
        "type": "rpm",
        "version": "3.1",
    },
    "gzip": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:gzip:1.9-9.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:gzip:gzip:1.9-9.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+ and GFDL",
        "origin": "CentOS",
        "release": "9.el8",
        "size": "426515",
        "sourcepkg": "gzip-1.9-9.el8.src.rpm",
        "type": "rpm",
        "version": "1.9",
    },
    "hostname": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:hostname:hostname:3.20-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:hostname:3.20-6.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "6.el8",
        "size": "43979",
        "sourcepkg": "hostname-3.20-6.el8.src.rpm",
        "type": "rpm",
        "version": "3.20",
    },
    "ima-evm-utils": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:ima-evm-utils:ima-evm-utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ima_evm_utils:ima-evm-utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ima-evm-utils:ima_evm_utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ima_evm_utils:ima_evm_utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ima-evm:ima-evm-utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ima_evm:ima-evm-utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ima-evm:ima_evm_utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ima_evm:ima_evm_utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ima-evm-utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ima_evm_utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ima:ima-evm-utils:1.1-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ima:ima_evm_utils:1.1-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "123538",
        "sourcepkg": "ima-evm-utils-1.1-5.el8.src.rpm",
        "type": "rpm",
        "version": "1.1",
    },
    "info": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:info:6.5-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:info:info:6.5-6.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "6.el8",
        "size": "386513",
        "sourcepkg": "texinfo-6.5-6.el8.src.rpm",
        "type": "rpm",
        "version": "6.5",
    },
    "ipcalc": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:ipcalc:ipcalc:0.2.4-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ipcalc:0.2.4-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "67705",
        "sourcepkg": "ipcalc-0.2.4-4.el8.src.rpm",
        "type": "rpm",
        "version": "0.2.4",
    },
    "iproute": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:iproute:iproute:5.3.0-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:iproute:5.3.0-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and Public Domain",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "1894954",
        "sourcepkg": "iproute-5.3.0-1.el8.src.rpm",
        "type": "rpm",
        "version": "5.3.0",
    },
    "iptables-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:iptables-libs:iptables-libs:1.8.4-10.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:iptables_libs:iptables-libs:1.8.4-10.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:iptables-libs:iptables_libs:1.8.4-10.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:iptables_libs:iptables_libs:1.8.4-10.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:iptables:iptables-libs:1.8.4-10.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:iptables:iptables_libs:1.8.4-10.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:iptables-libs:1.8.4-10.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:iptables_libs:1.8.4-10.el8_2.1:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2 and Artistic 2.0 and ISC",
        "origin": "CentOS",
        "release": "10.el8_2.1",
        "size": "201920",
        "sourcepkg": "iptables-1.8.4-10.el8_2.1.src.rpm",
        "type": "rpm",
        "version": "1.8.4",
    },
    "iputils": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:iputils:iputils:20180629-2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:iputils:20180629-2.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD and GPLv2+",
        "origin": "CentOS",
        "release": "2.el8",
        "size": "351665",
        "sourcepkg": "iputils-20180629-2.el8.src.rpm",
        "type": "rpm",
        "version": "20180629",
    },
    "json-c": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:json-c:json_c:0.13.1-0.2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:json_c:json-c:0.13.1-0.2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:json-c:json-c:0.13.1-0.2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:json-c:0.13.1-0.2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:json_c:json_c:0.13.1-0.2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:json_c:0.13.1-0.2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:json:json_c:0.13.1-0.2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:json:json-c:0.13.1-0.2.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "0.2.el8",
        "size": "73898",
        "sourcepkg": "json-c-0.13.1-0.2.el8.src.rpm",
        "type": "rpm",
        "version": "0.13.1",
    },
    "kexec-tools": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:kexec-tools:kexec-tools:2.0.20-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kexec_tools:kexec-tools:2.0.20-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kexec-tools:kexec_tools:2.0.20-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kexec_tools:kexec_tools:2.0.20-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:kexec-tools:2.0.20-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:kexec_tools:2.0.20-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kexec:kexec-tools:2.0.20-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kexec:kexec_tools:2.0.20-14.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2",
        "origin": "CentOS",
        "release": "14.el8",
        "size": "1222009",
        "sourcepkg": "kexec-tools-2.0.20-14.el8.src.rpm",
        "type": "rpm",
        "version": "2.0.20",
    },
    "keyutils-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:keyutils-libs:keyutils_libs:1.5.10-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:keyutils_libs:keyutils_libs:1.5.10-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:keyutils-libs:keyutils-libs:1.5.10-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:keyutils_libs:keyutils-libs:1.5.10-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:keyutils:keyutils_libs:1.5.10-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:keyutils:keyutils-libs:1.5.10-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:keyutils_libs:1.5.10-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:keyutils-libs:1.5.10-6.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and LGPLv2+",
        "origin": "CentOS",
        "release": "6.el8",
        "size": "43926",
        "sourcepkg": "keyutils-1.5.10-6.el8.src.rpm",
        "type": "rpm",
        "version": "1.5.10",
    },
    "kmod": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:kmod:25-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kmod:kmod:25-16.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "16.el8",
        "size": "243998",
        "sourcepkg": "kmod-25-16.el8.src.rpm",
        "type": "rpm",
        "version": "25",
    },
    "kmod-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:kmod_libs:kmod_libs:25-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kmod-libs:kmod-libs:25-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kmod_libs:kmod-libs:25-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kmod-libs:kmod_libs:25-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:kmod-libs:25-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:kmod_libs:25-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kmod:kmod_libs:25-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:kmod:kmod-libs:25-16.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "16.el8",
        "size": "126640",
        "sourcepkg": "kmod-25-16.el8.src.rpm",
        "type": "rpm",
        "version": "25",
    },
    "krb5-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:krb5_libs:krb5_libs:1.17-18.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:krb5-libs:krb5_libs:1.17-18.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:krb5_libs:krb5-libs:1.17-18.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:krb5-libs:krb5-libs:1.17-18.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:krb5_libs:1.17-18.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:krb5-libs:1.17-18.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:krb5:krb5_libs:1.17-18.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:krb5:krb5-libs:1.17-18.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "18.el8",
        "size": "2259532",
        "sourcepkg": "krb5-1.17-18.el8.src.rpm",
        "type": "rpm",
        "version": "1.17",
    },
    "langpacks-en": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:langpacks_en:langpacks-en:1.0-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:langpacks-en:langpacks-en:1.0-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:langpacks_en:langpacks_en:1.0-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:langpacks-en:langpacks_en:1.0-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:langpacks:langpacks-en:1.0-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:langpacks:langpacks_en:1.0-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:langpacks-en:1.0-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:langpacks_en:1.0-12.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "12.el8",
        "size": "400",
        "sourcepkg": "langpacks-1.0-12.el8.src.rpm",
        "type": "rpm",
        "version": "1.0",
    },
    "less": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:less:530-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:less:less:530-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+ or BSD",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "344874",
        "sourcepkg": "less-530-1.el8.src.rpm",
        "type": "rpm",
        "version": "530",
    },
    "libacl": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libacl:libacl:2.2.53-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libacl:2.2.53-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "59272",
        "sourcepkg": "acl-2.2.53-1.el8.src.rpm",
        "type": "rpm",
        "version": "2.2.53",
    },
    "libarchive": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libarchive:libarchive:3.3.2-8.el8_1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libarchive:3.3.2-8.el8_1:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "8.el8_1",
        "size": "1139914",
        "sourcepkg": "libarchive-3.3.2-8.el8_1.src.rpm",
        "type": "rpm",
        "version": "3.3.2",
    },
    "libassuan": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libassuan:libassuan:2.5.1-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libassuan:2.5.1-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+ and GPLv3+",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "202763",
        "sourcepkg": "libassuan-2.5.1-3.el8.src.rpm",
        "type": "rpm",
        "version": "2.5.1",
    },
    "libattr": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libattr:libattr:2.4.48-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libattr:2.4.48-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "27346",
        "sourcepkg": "attr-2.4.48-3.el8.src.rpm",
        "type": "rpm",
        "version": "2.4.48",
    },
    "libblkid": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libblkid:libblkid:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libblkid:2.32.1-22.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "22.el8",
        "size": "339680",
        "sourcepkg": "util-linux-2.32.1-22.el8.src.rpm",
        "type": "rpm",
        "version": "2.32.1",
    },
    "libcap": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libcap:libcap:2.26-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libcap:2.26-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "124170",
        "sourcepkg": "libcap-2.26-3.el8.src.rpm",
        "type": "rpm",
        "version": "2.26",
    },
    "libcap-ng": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libcap_ng:libcap_ng:0.7.9-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap-ng:libcap-ng:0.7.9-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap_ng:libcap-ng:0.7.9-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap-ng:libcap_ng:0.7.9-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libcap-ng:0.7.9-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap:libcap_ng:0.7.9-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcap:libcap-ng:0.7.9-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libcap_ng:0.7.9-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "51278",
        "sourcepkg": "libcap-ng-0.7.9-5.el8.src.rpm",
        "type": "rpm",
        "version": "0.7.9",
    },
    "libcom_err": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libcom_err:libcom-err:1.45.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcom-err:libcom_err:1.45.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcom-err:libcom-err:1.45.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcom_err:libcom_err:1.45.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcom:libcom-err:1.45.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libcom_err:1.45.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcom:libcom_err:1.45.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libcom-err:1.45.4-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "61921",
        "sourcepkg": "e2fsprogs-1.45.4-3.el8.src.rpm",
        "type": "rpm",
        "version": "1.45.4",
    },
    "libcomps": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libcomps:libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "217067",
        "sourcepkg": "libcomps-0.1.11-4.el8.src.rpm",
        "type": "rpm",
        "version": "0.1.11",
    },
    "libcurl-minimal": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libcurl-minimal:libcurl_minimal:7.61.1-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcurl_minimal:libcurl_minimal:7.61.1-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcurl-minimal:libcurl-minimal:7.61.1-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcurl_minimal:libcurl-minimal:7.61.1-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcurl:libcurl_minimal:7.61.1-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libcurl:libcurl-minimal:7.61.1-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libcurl_minimal:7.61.1-12.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libcurl-minimal:7.61.1-12.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "12.el8",
        "size": "551776",
        "sourcepkg": "curl-7.61.1-12.el8.src.rpm",
        "type": "rpm",
        "version": "7.61.1",
    },
    "libdb": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:libdb:5.3.28-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libdb:libdb:5.3.28-37.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD and LGPLv2 and Sleepycat",
        "origin": "CentOS",
        "release": "37.el8",
        "size": "2515048",
        "sourcepkg": "libdb-5.3.28-37.el8.src.rpm",
        "type": "rpm",
        "version": "5.3.28",
    },
    "libdb-utils": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libdb-utils:libdb_utils:5.3.28-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libdb_utils:libdb_utils:5.3.28-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libdb-utils:libdb-utils:5.3.28-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libdb_utils:libdb-utils:5.3.28-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libdb_utils:5.3.28-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libdb-utils:5.3.28-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libdb:libdb_utils:5.3.28-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libdb:libdb-utils:5.3.28-37.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD and LGPLv2 and Sleepycat",
        "origin": "CentOS",
        "release": "37.el8",
        "size": "536911",
        "sourcepkg": "libdb-5.3.28-37.el8.src.rpm",
        "type": "rpm",
        "version": "5.3.28",
    },
    "libdnf": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libdnf:libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "6.el8_2",
        "size": "2123765",
        "sourcepkg": "libdnf-0.39.1-6.el8_2.src.rpm",
        "type": "rpm",
        "version": "0.39.1",
    },
    "libfdisk": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libfdisk:libfdisk:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libfdisk:2.32.1-22.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "22.el8",
        "size": "438722",
        "sourcepkg": "util-linux-2.32.1-22.el8.src.rpm",
        "type": "rpm",
        "version": "2.32.1",
    },
    "libffi": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libffi:libffi:3.1-21.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libffi:3.1-21.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "21.el8",
        "size": "68404",
        "sourcepkg": "libffi-3.1-21.el8.src.rpm",
        "type": "rpm",
        "version": "3.1",
    },
    "libgcc": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:libgcc:8.3.1-5.el8.0.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgcc:libgcc:8.3.1-5.el8.0.2:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD",
        "origin": "CentOS",
        "release": "5.el8.0.2",
        "size": "190232",
        "sourcepkg": "gcc-8.3.1-5.el8.0.2.src.rpm",
        "type": "rpm",
        "version": "8.3.1",
    },
    "libgcrypt": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libgcrypt:libgcrypt:1.8.3-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libgcrypt:1.8.3-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "1547061",
        "sourcepkg": "libgcrypt-1.8.3-4.el8.src.rpm",
        "type": "rpm",
        "version": "1.8.3",
    },
    "libgpg-error": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libgpg-error:libgpg-error:1.31-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg_error:libgpg-error:1.31-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg-error:libgpg_error:1.31-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg_error:libgpg_error:1.31-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libgpg-error:1.31-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg:libgpg-error:1.31-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libgpg_error:1.31-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libgpg:libgpg_error:1.31-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "902818",
        "sourcepkg": "libgpg-error-1.31-1.el8.src.rpm",
        "type": "rpm",
        "version": "1.31",
    },
    "libidn2": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libidn2:libidn2:2.2.0-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libidn2:2.2.0-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "(GPLv2+ or LGPLv3+) and GPLv3+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "287762",
        "sourcepkg": "libidn2-2.2.0-1.el8.src.rpm",
        "type": "rpm",
        "version": "2.2.0",
    },
    "libkcapi": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libkcapi:libkcapi:1.1.1-16_1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libkcapi:1.1.1-16_1.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD or GPLv2",
        "origin": "CentOS",
        "release": "16_1.el8",
        "size": "82828",
        "sourcepkg": "libkcapi-1.1.1-16_1.el8.src.rpm",
        "type": "rpm",
        "version": "1.1.1",
    },
    "libkcapi-hmaccalc": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libkcapi-hmaccalc:libkcapi-hmaccalc:1.1.1-16_1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libkcapi_hmaccalc:libkcapi-hmaccalc:1.1.1-16_1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libkcapi-hmaccalc:libkcapi_hmaccalc:1.1.1-16_1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libkcapi_hmaccalc:libkcapi_hmaccalc:1.1.1-16_1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libkcapi:libkcapi-hmaccalc:1.1.1-16_1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libkcapi:libkcapi_hmaccalc:1.1.1-16_1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libkcapi-hmaccalc:1.1.1-16_1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libkcapi_hmaccalc:1.1.1-16_1.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD or GPLv2",
        "origin": "CentOS",
        "release": "16_1.el8",
        "size": "35165",
        "sourcepkg": "libkcapi-1.1.1-16_1.el8.src.rpm",
        "type": "rpm",
        "version": "1.1.1",
    },
    "libksba": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libksba:libksba:1.3.5-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libksba:1.3.5-7.el8:*:*:*:*:*:*:*",
        ],
        "license": "(LGPLv3+ or GPLv2+) and GPLv3+",
        "origin": "CentOS",
        "release": "7.el8",
        "size": "342935",
        "sourcepkg": "libksba-1.3.5-7.el8.src.rpm",
        "type": "rpm",
        "version": "1.3.5",
    },
    "libmetalink": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libmetalink:libmetalink:0.1.3-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libmetalink:0.1.3-7.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "7.el8",
        "size": "76960",
        "sourcepkg": "libmetalink-0.1.3-7.el8.src.rpm",
        "type": "rpm",
        "version": "0.1.3",
    },
    "libmnl": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:libmnl:1.0.4-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libmnl:libmnl:1.0.4-6.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "6.el8",
        "size": "53687",
        "sourcepkg": "libmnl-1.0.4-6.el8.src.rpm",
        "type": "rpm",
        "version": "1.0.4",
    },
    "libmodulemd1": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libmodulemd1:libmodulemd1:1.8.16-0.2.8.2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libmodulemd1:1.8.16-0.2.8.2.1:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "0.2.8.2.1",
        "size": "546039",
        "sourcepkg": "libmodulemd-2.8.2-1.el8.src.rpm",
        "type": "rpm",
        "version": "1.8.16",
    },
    "libmount": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libmount:libmount:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libmount:2.32.1-22.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "22.el8",
        "size": "398154",
        "sourcepkg": "util-linux-2.32.1-22.el8.src.rpm",
        "type": "rpm",
        "version": "2.32.1",
    },
    "libnghttp2": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libnghttp2:libnghttp2:1.33.0-3.el8_2.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libnghttp2:1.33.0-3.el8_2.1:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "3.el8_2.1",
        "size": "168044",
        "sourcepkg": "nghttp2-1.33.0-3.el8_2.1.src.rpm",
        "type": "rpm",
        "version": "1.33.0",
    },
    "libnsl2": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libnsl2:libnsl2:1.2.0-2.20180605git4a062cf.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libnsl2:1.2.0-2.20180605git4a062cf.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD and LGPLv2+",
        "origin": "CentOS",
        "release": "2.20180605git4a062cf.el8",
        "size": "147122",
        "sourcepkg": "libnsl2-1.2.0-2.20180605git4a062cf.el8.src.rpm",
        "type": "rpm",
        "version": "1.2.0",
    },
    "libpcap": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libpcap:libpcap:14:1.9.0-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libpcap:14:1.9.0-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD with advertising",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "424251",
        "sourcepkg": "libpcap-1.9.0-3.el8.src.rpm",
        "type": "rpm",
        "version": "14:1.9.0",
    },
    "libpwquality": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libpwquality:libpwquality:1.4.0-9.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libpwquality:1.4.0-9.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD or GPLv2+",
        "origin": "CentOS",
        "release": "9.el8",
        "size": "384791",
        "sourcepkg": "libpwquality-1.4.0-9.el8.src.rpm",
        "type": "rpm",
        "version": "1.4.0",
    },
    "librepo": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:librepo:librepo:1.11.0-2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:librepo:1.11.0-2.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "2.el8",
        "size": "262664",
        "sourcepkg": "librepo-1.11.0-2.el8.src.rpm",
        "type": "rpm",
        "version": "1.11.0",
    },
    "libreport-filesystem": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libreport-filesystem:libreport-filesystem:2.9.5-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libreport_filesystem:libreport-filesystem:2.9.5-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libreport-filesystem:libreport_filesystem:2.9.5-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libreport_filesystem:libreport_filesystem:2.9.5-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libreport:libreport-filesystem:2.9.5-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:libreport:libreport_filesystem:2.9.5-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libreport-filesystem:2.9.5-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libreport_filesystem:2.9.5-10.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "10.el8",
        "size": "0",
        "sourcepkg": "libreport-2.9.5-10.el8.src.rpm",
        "type": "rpm",
        "version": "2.9.5",
    },
    "libseccomp": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libseccomp:libseccomp:2.4.1-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libseccomp:2.4.1-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "402960",
        "sourcepkg": "libseccomp-2.4.1-1.el8.src.rpm",
        "type": "rpm",
        "version": "2.4.1",
    },
    "libselinux": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libselinux:libselinux:2.9-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libselinux:2.9-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "305912",
        "sourcepkg": "libselinux-2.9-3.el8.src.rpm",
        "type": "rpm",
        "version": "2.9",
    },
    "libsemanage": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libsemanage:libsemanage:2.9-2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libsemanage:2.9-2.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "2.el8",
        "size": "477962",
        "sourcepkg": "libsemanage-2.9-2.el8.src.rpm",
        "type": "rpm",
        "version": "2.9",
    },
    "libsepol": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libsepol:libsepol:2.9-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libsepol:2.9-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "996264",
        "sourcepkg": "libsepol-2.9-1.el8.src.rpm",
        "type": "rpm",
        "version": "2.9",
    },
    "libsigsegv": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libsigsegv:libsigsegv:2.11-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libsigsegv:2.11-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "47034",
        "sourcepkg": "libsigsegv-2.11-5.el8.src.rpm",
        "type": "rpm",
        "version": "2.11",
    },
    "libsmartcols": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libsmartcols:libsmartcols:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libsmartcols:2.32.1-22.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "22.el8",
        "size": "244258",
        "sourcepkg": "util-linux-2.32.1-22.el8.src.rpm",
        "type": "rpm",
        "version": "2.32.1",
    },
    "libsolv": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libsolv:libsolv:0.7.7-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libsolv:0.7.7-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "789176",
        "sourcepkg": "libsolv-0.7.7-1.el8.src.rpm",
        "type": "rpm",
        "version": "0.7.7",
    },
    "libstdc++": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libstdc++:libstdc++:8.3.1-5.el8.0.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libstdc++:8.3.1-5.el8.0.2:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD",
        "origin": "CentOS",
        "release": "5.el8.0.2",
        "size": "1855607",
        "sourcepkg": "gcc-8.3.1-5.el8.0.2.src.rpm",
        "type": "rpm",
        "version": "8.3.1",
    },
    "libtasn1": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libtasn1:libtasn1:4.13-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libtasn1:4.13-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+ and LGPLv2+",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "168725",
        "sourcepkg": "libtasn1-4.13-3.el8.src.rpm",
        "type": "rpm",
        "version": "4.13",
    },
    "libtirpc": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libtirpc:libtirpc:1.1.4-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libtirpc:1.1.4-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "SISSL and BSD",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "381964",
        "sourcepkg": "libtirpc-1.1.4-4.el8.src.rpm",
        "type": "rpm",
        "version": "1.1.4",
    },
    "libunistring": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libunistring:libunistring:0.9.9-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libunistring:0.9.9-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ or LGPLv3+",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "1855932",
        "sourcepkg": "libunistring-0.9.9-3.el8.src.rpm",
        "type": "rpm",
        "version": "0.9.9",
    },
    "libusbx": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libusbx:libusbx:1.0.22-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libusbx:1.0.22-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "151177",
        "sourcepkg": "libusbx-1.0.22-1.el8.src.rpm",
        "type": "rpm",
        "version": "1.0.22",
    },
    "libutempter": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libutempter:libutempter:1.1.6-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libutempter:1.1.6-14.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "14.el8",
        "size": "52637",
        "sourcepkg": "libutempter-1.1.6-14.el8.src.rpm",
        "type": "rpm",
        "version": "1.1.6",
    },
    "libuuid": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libuuid:libuuid:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libuuid:2.32.1-22.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "22.el8",
        "size": "34832",
        "sourcepkg": "util-linux-2.32.1-22.el8.src.rpm",
        "type": "rpm",
        "version": "2.32.1",
    },
    "libverto": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libverto:libverto:0.3.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libverto:0.3.0-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "28244",
        "sourcepkg": "libverto-0.3.0-5.el8.src.rpm",
        "type": "rpm",
        "version": "0.3.0",
    },
    "libxcrypt": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libxcrypt:libxcrypt:4.1.1-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libxcrypt:4.1.1-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+ and BSD and Public Domain",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "194420",
        "sourcepkg": "libxcrypt-4.1.1-4.el8.src.rpm",
        "type": "rpm",
        "version": "4.1.1",
    },
    "libxml2": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libxml2:libxml2:2.9.7-7.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libxml2:2.9.7-7.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "7.el8",
        "size": "1752506",
        "sourcepkg": "libxml2-2.9.7-7.el8.src.rpm",
        "type": "rpm",
        "version": "2.9.7",
    },
    "libyaml": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libyaml:libyaml:0.1.7-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libyaml:0.1.7-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "136478",
        "sourcepkg": "libyaml-0.1.7-5.el8.src.rpm",
        "type": "rpm",
        "version": "0.1.7",
    },
    "libzstd": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:libzstd:libzstd:1.4.2-2.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:libzstd:1.4.2-2.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD and GPLv2",
        "origin": "CentOS",
        "release": "2.el8",
        "size": "703765",
        "sourcepkg": "zstd-1.4.2-2.el8.src.rpm",
        "type": "rpm",
        "version": "1.4.2",
    },
    "lua-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:lua_libs:lua_libs:5.3.4-11.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lua-libs:lua-libs:5.3.4-11.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lua_libs:lua-libs:5.3.4-11.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lua-libs:lua_libs:5.3.4-11.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:lua-libs:5.3.4-11.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:lua_libs:5.3.4-11.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lua:lua_libs:5.3.4-11.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lua:lua-libs:5.3.4-11.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "11.el8",
        "size": "351728",
        "sourcepkg": "lua-5.3.4-11.el8.src.rpm",
        "type": "rpm",
        "version": "5.3.4",
    },
    "lz4-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:lz4-libs:lz4_libs:1.8.1.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lz4_libs:lz4_libs:1.8.1.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lz4-libs:lz4-libs:1.8.1.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lz4_libs:lz4-libs:1.8.1.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:lz4_libs:1.8.1.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:lz4-libs:1.8.1.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lz4:lz4_libs:1.8.1.2-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lz4:lz4-libs:1.8.1.2-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and BSD",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "97367",
        "sourcepkg": "lz4-1.8.1.2-4.el8.src.rpm",
        "type": "rpm",
        "version": "1.8.1.2",
    },
    "lzo": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:lzo:2.08-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:lzo:lzo:2.08-14.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "14.el8",
        "size": "198757",
        "sourcepkg": "lzo-2.08-14.el8.src.rpm",
        "type": "rpm",
        "version": "2.08",
    },
    "mpfr": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:mpfr:3.1.6-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:mpfr:mpfr:3.1.6-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv3+ and GPLv3+ and GFDL",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "612625",
        "sourcepkg": "mpfr-3.1.6-1.el8.src.rpm",
        "type": "rpm",
        "version": "3.1.6",
    },
    "ncurses-base": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:ncurses_base:ncurses-base:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses-base:ncurses_base:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses-base:ncurses-base:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses_base:ncurses_base:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses:ncurses-base:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses:ncurses_base:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ncurses_base:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ncurses-base:6.1-7.20180224.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "7.20180224.el8",
        "size": "290089",
        "sourcepkg": "ncurses-6.1-7.20180224.el8.src.rpm",
        "type": "rpm",
        "version": "6.1",
    },
    "ncurses-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:ncurses-libs:ncurses-libs:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses_libs:ncurses-libs:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses-libs:ncurses_libs:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses_libs:ncurses_libs:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses:ncurses-libs:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:ncurses:ncurses_libs:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ncurses-libs:6.1-7.20180224.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:ncurses_libs:6.1-7.20180224.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "7.20180224.el8",
        "size": "1120040",
        "sourcepkg": "ncurses-6.1-7.20180224.el8.src.rpm",
        "type": "rpm",
        "version": "6.1",
    },
    "nettle": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:nettle:3.4.1-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:nettle:nettle:3.4.1-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv3+ or GPLv2+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "683185",
        "sourcepkg": "nettle-3.4.1-1.el8.src.rpm",
        "type": "rpm",
        "version": "3.4.1",
    },
    "npth": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:npth:1.5-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:npth:npth:1.5-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "47909",
        "sourcepkg": "npth-1.5-4.el8.src.rpm",
        "type": "rpm",
        "version": "1.5",
    },
    "openldap": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:openldap:openldap:2.4.46-11.el8_1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:openldap:2.4.46-11.el8_1:*:*:*:*:*:*:*",
        ],
        "license": "OpenLDAP",
        "origin": "CentOS",
        "release": "11.el8_1",
        "size": "1388793",
        "sourcepkg": "openldap-2.4.46-11.el8_1.src.rpm",
        "type": "rpm",
        "version": "2.4.46",
    },
    "openssl-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:openssl-libs:openssl-libs:1:1.1.1c-15.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:openssl_libs:openssl-libs:1:1.1.1c-15.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:openssl-libs:openssl_libs:1:1.1.1c-15.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:openssl_libs:openssl_libs:1:1.1.1c-15.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:openssl:openssl-libs:1:1.1.1c-15.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:openssl:openssl_libs:1:1.1.1c-15.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:openssl-libs:1:1.1.1c-15.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:openssl_libs:1:1.1.1c-15.el8:*:*:*:*:*:*:*",
        ],
        "license": "OpenSSL",
        "origin": "CentOS",
        "release": "15.el8",
        "size": "3744176",
        "sourcepkg": "openssl-1.1.1c-15.el8.src.rpm",
        "type": "rpm",
        "version": "1:1.1.1c",
    },
    "p11-kit": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:p11-kit:p11_kit:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11_kit:p11_kit:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11-kit:p11-kit:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11_kit:p11-kit:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:p11_kit:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:p11-kit:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11:p11_kit:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11:p11-kit:0.23.14-5.el8_0:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "5.el8_0",
        "size": "1394732",
        "sourcepkg": "p11-kit-0.23.14-5.el8_0.src.rpm",
        "type": "rpm",
        "version": "0.23.14",
    },
    "p11-kit-trust": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:p11-kit-trust:p11-kit-trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11_kit_trust:p11-kit-trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11-kit-trust:p11_kit_trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11_kit_trust:p11_kit_trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11-kit:p11-kit-trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11_kit:p11-kit-trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11-kit:p11_kit_trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11_kit:p11_kit_trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:p11-kit-trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:p11_kit_trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11:p11-kit-trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
            "cpe:2.3:a:p11:p11_kit_trust:0.23.14-5.el8_0:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "5.el8_0",
        "size": "508547",
        "sourcepkg": "p11-kit-0.23.14-5.el8_0.src.rpm",
        "type": "rpm",
        "version": "0.23.14",
    },
    "pam": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:pam:1.3.1-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:pam:pam:1.3.1-8.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD and GPLv2+",
        "origin": "CentOS",
        "release": "8.el8",
        "size": "2857052",
        "sourcepkg": "pam-1.3.1-8.el8.src.rpm",
        "type": "rpm",
        "version": "1.3.1",
    },
    "pcre": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:pcre:8.42-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:pcre:pcre:8.42-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "518067",
        "sourcepkg": "pcre-8.42-4.el8.src.rpm",
        "type": "rpm",
        "version": "8.42",
    },
    "pcre2": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:pcre2:10.32-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:pcre2:pcre2:10.32-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "667046",
        "sourcepkg": "pcre2-10.32-1.el8.src.rpm",
        "type": "rpm",
        "version": "10.32",
    },
    "platform-python": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:platform_python:platform-python:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform-python:platform_python:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform-python:platform-python:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform_python:platform_python:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform:platform-python:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform:platform_python:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:platform_python:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:platform-python:3.6.8-23.el8:*:*:*:*:*:*:*",
        ],
        "license": "Python",
        "origin": "CentOS",
        "release": "23.el8",
        "size": "41790",
        "sourcepkg": "python3-3.6.8-23.el8.src.rpm",
        "type": "rpm",
        "version": "3.6.8",
    },
    "platform-python-setuptools": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:platform-python-setuptools:platform-python-setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform_python_setuptools:platform-python-setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform-python-setuptools:platform_python_setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform_python_setuptools:platform_python_setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform_python:platform-python-setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform-python:platform-python-setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform_python:platform_python_setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform-python:platform_python_setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform:platform-python-setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:platform:platform_python_setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:platform-python-setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:platform_python_setuptools:39.2.0-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "2930163",
        "sourcepkg": "python-setuptools-39.2.0-5.el8.src.rpm",
        "type": "rpm",
        "version": "39.2.0",
    },
    "popt": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:popt:1.16-14.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:popt:popt:1.16-14.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "14.el8",
        "size": "128374",
        "sourcepkg": "popt-1.16-14.el8.src.rpm",
        "type": "rpm",
        "version": "1.16",
    },
    "procps-ng": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:procps_ng:procps-ng:3.3.15-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:procps-ng:procps_ng:3.3.15-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:procps-ng:procps-ng:3.3.15-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:procps_ng:procps_ng:3.3.15-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:procps:procps-ng:3.3.15-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:procps_ng:3.3.15-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:procps:procps_ng:3.3.15-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:procps-ng:3.3.15-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "938380",
        "sourcepkg": "procps-ng-3.3.15-1.el8.src.rpm",
        "type": "rpm",
        "version": "3.3.15",
    },
    "python3-dnf": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:python3_dnf:python3_dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-dnf:python3-dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_dnf:python3-dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-dnf:python3_dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3_dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3-dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3-dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3_dnf:4.2.17-7.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and GPLv2 and GPL",
        "origin": "CentOS",
        "release": "7.el8_2",
        "size": "1829655",
        "sourcepkg": "dnf-4.2.17-7.el8_2.src.rpm",
        "type": "rpm",
        "version": "4.2.17",
    },
    "python3-gpg": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:python3_gpg:python3-gpg:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-gpg:python3-gpg:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_gpg:python3_gpg:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-gpg:python3_gpg:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3-gpg:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3_gpg:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3-gpg:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3_gpg:1.10.0-6.el8.0.1:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "6.el8.0.1",
        "size": "1295107",
        "sourcepkg": "gpgme-1.10.0-6.el8.0.1.src.rpm",
        "type": "rpm",
        "version": "1.10.0",
    },
    "python3-hawkey": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:python3-hawkey:python3-hawkey:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_hawkey:python3-hawkey:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-hawkey:python3_hawkey:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_hawkey:python3_hawkey:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3-hawkey:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3_hawkey:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3-hawkey:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3_hawkey:0.39.1-6.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "6.el8_2",
        "size": "263176",
        "sourcepkg": "libdnf-0.39.1-6.el8_2.src.rpm",
        "type": "rpm",
        "version": "0.39.1",
    },
    "python3-libcomps": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:python3-libcomps:python3-libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_libcomps:python3-libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-libcomps:python3_libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_libcomps:python3_libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3-libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3_libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3-libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3_libcomps:0.1.11-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "147027",
        "sourcepkg": "libcomps-0.1.11-4.el8.src.rpm",
        "type": "rpm",
        "version": "0.1.11",
    },
    "python3-libdnf": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:python3-libdnf:python3-libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_libdnf:python3-libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-libdnf:python3_libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_libdnf:python3_libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3-libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3_libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3-libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3_libdnf:0.39.1-6.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "6.el8_2",
        "size": "3666814",
        "sourcepkg": "libdnf-0.39.1-6.el8_2.src.rpm",
        "type": "rpm",
        "version": "0.39.1",
    },
    "python3-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:python3-libs:python3-libs:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_libs:python3-libs:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-libs:python3_libs:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_libs:python3_libs:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3-libs:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3_libs:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3-libs:3.6.8-23.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3_libs:3.6.8-23.el8:*:*:*:*:*:*:*",
        ],
        "license": "Python",
        "origin": "CentOS",
        "release": "23.el8",
        "size": "32187857",
        "sourcepkg": "python3-3.6.8-23.el8.src.rpm",
        "type": "rpm",
        "version": "3.6.8",
    },
    "python3-pip-wheel": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:python3-pip-wheel:python3-pip-wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_pip_wheel:python3-pip-wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-pip-wheel:python3_pip_wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_pip_wheel:python3_pip_wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-pip:python3-pip-wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_pip:python3-pip-wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-pip:python3_pip_wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_pip:python3_pip_wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3-pip-wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3_pip_wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3-pip-wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3_pip_wheel:9.0.3-16.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)",
        "origin": "CentOS",
        "release": "16.el8",
        "size": "1255748",
        "sourcepkg": "python-pip-9.0.3-16.el8.src.rpm",
        "type": "rpm",
        "version": "9.0.3",
    },
    "python3-rpm": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:python3-rpm:python3_rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_rpm:python3-rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-rpm:python3-rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_rpm:python3_rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3_rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3-rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3-rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3_rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "37.el8",
        "size": "430929",
        "sourcepkg": "rpm-4.14.2-37.el8.src.rpm",
        "type": "rpm",
        "version": "4.14.2",
    },
    "python3-setuptools-wheel": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:python3-setuptools-wheel:python3_setuptools_wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_setuptools_wheel:python3_setuptools_wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-setuptools-wheel:python3-setuptools-wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_setuptools_wheel:python3-setuptools-wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_setuptools:python3_setuptools_wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-setuptools:python3_setuptools_wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3_setuptools:python3-setuptools-wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3-setuptools:python3-setuptools-wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3_setuptools_wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:python3:python3-setuptools-wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3_setuptools_wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:python3-setuptools-wheel:39.2.0-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "MIT",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "347696",
        "sourcepkg": "python-setuptools-39.2.0-5.el8.src.rpm",
        "type": "rpm",
        "version": "39.2.0",
    },
    "readline": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:readline:readline:7.0-10.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:readline:7.0-10.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "10.el8",
        "size": "466321",
        "sourcepkg": "readline-7.0-10.el8.src.rpm",
        "type": "rpm",
        "version": "7.0",
    },
    "rootfiles": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:rootfiles:rootfiles:8.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:rootfiles:8.1-22.el8:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain",
        "origin": "CentOS",
        "release": "22.el8",
        "size": "599",
        "sourcepkg": "rootfiles-8.1-22.el8.src.rpm",
        "type": "rpm",
        "version": "8.1",
    },
    "rpm": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm:rpm:4.14.2-37.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "37.el8",
        "size": "2084270",
        "sourcepkg": "rpm-4.14.2-37.el8.src.rpm",
        "type": "rpm",
        "version": "4.14.2",
    },
    "rpm-build-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:rpm-build-libs:rpm-build-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm_build_libs:rpm-build-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm-build-libs:rpm_build_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm_build_libs:rpm_build_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm-build:rpm-build-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm_build:rpm-build-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm-build:rpm_build_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm_build:rpm_build_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:rpm-build-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:rpm_build_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm:rpm-build-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm:rpm_build_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and LGPLv2+ with exceptions",
        "origin": "CentOS",
        "release": "37.el8",
        "size": "215992",
        "sourcepkg": "rpm-4.14.2-37.el8.src.rpm",
        "type": "rpm",
        "version": "4.14.2",
    },
    "rpm-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:rpm-libs:rpm-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm_libs:rpm-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm-libs:rpm_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm_libs:rpm_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:rpm-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:rpm_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm:rpm-libs:4.14.2-37.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:rpm:rpm_libs:4.14.2-37.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and LGPLv2+ with exceptions",
        "origin": "CentOS",
        "release": "37.el8",
        "size": "722464",
        "sourcepkg": "rpm-4.14.2-37.el8.src.rpm",
        "type": "rpm",
        "version": "4.14.2",
    },
    "sed": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:sed:4.5-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:sed:sed:4.5-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "776854",
        "sourcepkg": "sed-4.5-1.el8.src.rpm",
        "type": "rpm",
        "version": "4.5",
    },
    "setup": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:centos:setup:2.12.2-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:setup:setup:2.12.2-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "724831",
        "sourcepkg": "setup-2.12.2-5.el8.src.rpm",
        "type": "rpm",
        "version": "2.12.2",
    },
    "shadow-utils": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:shadow-utils:shadow-utils:2:4.6-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:shadow_utils:shadow-utils:2:4.6-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:shadow-utils:shadow_utils:2:4.6-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:shadow_utils:shadow_utils:2:4.6-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:shadow-utils:2:4.6-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:shadow:shadow-utils:2:4.6-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:shadow_utils:2:4.6-8.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:shadow:shadow_utils:2:4.6-8.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD and GPLv2+",
        "origin": "CentOS",
        "release": "8.el8",
        "size": "5368080",
        "sourcepkg": "shadow-utils-4.6-8.el8.src.rpm",
        "type": "rpm",
        "version": "2:4.6",
    },
    "snappy": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:snappy:snappy:1.1.7-5.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:snappy:1.1.7-5.el8:*:*:*:*:*:*:*",
        ],
        "license": "BSD",
        "origin": "CentOS",
        "release": "5.el8",
        "size": "58789",
        "sourcepkg": "snappy-1.1.7-5.el8.src.rpm",
        "type": "rpm",
        "version": "1.1.7",
    },
    "sqlite-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:sqlite-libs:sqlite-libs:3.26.0-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:sqlite_libs:sqlite-libs:3.26.0-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:sqlite-libs:sqlite_libs:3.26.0-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:sqlite_libs:sqlite_libs:3.26.0-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:sqlite-libs:3.26.0-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:sqlite:sqlite-libs:3.26.0-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:sqlite_libs:3.26.0-6.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:sqlite:sqlite_libs:3.26.0-6.el8:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain",
        "origin": "CentOS",
        "release": "6.el8",
        "size": "1162241",
        "sourcepkg": "sqlite-3.26.0-6.el8.src.rpm",
        "type": "rpm",
        "version": "3.26.0",
    },
    "squashfs-tools": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:squashfs_tools:squashfs-tools:4.3-19.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:squashfs-tools:squashfs-tools:4.3-19.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:squashfs_tools:squashfs_tools:4.3-19.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:squashfs-tools:squashfs_tools:4.3-19.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:squashfs:squashfs-tools:4.3-19.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:squashfs:squashfs_tools:4.3-19.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:squashfs-tools:4.3-19.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:squashfs_tools:4.3-19.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+",
        "origin": "CentOS",
        "release": "19.el8",
        "size": "502829",
        "sourcepkg": "squashfs-tools-4.3-19.el8.src.rpm",
        "type": "rpm",
        "version": "4.3",
    },
    "systemd": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:systemd:systemd:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:systemd:239-31.el8_2.2:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+ and MIT and GPLv2+",
        "origin": "CentOS",
        "release": "31.el8_2.2",
        "size": "11073343",
        "sourcepkg": "systemd-239-31.el8_2.2.src.rpm",
        "type": "rpm",
        "version": "239",
    },
    "systemd-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:systemd-libs:systemd-libs:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd_libs:systemd-libs:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd-libs:systemd_libs:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd_libs:systemd_libs:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd:systemd-libs:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd:systemd_libs:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:systemd-libs:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:systemd_libs:239-31.el8_2.2:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+ and MIT",
        "origin": "CentOS",
        "release": "31.el8_2.2",
        "size": "4497790",
        "sourcepkg": "systemd-239-31.el8_2.2.src.rpm",
        "type": "rpm",
        "version": "239",
    },
    "systemd-pam": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:systemd-pam:systemd-pam:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd_pam:systemd-pam:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd-pam:systemd_pam:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd_pam:systemd_pam:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd:systemd-pam:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd:systemd_pam:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:systemd-pam:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:systemd_pam:239-31.el8_2.2:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+ and MIT and GPLv2+",
        "origin": "CentOS",
        "release": "31.el8_2.2",
        "size": "902504",
        "sourcepkg": "systemd-239-31.el8_2.2.src.rpm",
        "type": "rpm",
        "version": "239",
    },
    "systemd-udev": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:systemd-udev:systemd_udev:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd_udev:systemd_udev:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd-udev:systemd-udev:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd_udev:systemd-udev:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd:systemd_udev:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:systemd:systemd-udev:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:systemd_udev:239-31.el8_2.2:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:systemd-udev:239-31.el8_2.2:*:*:*:*:*:*:*",
        ],
        "license": "LGPLv2+",
        "origin": "CentOS",
        "release": "31.el8_2.2",
        "size": "7940076",
        "sourcepkg": "systemd-239-31.el8_2.2.src.rpm",
        "type": "rpm",
        "version": "239",
    },
    "tar": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:tar:2:1.30-4.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:tar:tar:2:1.30-4.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv3+",
        "origin": "CentOS",
        "release": "4.el8",
        "size": "2914728",
        "sourcepkg": "tar-1.30-4.el8.src.rpm",
        "type": "rpm",
        "version": "2:1.30",
    },
    "tzdata": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:tzdata:tzdata:2020a-1.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:tzdata:2020a-1.el8:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain",
        "origin": "CentOS",
        "release": "1.el8",
        "size": "1904256",
        "sourcepkg": "tzdata-2020a-1.el8.src.rpm",
        "type": "rpm",
        "version": "2020a",
    },
    "util-linux": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:util_linux:util_linux:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:util-linux:util-linux:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:util_linux:util-linux:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:util-linux:util_linux:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:util-linux:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:util_linux:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:util:util_linux:2.32.1-22.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:util:util-linux:2.32.1-22.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain",
        "origin": "CentOS",
        "release": "22.el8",
        "size": "11560494",
        "sourcepkg": "util-linux-2.32.1-22.el8.src.rpm",
        "type": "rpm",
        "version": "2.32.1",
    },
    "vim-minimal": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:vim-minimal:vim-minimal:2:8.0.1763-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:vim_minimal:vim-minimal:2:8.0.1763-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:vim-minimal:vim_minimal:2:8.0.1763-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:vim_minimal:vim_minimal:2:8.0.1763-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:vim-minimal:2:8.0.1763-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:vim_minimal:2:8.0.1763-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:vim:vim-minimal:2:8.0.1763-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:vim:vim_minimal:2:8.0.1763-13.el8:*:*:*:*:*:*:*",
        ],
        "license": "Vim and MIT",
        "origin": "CentOS",
        "release": "13.el8",
        "size": "1420484",
        "sourcepkg": "vim-8.0.1763-13.el8.src.rpm",
        "type": "rpm",
        "version": "2:8.0.1763",
    },
    "xz": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:xz:5.2.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:xz:xz:5.2.4-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and Public Domain",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "432832",
        "sourcepkg": "xz-5.2.4-3.el8.src.rpm",
        "type": "rpm",
        "version": "5.2.4",
    },
    "xz-libs": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:xz_libs:xz_libs:5.2.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:xz-libs:xz-libs:5.2.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:xz_libs:xz-libs:5.2.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:xz-libs:xz_libs:5.2.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:xz-libs:5.2.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:centos:xz_libs:5.2.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:xz:xz_libs:5.2.4-3.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:xz:xz-libs:5.2.4-3.el8:*:*:*:*:*:*:*",
        ],
        "license": "Public Domain",
        "origin": "CentOS",
        "release": "3.el8",
        "size": "194799",
        "sourcepkg": "xz-5.2.4-3.el8.src.rpm",
        "type": "rpm",
        "version": "5.2.4",
    },
    "yum": {
        "arch": "noarch",
        "cpes": [
            "cpe:2.3:a:centos:yum:4.2.17-7.el8_2:*:*:*:*:*:*:*",
            "cpe:2.3:a:yum:yum:4.2.17-7.el8_2:*:*:*:*:*:*:*",
        ],
        "license": "GPLv2+ and GPLv2 and GPL",
        "origin": "CentOS",
        "release": "7.el8_2",
        "size": "70885",
        "sourcepkg": "dnf-4.2.17-7.el8_2.src.rpm",
        "type": "rpm",
        "version": "4.2.17",
    },
    "zlib": {
        "arch": "x86_64",
        "cpes": [
            "cpe:2.3:a:centos:zlib:1.2.11-13.el8:*:*:*:*:*:*:*",
            "cpe:2.3:a:zlib:zlib:1.2.11-13.el8:*:*:*:*:*:*:*",
        ],
        "license": "zlib and Boost",
        "origin": "CentOS",
        "release": "13.el8",
        "size": "195551",
        "sourcepkg": "zlib-1.2.11-13.el8.src.rpm",
        "type": "rpm",
        "version": "1.2.11",
    },
}
