# PyTorch-From-Zero-To-One
PyTorch 从入门到精通：含入门指南、在线教程、视频教程和书籍推荐等资源

> 注1：♥ 表示推荐指数，越多越好

> 注2：TensorFlow从入门到精通请参考：[TensorFlow-From-Zero-To-One](https://github.com/amusi/TensorFlow-From-Zero-To-One)

## 笔记

安装教程

- [Ubuntu](examples/Python1.0_Install.md)
- [Windows](https://blog.csdn.net/amusi1994/article/details/80077667)

## PyTorch参考学习资料

### PyTorch入门指南

[Awesome-pytorch-list](https://github.com/bharathgs/Awesome-pytorch-list)  [中文版]( https://github.com/xavier-zy/Awesome-pytorch-list-CNVersion )：A comprehensive list of pytorch related content on github,such as different models,implementations,helper libraries,tutorials etc.

[知乎：新手如何入门PyTorch](https://www.zhihu.com/question/55720139)

[PyTorch：60分钟入门](http://pytorch.org/tutorials/)

[the-incredible-pytorch](https://github.com/ritchieng/the-incredible-pytorch)：The Incredible PyTorch: a curated list of tutorials, papers, projects, communities and more relating to PyTorch.

[PyTorch internals](http://blog.ezyang.com/2019/05/pytorch-internals/)：This post is a long form essay version of a talk about PyTorch internals.

### 官网&社区

**国外**

- **（♥♥♥♥♥）**[PyTorch官网](http://pytorch.org/)
- **（♥♥♥♥♥）**[GitHub：PyTorch](https://github.com/pytorch/pytorch)
- **（♥♥♥♥）**[Twitter：PyTorch](https://twitter.com/pytorch)：官方维护，分享最快动态
- **（♥♥♥♥）**[PyTorch官方论坛](https://discuss.pytorch.org/)

**国内**

- [PyTorch中文文档&教程](https://pytorch.apachecn.org/#/)

- [知乎话题：PyTorch](https://www.zhihu.com/topic/20075993/hot)

### 在线教程

**国外**

- **（♥♥♥♥♥）**[PyTorch：Doc](http://pytorch.org/docs/)
- **（♥♥♥♥♥）**[pytorch-tutorial](https://github.com/yunjey/pytorch-tutorial)：PyTorch Tutorial for Deep Learning Researchers
- **（♥♥♥♥♥）**[practicalAI](https://github.com/GokuMohandas/practicalAI/)：Implement basic ML algorithms and deep neural networks with [PyTorch](https://pytorch.org/).
- **（♥♥♥♥♥）**[Dive Into Deep Learning - PyTorch]( https://github.com/dsgiitr/d2l-pytorch)： from MXNet into PyTorch
- **（♥♥♥♥）**[practical-pytorch](https://github.com/spro/practical-pytorch)：PyTorch tutorials demonstrating modern techniques with readable code
- **（♥♥♥♥）**[Deep Learning with PyTorch](http://deeplizard.com/learn/playlist/PLZbbT5o_s2xrfNyHZsM6ufI0iZENK9xgG)：This series is all about neural network programming and PyTorch! 
- **（♥♥♥）** [EffectivePyTorch](https://github.com/vahidk/EffectivePyTorch)： PyTorch tutorials and best practices. 
- **（♥♥♥）**[Minicourse in Deep Learning with PyTorch](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse)：Mini Course in Deep Learning with PyTorch for AIMS
- **（♥♥♥）**[pytorch-cpp]( https://github.com/prabhuomkar/pytorch-cpp )：C++ Implementation of PyTorch Tutorial for Deep Learning Researchers
- **（♥♥♥）**[pytorch-examples](https://github.com/jcjohnson/pytorch-examples)：Simple examples to introduce PyTorch
- **（♥♥♥）**[PyTorchZeroToAll](https://github.com/hunkim/PyTorchZeroToAll)：Simple PyTorch Tutorials Zero to ALL!

**国内**

- **（♥♥♥♥♥）**[pytorch-book](https://github.com/chenyuntc/pytorch-book)：PyTorch tutorials and fun projects including neural talk, neural style, poem writing, anime generation
- **（♥♥♥♥♥）**[莫凡：PyTorch教学](https://morvanzhou.github.io/tutorials/machine-learning/torch/)：Build your neural network easy and fast
- **（♥♥♥♥♥）**[pytorch-handbook](https://github.com/zergtant/pytorch-handbook)：pytorch handbook是一本开源的书籍
- **（♥♥♥♥）**[Dive-into-DL-PyTorch](https://github.com/ShusenTang/Dive-into-DL-PyTorch)：本项目将《动手学深度学习》(Dive into Deep Learning)原书中的MXNet实现改为PyTorch实现。
- **（♥♥♥♥）**[PyTorch_Tutorial](https://github.com/tensor-yu/PyTorch_Tutorial)：《Pytorch模型训练实用教程》中配套代码 [PyTorch学习笔记](https://zhuanlan.zhihu.com/c_1056853059086430208)

### 视频教程

**国外**

- **（♥♥♥♥）**[Deep Learning with PyTorch]( https://www.youtube.com/playlist?list=PLyMom0n-MBroupZiLfVSZqK5asX8KfoHL )

-  **（♥♥♥♥）**[PyTorch - Deep Learning with Python](https://www.youtube.com/playlist?list=PLQVvvaa0QuDdeMyHEYc0gxFpYwHY2Qfdh)

- **（♥♥♥）**[Neural Network Programming - Deep Learning with PyTorch](https://www.youtube.com/watch?v=v5cngxo4mIg&list=PLZbbT5o_s2xrfNyHZsM6ufI0iZENK9xgG)  
- **（♥♥♥）**[Intro to Deep Learning with PyTorch](https://cn.udacity.com/course/deep-learning-pytorch--ud188)：优达免费课程

**国内**

- **（♥♥♥♥♥）**[莫凡：PyTorch教学](https://morvanzhou.github.io/tutorials/machine-learning/torch/)

### 书籍资源

**国外**

-  **（♥♥♥♥♥）**[Deep Learning with PyTorch](https://www.manning.com/books/deep-learning-with-pytorch)：LeCun力荐，PyTorch官方权威教程书  [github代码]( https://github.com/deep-learning-with-pytorch/dlwpt-code )

- **（♥♥♥）**[Introduction to Artificial Neural Networks and Deep Learning: A Practical Guide with Applications in Python](https://github.com/rasbt/deep-learning-book)

**国内**

- ~~**（♥♥♥♥♥）**[《深度学习框架PyTorch：入门与实践》](https://book.douban.com/subject/27624483/)~~  [github](https://github.com/chenyuntc/pytorch-book)

### 经验&技巧

- **（♥♥♥♥♥）**[PyTorchTricks](https://github.com/lartpang/PyTorchTricks) 

### 实战项目

- **（♥♥♥♥♥）**[pytorch-examples](https://github.com/pytorch/examples)：官网示例
- **（♥♥♥♥♥）**[pretrained-models.pytorch](https://github.com/Cadene/pretrained-models.pytorch)：Pretrained ConvNets for pytorch: NASNet, ResNeXt, ResNet, InceptionV4, InceptionResnetV2, Xception, DPN, etc.
- **（♥♥♥♥）**[Detectron2]( https://github.com/facebookresearch/detectron2)：FAIR's next-generation research platform for object detection and segmentation.
- **（♥♥♥♥）**[mmdetection](https://github.com/open-mmlab/mmdetection)：Open MMLab Detection Toolbox with PyTorch 1.0
- **（♥♥♥♥）**[pytorch-semseg](https://github.com/meetshah1995/pytorch-semseg)：Semantic Segmentation Architectures Implemented in PyTorch
- **（♥♥♥♥）**[PyTorch Image Models]( https://github.com/rwightman/pytorch-image-models )： (SE)ResNet/ResNeXT, DPN, EfficientNet, MixNet, MobileNet-V3/V2/V1, MNASNet, Single-Path NAS, FBNet, and more
- [PyTorch CNN Finetune](https://github.com/creafz/pytorch-cnn-finetune)：Fine-tune pretrained Convolutional Neural Networks with PyTorch
- [PyTorch-Deep-Learning-Template](https://github.com/FrancescoSaverioZuppichini/PyTorch-Deep-Learning-Template)
- [semantic-segmentation-pytorch](https://github.com/CSAILVision/semantic-segmentation-pytorch)
- [pytorch-pretrained-BERT](https://github.com/huggingface/pytorch-pretrained-BERT)
- [torchcv](https://github.com/youansheng/torchcv)：A PyTorch-Based Framework for Deep Learning in Computer Vision
- https://github.com/devnag/pytorch-generative-adversarial-networks

### 生态工具

- [Ecosystem Tools]( https://pytorch.org/ecosystem/ )：官方认证的PyTorch生态圈工具列表，含几十个工具包，强烈推荐！
- [PyTorch Lightning](https://github.com/williamFalcon/pytorch-lightning)：Lightning is a very lightweight wrapper on PyTorch.
- [Hydra]( https://hydra.cc/ )：A framework for elegantly configuring complex applications 
- [Torchmeta](https://github.com/tristandeleu/pytorch-meta)：PyTorch 少样本学习和元学习库
- [Torch Optimizer](https://github.com/jettify/pytorch-optimizer)：PyTorch优化器工具库
- [Pytorch-Toolbox](https://github.com/PistonY/torch-toolbox)
- [Eisen](http://eisen.ai/)：a python package for solid deep learning
- [Dassl](https://github.com/KaiyangZhou/Dassl.pytorch)：A PyTorch toolbox for domain adaptation and semi-supervised learning.
- [PyRetri](https://github.com/PyRetri/PyRetri)：基于PyTorch的无监督图像检索工具库
- [Kornia](https://github.com/kornia/kornia)：Open Source Differentiable Computer Vision Library for PyTorch
- [FastReID](https://github.com/JDAI-CV/fast-reid): 一个面向学术界和工业界的 ReID Toolbox
- [KAIR](https://github.com/cszn/KAIR)：基于PyTorch的图像复原/修复工具箱（支持训练和测试）
- [FAIRScale](https://github.com/facebookresearch/fairscale)：用于高性能和大规模训练的PyTorch工具
- [PyTorch3D](https://github.com/facebookresearch/pytorch3d)：用于3D计算机视觉的PyTorch工具

### PyTorch技巧

- [Pytorch有什么节省显存的小技巧？](https://www.zhihu.com/question/274635237)
- [PyTorch 有哪些坑/bug？](https://www.zhihu.com/question/67209417)


### 其他资料

- [Awesome-PyTorch-list](https://github.com/bharathgs/Awesome-pytorch-list)   [中文版](https://github.com/xavier-zy/Awesome-pytorch-list-CNVersion)