/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.utils.files;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.utils.files.FileUtils;

public class TempFileManager {
    private static final Logger logger = LoggerFactory.getLogger(TempFileManager.class);
    File decompiledDir;
    File unzipDir;
    File workingDir;
    private File defaultTempDirBase = new File(System.getProperty("java.io.tmpdir"), "apk_tmp");
    private File apk;

    public TempFileManager(File apk) {
        if (apk == null) {
            throw new IllegalArgumentException("apk");
        }
        this.apk = apk;
    }

    public static TempFileManager forApk(File apk) {
        return new TempFileManager(apk);
    }

    public File getDefaultTempFileBaseDir() {
        return this.defaultTempDirBase;
    }

    public void setDefaultTempFileBaseDir(File defaultTempFileBaseDir) {
        this.defaultTempDirBase = defaultTempFileBaseDir;
    }

    public File getApkWorkingDirectory() {
        return this.workingDir == null ? this.createApkWorkingDirectory() : this.workingDir;
    }

    public File createApkWorkingDirectory() {
        File newDir = new File(this.defaultTempDirBase, this.apk.getName());
        if (!newDir.exists()) {
            logger.trace("creating working dir " + newDir.getAbsolutePath());
            newDir.mkdirs();
        }
        return newDir;
    }

    public File getApkUnzipedDirectory() {
        return this.workingDir == null ? this.createApkUnzipedDirectory() : this.unzipDir;
    }

    public File createApkUnzipedDirectory() {
        this.workingDir = this.getApkWorkingDirectory();
        this.unzipDir = new File(this.workingDir, "unziped");
        if (!this.unzipDir.exists()) {
            logger.trace("creating unzip dir " + this.unzipDir.getAbsolutePath());
            this.unzipDir.mkdirs();
        }
        return this.unzipDir;
    }

    public File getApkDecompiledDirectory() {
        return this.decompiledDir == null ? this.createApkDecompiledDirectory() : this.decompiledDir;
    }

    public File createApkDecompiledDirectory() {
        this.workingDir = this.getApkWorkingDirectory();
        this.decompiledDir = new File(this.workingDir, "decompiled");
        if (!this.decompiledDir.exists()) {
            logger.trace("creating decompiled dir " + this.decompiledDir.getAbsolutePath());
            this.decompiledDir.mkdirs();
        }
        return this.decompiledDir;
    }

    public void deleteApkDecompiledDirectory() throws IOException {
        if (this.decompiledDir != null) {
            FileUtils.deleteDirectory(this.decompiledDir);
        }
    }

    public void deleteApkUnzipedDirectory() throws IOException {
        if (this.unzipDir != null) {
            FileUtils.deleteDirectory(this.unzipDir);
        }
    }

    public void deleteApkWorkingDirectory() throws IOException {
        this.deleteApkDecompiledDirectory();
        this.deleteApkUnzipedDirectory();
        if (this.workingDir != null) {
            FileUtils.deleteDirectory(this.workingDir);
        }
    }
}

