/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.utils.files;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import sk.styk.martin.bakalarka.utils.files.ApkFile;

public class FileFinder {
    private List<File> searchedFolders;
    private List<File> files;

    public FileFinder(File folder) {
        if (folder == null) {
            throw new NullPointerException("folder null");
        }
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("folder is not valid directory");
        }
        this.searchedFolders = new ArrayList<File>();
        this.searchedFolders.add(folder);
    }

    public FileFinder(File ... folders) {
        this.searchedFolders = new ArrayList<File>();
        for (File folder : folders) {
            if (folder == null) {
                throw new NullPointerException("folder null");
            }
            if (!folder.isDirectory()) {
                throw new IllegalArgumentException("folder is not valid directory" + folder.getAbsolutePath());
            }
            this.searchedFolders.add(folder);
        }
    }

    public FileFinder(List<File> folders) {
        this.searchedFolders = new ArrayList<File>();
        for (File folder : folders) {
            if (folder == null) {
                throw new NullPointerException("folder null");
            }
            if (!folder.isDirectory()) {
                throw new IllegalArgumentException("folder is not valid directory" + folder.getAbsolutePath());
            }
            this.searchedFolders.add(folder);
        }
    }

    public List<File> getAllFilesInDirectories() {
        this.files = new ArrayList<File>();
        for (File f : this.searchedFolders) {
            this.getAllFilesInDirectory(f);
        }
        return this.files;
    }

    private void getAllFilesInDirectory(File directory) {
        File[] fList;
        for (File file : fList = directory.listFiles()) {
            if (file.isFile()) {
                this.files.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.getAllFilesInDirectory(new File(file.getAbsolutePath()));
        }
    }

    public List<ApkFile> getApkFilesInDirectories() {
        this.files = this.getFilesInDirectoriesFileTypeMatch("apk", "APK");
        ArrayList<ApkFile> apkFiles = new ArrayList<ApkFile>();
        for (File f : this.files) {
            apkFiles.add(new ApkFile(f));
        }
        return apkFiles;
    }

    public List<File> getCertificateFilesInDirectories() {
        return this.getFilesInDirectoriesFileTypeMatch("RSA", "DSA");
    }

    public List<File> getMFFilesInDirectories() {
        return this.getFilesInDirectoriesFileTypeMatch("MF");
    }

    public List<File> getJsonFilesInDirectories() {
        return this.getFilesInDirectoriesFileTypeMatch("json");
    }

    public List<File> getXmlFilesInDirectories() {
        return this.getFilesInDirectoriesFileTypeMatch("xml", "XML");
    }

    public List<File> getDrawableResourceFiles() {
        return this.getFilesInDirectoriesFileTypeMatch(".jpg", ".jpeg", ".JPG", ".JPEG", ".gif", ".GIF", "png", "PNG", ".xml", ".XML");
    }

    public List<File> getFilesInDirectoriesFileTypeMatch(String ... typeFilter) {
        this.files = new ArrayList<File>();
        for (File directory : this.searchedFolders) {
            this.getFilesInDirectoryFileTypeMatch(directory, typeFilter);
        }
        return this.files;
    }

    private void getFilesInDirectoryFileTypeMatch(File directory, String ... typeFilter) {
        File[] fList;
        for (File file : fList = directory.listFiles()) {
            if (file.isFile()) {
                for (String type : typeFilter) {
                    if (!file.getName().endsWith(type)) continue;
                    this.files.add(file);
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            this.getFilesInDirectoryFileTypeMatch(new File(file.getAbsolutePath()), typeFilter);
        }
    }

    public List<File> getStringResourceFilesInDirectories() {
        this.files = new ArrayList<File>();
        for (File directory : this.searchedFolders) {
            this.getFilesInDirectoryFullNameMatch(directory, "strings.xml");
        }
        return this.files;
    }

    public void getFilesInDirectoryFullNameMatch(File directory, String ... typeFilter) {
        File[] fList;
        for (File file : fList = directory.listFiles()) {
            if (file.isFile()) {
                int n = 0;
                String[] stringArray = typeFilter;
                int n2 = stringArray.length;
                if (n >= n2) continue;
                String type = stringArray[n];
                if (!file.getName().equals(type)) continue;
                this.files.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.getFilesInDirectoryFullNameMatch(new File(file.getAbsolutePath()), typeFilter);
        }
    }

    public List<File> getDirectoriesContainingExpression(String matchExpression) {
        this.files = new ArrayList<File>();
        for (File directory : this.searchedFolders) {
            this.getDirectoriesContainingExpression(directory, matchExpression);
        }
        return this.files;
    }

    private void getDirectoriesContainingExpression(File directory, String matchExpression) {
        File[] fList;
        for (File file : fList = directory.listFiles()) {
            if (!file.isDirectory()) continue;
            if (file.getName().contains(matchExpression)) {
                this.files.add(file);
            }
            this.getDirectoriesContainingExpression(new File(file.getAbsolutePath()), matchExpression);
        }
    }

    public List<File> getDirectoriesStartsWithExpression(String matchExpression) {
        this.files = new ArrayList<File>();
        for (File directory : this.searchedFolders) {
            this.getDirectoriesStartsWithExpression(directory, matchExpression);
        }
        return this.files;
    }

    private void getDirectoriesStartsWithExpression(File directory, String matchExpression) {
        File[] fList;
        for (File file : fList = directory.listFiles()) {
            if (!file.isDirectory()) continue;
            if (file.getName().startsWith(matchExpression)) {
                this.files.add(file);
            }
            this.getDirectoriesStartsWithExpression(new File(file.getAbsolutePath()), matchExpression);
        }
    }
}

