/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.utils.files;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import sk.styk.martin.bakalarka.utils.decompile.ApkDecompiler;
import sk.styk.martin.bakalarka.utils.decompile.ApkUnziper;
import sk.styk.martin.bakalarka.utils.files.TempFileManager;

public class ApkFile
extends File {
    private static final Logger logger = LoggerFactory.getLogger(ApkFile.class);
    private TempFileManager apkWorkingDirectoryManager = new TempFileManager(this);
    private Exception decompilationException;
    private Exception unzipException;

    public ApkFile(File file) {
        this(file.getAbsolutePath());
    }

    public ApkFile(String pathname) {
        super(pathname);
        if (!pathname.endsWith(".apk") && !pathname.endsWith(".APK")) {
            throw new IllegalArgumentException(pathname + " not apk file");
        }
    }

    public ApkFile(String parent, String child) {
        super(parent, child);
        if (!child.endsWith(".apk")) {
            throw new IllegalArgumentException("not apk file");
        }
    }

    public TempFileManager getApkWorkingDirectoryManager() {
        return this.apkWorkingDirectoryManager;
    }

    public File getUnzipDirectory() {
        return this.apkWorkingDirectoryManager.getApkUnzipedDirectory();
    }

    public File getDecompiledDirectory() {
        return this.apkWorkingDirectoryManager.getApkDecompiledDirectory();
    }

    public void cleanApkWorkingDirectory() {
        try {
            this.apkWorkingDirectoryManager.deleteApkWorkingDirectory();
        }
        catch (IOException e) {
            logger.error("cannot clean working directory of" + this.getName());
        }
    }

    public void unzip() {
        try {
            ApkUnziper.getInstance(this).unzip();
        }
        catch (Exception e) {
            this.unzipException = e;
            logger.error(this.getMarker() + " unzip failed");
        }
    }

    public void decompile() {
        try {
            ApkDecompiler.getInstance(this).decompile();
        }
        catch (Exception e) {
            this.decompilationException = e;
            logger.error(this.getMarker() + " decompilation failed");
        }
    }

    public boolean isDecompiled() {
        return this.apkWorkingDirectoryManager.getApkDecompiledDirectory().listFiles().length > 0;
    }

    public boolean isDecompilationFailed() {
        return this.decompilationException != null;
    }

    public boolean isUnziped() {
        return this.apkWorkingDirectoryManager.getApkUnzipedDirectory().listFiles().length > 0;
    }

    public boolean isUnzipFailed() {
        return this.unzipException != null;
    }

    public File getUnzipDirectoryWithUnzipedData() {
        if (!this.isUnziped() && !this.isUnzipFailed()) {
            this.unzip();
        }
        return this.getUnzipDirectory();
    }

    public File getDecompiledDirectoryWithDecompiledData() {
        if (!this.isDecompiled() && !this.isDecompilationFailed()) {
            this.decompile();
        }
        return this.getDecompiledDirectory();
    }

    public Exception getDecompilationException() {
        return this.decompilationException;
    }

    public Exception getUnzipException() {
        return this.unzipException;
    }

    public Marker getMarker() {
        return MarkerFactory.getMarker(" [" + this.getName() + "] ");
    }
}

