/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.utils.decompile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import sk.styk.martin.bakalarka.utils.files.ApkFile;

public class ApkUnziper {
    private static final Logger logger = LoggerFactory.getLogger(ApkUnziper.class);
    private Marker apkNameMarker;
    private ApkFile apkFile;

    public ApkUnziper(ApkFile apkFile) {
        if (apkFile == null) {
            throw new IllegalArgumentException("apkFile null");
        }
        this.apkFile = apkFile;
        this.apkNameMarker = apkFile.getMarker();
    }

    public static ApkUnziper getInstance(ApkFile apkFile) {
        return new ApkUnziper(apkFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip() throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(this.apkFile));
            ZipEntry ze = zis.getNextEntry();
            logger.info(this.apkNameMarker + "Starting unzip");
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(this.apkFile.getUnzipDirectory(), fileName);
                new File(newFile.getParent()).mkdirs();
                try (FileOutputStream fos = null;){
                    int len;
                    fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    logger.trace(this.apkNameMarker + "Unziping file " + newFile.getPath());
                }
                ze = zis.getNextEntry();
            }
            logger.info(this.apkNameMarker + "Finished unzip of apk " + this.apkFile.getName());
        }
        catch (IOException ex) {
            logger.error(this.apkNameMarker + "Error unziping " + this.apkFile.getName());
            throw ex;
        }
        finally {
            if (zis != null) {
                try {
                    zis.closeEntry();
                    zis.close();
                }
                catch (IOException e) {
                    logger.error(this.apkNameMarker + "Closing ZipInputStream failed");
                }
            }
        }
    }
}

