/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.utils.decompile;

import brut.androlib.Androlib;
import brut.androlib.AndrolibException;
import brut.androlib.ApkDecoder;
import brut.androlib.ApkOptions;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import sk.styk.martin.bakalarka.utils.files.ApkFile;

public class ApkDecompiler {
    private static final Logger logger = LoggerFactory.getLogger(ApkDecompiler.class);
    private static boolean isFrameworkInstalled;
    private Marker apkNameMarker;
    private ApkFile apkFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApkDecompiler(ApkFile apkFile) {
        if (apkFile == null) {
            throw new IllegalArgumentException("apkFile null");
        }
        Class<ApkDecompiler> clazz = ApkDecompiler.class;
        synchronized (ApkDecompiler.class) {
            if (!isFrameworkInstalled) {
                ApkDecompiler.installFramework();
                isFrameworkInstalled = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.apkFile = apkFile;
            this.apkNameMarker = apkFile.getMarker();
            return;
        }
    }

    public static ApkDecompiler getInstance(ApkFile apkFile) {
        return new ApkDecompiler(apkFile);
    }

    private static void installFramework() {
        logger.info("Installing framework-res.apk");
        ApkOptions apkOptions = new ApkOptions();
        try {
            new Androlib(apkOptions).installFramework(new File("lib" + File.separator + "framework-res.apk"));
        }
        catch (AndrolibException e) {
            logger.warn("Installing framework-res.apk FAILED");
        }
    }

    public void decompile() throws Exception {
        ApkDecoder decoder = new ApkDecoder();
        decoder.setApkFile(this.apkFile);
        decoder.setForceDelete(true);
        try {
            decoder.setDecodeSources((short)0);
            decoder.setDecodeAssets((short)1);
            decoder.setDecodeResources((short)257);
        }
        catch (AndrolibException e) {
            logger.error(this.apkNameMarker + e.toString());
        }
        decoder.setOutDir(this.apkFile.getDecompiledDirectory());
        logger.info(this.apkNameMarker + "Starting decompilation");
        try {
            decoder.decode();
            logger.info(this.apkNameMarker + "Succesfully finished decompilation");
        }
        catch (Exception e) {
            logger.error(this.apkNameMarker + "Finished decompilation with exception : " + e.toString());
            throw e;
        }
    }
}

