/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.utils.data;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.statistics.processors.helpers.ConversionHelper;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;

public class MathStatistics {
    private static final Logger logger = LoggerFactory.getLogger(MathStatistics.class);
    private PercentagePair analyzedDataSet;
    private BigDecimal arithmeticMean;
    private Long median;
    private List<Long> modus;
    private RecordPair max;
    private RecordPair min;
    private BigDecimal variance;
    private BigDecimal deviation;

    public MathStatistics(PercentagePair analyzedDataSet, Number arithmeticMean, Number median, List<Number> modus, RecordPair max, RecordPair min2, Number variance, Number deviation) {
        this.analyzedDataSet = analyzedDataSet;
        this.arithmeticMean = new BigDecimal(arithmeticMean.doubleValue());
        this.median = median.longValue();
        this.modus = ConversionHelper.toLongList(modus);
        this.max = max;
        this.min = min2;
        this.variance = new BigDecimal(variance.doubleValue());
        this.deviation = new BigDecimal(deviation.doubleValue());
    }

    public MathStatistics(PercentagePair analyzedDataSet, List<Double> data, RecordPair minimalValue, RecordPair maximalValue) {
        this(analyzedDataSet, ConversionHelper.toDoubleArray(data), minimalValue, maximalValue);
    }

    public MathStatistics(PercentagePair analyzedDataSet, double[] data, RecordPair minimalValue, RecordPair maximalValue) {
        this.analyzedDataSet = analyzedDataSet;
        this.min = minimalValue;
        this.max = maximalValue;
        this.computeStatistics(data);
    }

    public static Logger getLogger() {
        return logger;
    }

    private void computeStatistics(double[] array) {
        logger.trace("Started processing stats");
        if (array == null || array.length == 0) {
            logger.trace("array empty, finishing processing data without results");
            return;
        }
        Double mean = StatUtils.mean(array);
        Double median = StatUtils.percentile(array, 50.0);
        double[] modus = StatUtils.mode(array);
        Double minimum = StatUtils.min(array);
        Double maximum = StatUtils.max(array);
        Double variance = StatUtils.variance(array);
        Double deviation = Math.sqrt(variance);
        this.arithmeticMean = new BigDecimal(mean);
        this.median = median.longValue();
        this.modus = ConversionHelper.toLongList(modus);
        this.min = this.min == null ? new RecordPair(minimum.longValue(), null) : this.min;
        this.max = this.max == null ? new RecordPair(maximum.longValue(), null) : this.max;
        this.variance = new BigDecimal(variance);
        this.deviation = new BigDecimal(deviation);
        logger.trace("Finished processing stats");
    }

    public PercentagePair getAnalyzedDataSet() {
        return this.analyzedDataSet;
    }

    public void setAnalyzedDataSet(PercentagePair analyzedDataSet) {
        this.analyzedDataSet = analyzedDataSet;
    }

    public BigDecimal getArithmeticMean() {
        return this.arithmeticMean;
    }

    public void setArithmeticMean(BigDecimal arithmeticMean) {
        this.arithmeticMean = arithmeticMean;
    }

    public Long getMedian() {
        return this.median;
    }

    public void setMedian(Long median) {
        this.median = median;
    }

    public List<Long> getModus() {
        return this.modus;
    }

    public void setModus(List<Long> modus) {
        this.modus = modus;
    }

    public RecordPair getMax() {
        return this.max;
    }

    public void setMax(RecordPair max) {
        this.max = max;
    }

    public RecordPair getMin() {
        return this.min;
    }

    public void setMin(RecordPair min2) {
        this.min = min2;
    }

    public BigDecimal getVariance() {
        return this.variance;
    }

    public void setVariance(BigDecimal variance) {
        this.variance = variance;
    }

    public BigDecimal getDeviation() {
        return this.deviation;
    }

    public void setDeviation(BigDecimal deviation) {
        this.deviation = deviation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MathStatistics that = (MathStatistics)o;
        if (this.analyzedDataSet != null ? !this.analyzedDataSet.equals(that.analyzedDataSet) : that.analyzedDataSet != null) {
            return false;
        }
        if (this.arithmeticMean != null ? !this.arithmeticMean.equals(that.arithmeticMean) : that.arithmeticMean != null) {
            return false;
        }
        if (this.median != null ? !this.median.equals(that.median) : that.median != null) {
            return false;
        }
        if (this.modus != null ? !this.modus.equals(that.modus) : that.modus != null) {
            return false;
        }
        if (this.max != null ? !this.max.equals(that.max) : that.max != null) {
            return false;
        }
        if (this.min != null ? !this.min.equals(that.min) : that.min != null) {
            return false;
        }
        if (this.variance != null ? !this.variance.equals(that.variance) : that.variance != null) {
            return false;
        }
        return !(this.deviation == null ? that.deviation != null : !this.deviation.equals(that.deviation));
    }

    public int hashCode() {
        int result = this.analyzedDataSet != null ? this.analyzedDataSet.hashCode() : 0;
        result = 31 * result + (this.arithmeticMean != null ? this.arithmeticMean.hashCode() : 0);
        result = 31 * result + (this.median != null ? this.median.hashCode() : 0);
        result = 31 * result + (this.modus != null ? this.modus.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.variance != null ? this.variance.hashCode() : 0);
        result = 31 * result + (this.deviation != null ? this.deviation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MathStatistics{analyzedDataSet=" + this.analyzedDataSet + ", arithmeticMean=" + this.arithmeticMean + ", median=" + this.median + ", modus=" + this.modus + ", max=" + this.max + ", min=" + this.min + ", variance=" + this.variance + ", deviation=" + this.deviation + '}';
    }
}

