/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sk.styk.martin.bakalarka.utils.data.RecordPair;

public class TopValueProcessorBase<X> {
    private Map<String, RecordPair<Number, X>> maxInventary = new HashMap<String, RecordPair<Number, X>>();
    private Map<String, RecordPair<Number, X>> minInventary = new HashMap<String, RecordPair<Number, X>>();

    public void requestMaxValues(Enum e) {
        this.requestMaxValues(e.toString());
    }

    public void requestMaxValues(String name) {
        if (this.maxInventary.containsKey(name)) {
            throw new IllegalArgumentException("max values for this name already in use");
        }
        this.maxInventary.put(name, new RecordPair(0, new ArrayList()));
    }

    public RecordPair<Number, X> processMaxExtreme(Enum name, Integer currentValue, X currentName) {
        if (currentValue == null) {
            return null;
        }
        return this.processMaxExtreme(name.toString(), (Long)currentValue.longValue(), currentName);
    }

    public RecordPair<Number, X> processMaxExtreme(String name, Integer currentValue, X currentName) {
        if (currentValue == null) {
            return null;
        }
        return this.processMaxExtreme(name, (Long)currentValue.longValue(), currentName);
    }

    public RecordPair<Number, X> processMaxExtreme(Enum name, Long currentValue, X currentName) {
        if (currentValue == null) {
            return null;
        }
        return this.processMaxExtreme(name.toString(), currentValue, currentName);
    }

    public RecordPair<Number, X> processMaxExtreme(String name, Long currentValue, X currentName) {
        if (currentValue == null) {
            return null;
        }
        RecordPair<Number, X> currentRecordPair = this.maxInventary.get(name);
        if (currentRecordPair == null) {
            throw new IllegalArgumentException("unknown name, max values are for this name not in use");
        }
        Long oldMax = currentRecordPair.getNumber().longValue();
        List<X> oldList = currentRecordPair.getNames();
        if (currentValue > oldMax) {
            oldList.clear();
            oldList.add(currentName);
            currentRecordPair.setNumber(currentValue);
        } else if (currentValue == oldMax) {
            oldList.add(currentName);
        }
        return currentRecordPair;
    }

    public void requestMinValues(Enum e) {
        this.requestMinValues(e.toString());
    }

    public void requestMinValues(String name) {
        if (this.minInventary.containsKey(name)) {
            throw new IllegalArgumentException("min values for this name already in use");
        }
        this.minInventary.put(name, new RecordPair(Long.MAX_VALUE, new ArrayList()));
    }

    public RecordPair<Number, X> processMinExtreme(Enum name, Integer currentValue, X currentName) {
        if (currentValue == null) {
            return null;
        }
        return this.processMinExtreme(name.toString(), currentValue.longValue(), currentName);
    }

    public RecordPair<Number, X> processMinExtreme(String name, Integer currentValue, X currentName) {
        if (currentValue == null) {
            return null;
        }
        return this.processMinExtreme(name, currentValue.longValue(), currentName);
    }

    public RecordPair<Number, X> processMinExtreme(Enum name, Long currentValue, X currentName) {
        if (currentValue == null) {
            return null;
        }
        return this.processMinExtreme(name.toString(), (long)currentValue, currentName);
    }

    public RecordPair<Number, X> processMinExtreme(String name, long currentValue, X currentName) {
        RecordPair<Number, X> currentRecordPair = this.minInventary.get(name);
        if (currentRecordPair == null) {
            throw new IllegalArgumentException("unknown name, min values are for this name not in use");
        }
        Long oldMin = currentRecordPair.getNumber().longValue();
        List<X> oldList = currentRecordPair.getNames();
        if (currentValue < oldMin) {
            oldList.clear();
            oldList.add(currentName);
            currentRecordPair.setNumber(currentValue);
        } else if (currentValue == oldMin) {
            oldList.add(currentName);
        }
        return currentRecordPair;
    }
}

