/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import sk.styk.martin.bakalarka.statistics.processors.TopValueProcessorBase;
import sk.styk.martin.bakalarka.statistics.processors.helpers.PercentageHelper;
import sk.styk.martin.bakalarka.statistics.processors.helpers.SortingHelper;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;

public abstract class TopListProcessorBase<X>
extends TopValueProcessorBase {
    protected abstract Logger getLogger();

    protected Map<X, PercentagePair> getTopValuesMapInteger(Map<X, Integer> topValues, int wholeData, String type) {
        this.getLogger().info("Started processing chart " + type);
        if (topValues == null) {
            throw new IllegalArgumentException("topValues");
        }
        HashMap<X, PercentagePair> withPercentage = new HashMap<X, PercentagePair>();
        for (Map.Entry<X, Integer> entry : topValues.entrySet()) {
            X name = entry.getKey();
            Integer number = entry.getValue();
            BigDecimal percentage = PercentageHelper.getPercentage(number.doubleValue(), wholeData);
            PercentagePair percentageEntry = new PercentagePair((Number)number, percentage);
            withPercentage.put(name, percentageEntry);
        }
        Map resultFinal = SortingHelper.sortByValue(withPercentage);
        this.getLogger().info("Finished processing chart chart " + type);
        return resultFinal;
    }

    protected Map<X, PercentagePair> getTopValuesMap(Map<X, PercentagePair> topValues, int number, String type) {
        this.getLogger().info("Started processing chart for " + type);
        if (topValues == null) {
            throw new IllegalArgumentException("topValues");
        }
        for (Map.Entry<X, PercentagePair> entry : topValues.entrySet()) {
            PercentagePair pair = entry.getValue();
            Integer count = pair.getCount().intValue();
            pair.setPercentage(PercentageHelper.getPercentage(count.doubleValue(), number));
        }
        this.getLogger().info("Finished processing chart for " + type);
        return SortingHelper.sortByValue(topValues);
    }
}

