/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.List;
import sk.styk.martin.bakalarka.statistics.data.AppComponentsStatistics;
import sk.styk.martin.bakalarka.statistics.data.CertificateStatistics;
import sk.styk.martin.bakalarka.statistics.data.DefinedPermissionsStatistics;
import sk.styk.martin.bakalarka.statistics.data.DrawableStatistics;
import sk.styk.martin.bakalarka.statistics.data.FeaturesStatistics;
import sk.styk.martin.bakalarka.statistics.data.FileSizeStatistics;
import sk.styk.martin.bakalarka.statistics.data.FileStatistics;
import sk.styk.martin.bakalarka.statistics.data.InstallLocationStatistics;
import sk.styk.martin.bakalarka.statistics.data.LibrariesStatistics;
import sk.styk.martin.bakalarka.statistics.data.LocalizationsStatistics;
import sk.styk.martin.bakalarka.statistics.data.OverallStatistics;
import sk.styk.martin.bakalarka.statistics.data.PermissionsStatistics;
import sk.styk.martin.bakalarka.statistics.data.ResourceStatistics;
import sk.styk.martin.bakalarka.statistics.data.ScreenStatistics;
import sk.styk.martin.bakalarka.statistics.data.SdkStatistics;
import sk.styk.martin.bakalarka.statistics.processors.AppComponentsStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.CertificateStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.DefinedPermissionsStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.DrawableStatisticsProcessors;
import sk.styk.martin.bakalarka.statistics.processors.FeaturesStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.FileSizeStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.FileStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.InstallLocationProcessor;
import sk.styk.martin.bakalarka.statistics.processors.LibrariesStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.LocalizationsStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.PermissionsStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.ResourceStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.ScreenStatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.SdkStatisticsProcessor;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class StatisticsProcessor {
    public static int PRINT_MESSAGE_INTERVAL = 250;
    private List<File> jsons;
    private File outputFile;
    private OverallStatistics overallStatistics;

    public StatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons not valid");
        }
        this.jsons = jsons;
    }

    public static StatisticsProcessor ofFiles(List<File> jsons) {
        return new StatisticsProcessor(jsons);
    }

    public OverallStatistics processFiles() {
        this.overallStatistics = new OverallStatistics();
        this.overallStatistics.setTotalAnalyzedApks(this.jsons.size());
        FileSizeStatistics fileSizeStatistics = FileSizeStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setFileSizeStatistics(fileSizeStatistics);
        InstallLocationStatistics installLocationStatistics = InstallLocationProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setInstallLocationStatistics(installLocationStatistics);
        AppComponentsStatistics appComponentsStatistics = AppComponentsStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setAppComponentsStatistics(appComponentsStatistics);
        PermissionsStatistics permissionsStatistics = PermissionsStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setPermissionsStatistics(permissionsStatistics);
        LibrariesStatistics librariesStatistics = LibrariesStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setLibrariesStatistics(librariesStatistics);
        FeaturesStatistics featuresStatistics = FeaturesStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setFeaturesStatistics(featuresStatistics);
        DefinedPermissionsStatistics definedPermissionsStatistics = DefinedPermissionsStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setDefinedPermissionsStatistics(definedPermissionsStatistics);
        SdkStatistics sdkStatistics = SdkStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setSdkStatistics(sdkStatistics);
        ScreenStatistics screenStatistics = ScreenStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setScreenStatistics(screenStatistics);
        CertificateStatistics certificateStatistics = CertificateStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setCertificateStatistics(certificateStatistics);
        LocalizationsStatistics localizationsStatistics = LocalizationsStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setLocalizationsStatistics(localizationsStatistics);
        DrawableStatistics drawableStatistics = DrawableStatisticsProcessors.ofFiles(this.jsons).process();
        this.overallStatistics.setDrawableStatistics(drawableStatistics);
        ResourceStatistics resourceStatistics = ResourceStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setAdditionalResourceStatistics(resourceStatistics);
        FileStatistics fileStatistics = FileStatisticsProcessor.ofFiles(this.jsons).process();
        this.overallStatistics.setFileStatistics(fileStatistics);
        if (this.outputFile != null) {
            JsonUtils.toJson(this.overallStatistics, this.outputFile);
        }
        return this.overallStatistics;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }
}

