/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.AndroidManifestData;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.statistics.data.SdkStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopListProcessorBase;
import sk.styk.martin.bakalarka.statistics.processors.helpers.PercentageHelper;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class SdkStatisticsProcessor
extends TopListProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(SdkStatisticsProcessor.class);
    private List<File> jsons;
    private SdkStatistics sdkStatistics;

    public SdkStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static SdkStatisticsProcessor ofFiles(List<File> jsons) {
        return new SdkStatisticsProcessor(jsons);
    }

    public SdkStatistics process() {
        this.sdkStatistics = new SdkStatistics();
        HashMap<String, PercentagePair> topMinSdk = new HashMap<String, PercentagePair>();
        HashMap<String, PercentagePair> topTargetSdk = new HashMap<String, PercentagePair>();
        HashMap<String, PercentagePair> topMaxSdk = new HashMap<String, PercentagePair>();
        int numMinSdk = 0;
        int numTargetSdk = 0;
        int numMaxSdk = 0;
        int manifestFound = 0;
        int usesSdkFound = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            String maxSdk;
            String targetSkd;
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            File f = this.jsons.get(i);
            ApkData data = JsonUtils.fromJson(f);
            AndroidManifestData manifestData = null;
            if (data == null || data.getAndroidManifest() == null) continue;
            ++manifestFound;
            manifestData = data.getAndroidManifest();
            boolean usesSdkTagFound = false;
            String minSkd = manifestData.getUsesMinSdkVersion();
            if (minSkd != null && !minSkd.isEmpty()) {
                ++numMinSdk;
                usesSdkTagFound = true;
                if (topMinSdk.containsKey(minSkd)) {
                    PercentagePair percentagePair = (PercentagePair)topMinSdk.get(minSkd);
                    Integer oldValue = percentagePair.getCount().intValue();
                    oldValue = oldValue + 1;
                    percentagePair.setCount(oldValue);
                } else {
                    topMinSdk.put(minSkd, new PercentagePair((Number)1, null));
                }
            }
            if ((targetSkd = manifestData.getUsesTargetSdkVersion()) != null && !targetSkd.isEmpty()) {
                ++numTargetSdk;
                usesSdkTagFound = true;
                if (topTargetSdk.containsKey(targetSkd)) {
                    PercentagePair percentagePair = (PercentagePair)topTargetSdk.get(targetSkd);
                    Integer oldValue = percentagePair.getCount().intValue();
                    oldValue = oldValue + 1;
                    percentagePair.setCount(oldValue);
                } else {
                    topTargetSdk.put(targetSkd, new PercentagePair((Number)1, null));
                }
            }
            if ((maxSdk = manifestData.getUsesMaxSdkVersion()) != null && !maxSdk.isEmpty()) {
                usesSdkTagFound = true;
                ++numMaxSdk;
                if (topMaxSdk.containsKey(maxSdk)) {
                    PercentagePair percentagePair = (PercentagePair)topMaxSdk.get(maxSdk);
                    Integer oldValue = percentagePair.getCount().intValue();
                    oldValue = oldValue + 1;
                    percentagePair.setCount(oldValue);
                } else {
                    topMaxSdk.put(maxSdk, new PercentagePair((Number)1, null));
                }
            }
            if (!usesSdkTagFound) continue;
            ++usesSdkFound;
        }
        this.sdkStatistics.setAnalyzedApks(manifestFound);
        this.sdkStatistics.setApksWithGeneralUsesSdkTagObtained(new PercentagePair((Number)usesSdkFound, PercentageHelper.getPercentage(usesSdkFound, manifestFound)));
        this.sdkStatistics.setApksWithMinSdkTagObtained(new PercentagePair((Number)numMinSdk, PercentageHelper.getPercentage(numMinSdk, manifestFound)));
        this.sdkStatistics.setApksWithMaxSdkTagObtained(new PercentagePair((Number)numMaxSdk, PercentageHelper.getPercentage(numMaxSdk, manifestFound)));
        this.sdkStatistics.setApksWithTargetSdkTagObtained(new PercentagePair((Number)numTargetSdk, PercentageHelper.getPercentage(numTargetSdk, manifestFound)));
        this.setTop(topMinSdk, numMinSdk, Type.MIN);
        this.setTop(topTargetSdk, numTargetSdk, Type.TARGET);
        this.setTop(topMaxSdk, numMaxSdk, Type.MAX);
        return this.sdkStatistics;
    }

    private void setTop(Map<String, PercentagePair> topSdk, int number, Type type) {
        Map<String, PercentagePair> topVal = this.getTopValuesMap(topSdk, number, type.toString());
        switch (type) {
            case MAX: {
                this.sdkStatistics.setTopMaxSdk(topVal);
                break;
            }
            case TARGET: {
                this.sdkStatistics.setTopTargetSdk(topVal);
                break;
            }
            case MIN: {
                this.sdkStatistics.setTopMinSdk(topVal);
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    private static enum Type {
        MIN,
        MAX,
        TARGET;

    }
}

