/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.AndroidManifestData;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.statistics.data.ScreenStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopListProcessorBase;
import sk.styk.martin.bakalarka.statistics.processors.helpers.PercentageHelper;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class ScreenStatisticsProcessor
extends TopListProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(ScreenStatisticsProcessor.class);
    private List<File> jsons;
    private ScreenStatistics screenStatistics;

    public ScreenStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static ScreenStatisticsProcessor ofFiles(List<File> jsons) {
        return new ScreenStatisticsProcessor(jsons);
    }

    public ScreenStatistics process() {
        this.screenStatistics = new ScreenStatistics();
        HashMap<String, PercentagePair> resizeableMap = new HashMap<String, PercentagePair>();
        HashMap<String, PercentagePair> smallMap = new HashMap<String, PercentagePair>();
        HashMap<String, PercentagePair> normalMap = new HashMap<String, PercentagePair>();
        HashMap<String, PercentagePair> largeMap = new HashMap<String, PercentagePair>();
        HashMap<String, PercentagePair> xlargeMap = new HashMap<String, PercentagePair>();
        HashMap<String, PercentagePair> anyDensityMap = new HashMap<String, PercentagePair>();
        int manifestFound = 0;
        int numResizeable = 0;
        int numSmall = 0;
        int numNormal = 0;
        int numLarge = 0;
        int numXlarge = 0;
        int numAnyDensity = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            File f = this.jsons.get(i);
            ApkData data = JsonUtils.fromJson(f);
            AndroidManifestData manifestData = null;
            if (data == null || data.getAndroidManifest() == null) continue;
            ++manifestFound;
            manifestData = data.getAndroidManifest();
            Boolean resizealbe = manifestData.getSupportsScreensResizeable();
            if (resizealbe != null) {
                ++numResizeable;
            } else {
                resizealbe = true;
            }
            if (resizeableMap.containsKey(resizealbe.toString())) {
                PercentagePair percentagePair = (PercentagePair)resizeableMap.get(resizealbe.toString());
                Integer oldValue = percentagePair.getCount().intValue();
                oldValue = oldValue + 1;
                percentagePair.setCount(oldValue);
            } else {
                resizeableMap.put(resizealbe.toString(), new PercentagePair((Number)1, null));
            }
            Boolean small = manifestData.getSupportsScreensSmall();
            if (small != null) {
                ++numSmall;
            } else {
                small = true;
            }
            if (smallMap.containsKey(small.toString())) {
                PercentagePair percentagePair = (PercentagePair)smallMap.get(small.toString());
                Integer oldValue = percentagePair.getCount().intValue();
                oldValue = oldValue + 1;
                percentagePair.setCount(oldValue);
            } else {
                smallMap.put(small.toString(), new PercentagePair((Number)1, null));
            }
            Boolean normal = manifestData.getSupportsScreensNormal();
            if (normal != null) {
                ++numNormal;
            } else {
                normal = true;
            }
            if (normalMap.containsKey(normal.toString())) {
                PercentagePair percentagePair = (PercentagePair)normalMap.get(normal.toString());
                Integer oldValue = percentagePair.getCount().intValue();
                oldValue = oldValue + 1;
                percentagePair.setCount(oldValue);
            } else {
                normalMap.put(normal.toString(), new PercentagePair((Number)1, null));
            }
            Boolean large = manifestData.getSupportsScreensLarge();
            if (large != null) {
                ++numLarge;
            } else {
                large = true;
            }
            if (largeMap.containsKey(large.toString())) {
                PercentagePair percentagePair = (PercentagePair)largeMap.get(large.toString());
                Integer oldValue = percentagePair.getCount().intValue();
                oldValue = oldValue + 1;
                percentagePair.setCount(oldValue);
            } else {
                largeMap.put(large.toString(), new PercentagePair((Number)1, null));
            }
            Boolean xlarge = manifestData.getSupportsScreensXlarge();
            if (xlarge != null) {
                ++numXlarge;
            } else {
                xlarge = true;
            }
            if (xlargeMap.containsKey(xlarge.toString())) {
                PercentagePair percentagePair = (PercentagePair)xlargeMap.get(xlarge.toString());
                Integer oldValue = percentagePair.getCount().intValue();
                oldValue = oldValue + 1;
                percentagePair.setCount(oldValue);
            } else {
                xlargeMap.put(xlarge.toString(), new PercentagePair((Number)1, null));
            }
            Boolean anyDensity = manifestData.getSupportsScreensAnyDensity();
            if (anyDensity != null) {
                ++numAnyDensity;
            } else {
                anyDensity = true;
            }
            if (anyDensityMap.containsKey(anyDensity.toString())) {
                PercentagePair percentagePair = (PercentagePair)anyDensityMap.get(anyDensity.toString());
                Integer oldValue = percentagePair.getCount().intValue();
                oldValue = oldValue + 1;
                percentagePair.setCount(oldValue);
                continue;
            }
            anyDensityMap.put(anyDensity.toString(), new PercentagePair((Number)1, null));
        }
        this.screenStatistics.setAnalyzedApks(manifestFound);
        this.screenStatistics.setSupportsScreensResizeableObtained(new PercentagePair((Number)numResizeable, PercentageHelper.getPercentage(numResizeable, manifestFound)));
        this.screenStatistics.setSupportsScreensSmallObtained(new PercentagePair((Number)numSmall, PercentageHelper.getPercentage(numSmall, manifestFound)));
        this.screenStatistics.setSupportsScreensNormalObtained(new PercentagePair((Number)numNormal, PercentageHelper.getPercentage(numNormal, manifestFound)));
        this.screenStatistics.setSupportsScreensLargeObtained(new PercentagePair((Number)numLarge, PercentageHelper.getPercentage(numLarge, manifestFound)));
        this.screenStatistics.setSupportsScreensXlargeObtained(new PercentagePair((Number)numXlarge, PercentageHelper.getPercentage(numXlarge, manifestFound)));
        this.screenStatistics.setSupportsScreensAnyDensityObtained(new PercentagePair((Number)numAnyDensity, PercentageHelper.getPercentage(numAnyDensity, manifestFound)));
        this.setTop(resizeableMap, manifestFound, Type.RESIZEABLE);
        this.setTop(smallMap, manifestFound, Type.SMALL);
        this.setTop(normalMap, manifestFound, Type.NORMAL);
        this.setTop(largeMap, manifestFound, Type.LARGE);
        this.setTop(xlargeMap, manifestFound, Type.XLARGE);
        this.setTop(anyDensityMap, manifestFound, Type.ANY_DENSITY);
        return this.screenStatistics;
    }

    private void setTop(Map<String, PercentagePair> map, int total, Type type) {
        Map<String, PercentagePair> topVal = this.getTopValuesMap(map, total, type.toString());
        switch (type) {
            case RESIZEABLE: {
                this.screenStatistics.setSupportsScreensResizeable(topVal);
                break;
            }
            case SMALL: {
                this.screenStatistics.setSupportsScreensSmall(topVal);
                break;
            }
            case NORMAL: {
                this.screenStatistics.setSupportsScreensNormal(topVal);
                break;
            }
            case LARGE: {
                this.screenStatistics.setSupportsScreensLarge(topVal);
                break;
            }
            case XLARGE: {
                this.screenStatistics.setSupportsScreensXlarge(topVal);
                break;
            }
            case ANY_DENSITY: {
                this.screenStatistics.setSupportsScreensAnyDensity(topVal);
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    private static enum Type {
        RESIZEABLE,
        SMALL,
        NORMAL,
        LARGE,
        XLARGE,
        ANY_DENSITY;

    }
}

