/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.analyze.data.ResourceData;
import sk.styk.martin.bakalarka.statistics.data.ResourceStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopValueProcessorBase;
import sk.styk.martin.bakalarka.utils.data.MathStatistics;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class ResourceStatisticsProcessor
extends TopValueProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(ResourceStatisticsProcessor.class);
    private List<File> jsons;
    private ResourceStatistics resourceStatistics;
    private ResourceData resourceData;

    public ResourceStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static ResourceStatisticsProcessor ofFiles(List<File> jsons) {
        return new ResourceStatisticsProcessor(jsons);
    }

    public ResourceStatistics process() {
        this.resourceStatistics = new ResourceStatistics();
        ArrayList<Double> layoutList = new ArrayList<Double>();
        ArrayList<Double> layoutListNonZero = new ArrayList<Double>();
        ArrayList<Double> diffLayoutList = new ArrayList<Double>();
        ArrayList<Double> diffLayoutListNonZero = new ArrayList<Double>();
        ArrayList<Double> menuList = new ArrayList<Double>();
        ArrayList<Double> menuListNonZero = new ArrayList<Double>();
        ArrayList<Double> rawList = new ArrayList<Double>();
        ArrayList<Double> rawListNonZero = new ArrayList<Double>();
        this.requestMaxValues(Type.LAYOUT);
        this.requestMaxValues(Type.LAYOUT_DIFFERENT);
        this.requestMaxValues(Type.MENU);
        this.requestMaxValues(Type.RAW);
        RecordPair<Number, String> layoutRecordPair = null;
        RecordPair<Number, String> layoutDifferentRecordPair = null;
        RecordPair<Number, String> menuRecordPair = null;
        RecordPair<Number, String> rawRecordPair = null;
        int resourceDataFound = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            File f;
            ApkData data;
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            if ((data = JsonUtils.fromJson(f = this.jsons.get(i))) == null || data.getResourceData() == null) continue;
            ++resourceDataFound;
            this.resourceData = data.getResourceData();
            this.obtainValue(this.resourceData.getLayouts(), layoutList, layoutListNonZero);
            layoutRecordPair = this.processMaxExtreme((Enum)Type.LAYOUT, this.resourceData.getLayouts(), data.getFileName());
            this.obtainValue(this.resourceData.getDifferentLayouts(), diffLayoutList, diffLayoutListNonZero);
            layoutDifferentRecordPair = this.processMaxExtreme((Enum)Type.LAYOUT_DIFFERENT, this.resourceData.getDifferentLayouts(), data.getFileName());
            this.obtainValue(this.resourceData.getMenu(), menuList, menuListNonZero);
            menuRecordPair = this.processMaxExtreme((Enum)Type.MENU, this.resourceData.getMenu(), data.getFileName());
            this.obtainValue(this.resourceData.getRawResources(), rawList, rawListNonZero);
            rawRecordPair = this.processMaxExtreme((Enum)Type.RAW, this.resourceData.getRawResources(), data.getFileName());
        }
        this.resourceStatistics.setAnalyzedApks(resourceDataFound);
        this.setValues(Type.LAYOUT, layoutList, resourceDataFound, layoutRecordPair);
        this.setValues(Type.LAYOUT_NONZERO, layoutListNonZero, resourceDataFound, layoutRecordPair);
        this.setValues(Type.LAYOUT_DIFFERENT, diffLayoutList, resourceDataFound, layoutDifferentRecordPair);
        this.setValues(Type.LAYOUT_DIFFERENT_NONZERO, diffLayoutListNonZero, resourceDataFound, layoutDifferentRecordPair);
        this.setValues(Type.MENU, menuList, resourceDataFound, menuRecordPair);
        this.setValues(Type.MENU_NONZERO, menuListNonZero, resourceDataFound, menuRecordPair);
        this.setValues(Type.RAW, rawList, resourceDataFound, rawRecordPair);
        this.setValues(Type.RAW_NONZERO, rawListNonZero, resourceDataFound, rawRecordPair);
        return this.resourceStatistics;
    }

    private void setValues(Type type, List<Double> list, int resourceDataFound, RecordPair max) {
        if (this.resourceStatistics == null) {
            throw new NullPointerException("resourceStatistics null");
        }
        logger.info("Started processing resources " + type.toString());
        MathStatistics mathStatistics = new MathStatistics(new PercentagePair((Number)list.size(), resourceDataFound), list, null, max);
        switch (type) {
            case LAYOUT: {
                this.resourceStatistics.setLayouts(mathStatistics);
                break;
            }
            case LAYOUT_NONZERO: {
                this.resourceStatistics.setLayoutsNonZero(mathStatistics);
                break;
            }
            case LAYOUT_DIFFERENT: {
                this.resourceStatistics.setDifferentLayouts(mathStatistics);
                break;
            }
            case LAYOUT_DIFFERENT_NONZERO: {
                this.resourceStatistics.setDifferentLayoutsNonZero(mathStatistics);
                break;
            }
            case MENU: {
                this.resourceStatistics.setMenu(mathStatistics);
                break;
            }
            case MENU_NONZERO: {
                this.resourceStatistics.setMenuNonZero(mathStatistics);
                break;
            }
            case RAW: {
                this.resourceStatistics.setRawResources(mathStatistics);
                break;
            }
            case RAW_NONZERO: {
                this.resourceStatistics.setRawResourcesNonZero(mathStatistics);
            }
        }
        logger.info("Finished processing resources " + type.toString());
    }

    private void obtainValue(Integer value, List<Double> list, List<Double> listNonZero) {
        if (value != null) {
            list.add(new Double(value.intValue()));
            if (value != 0) {
                listNonZero.add(new Double(value.intValue()));
            }
        }
    }

    private static enum Type {
        LAYOUT,
        LAYOUT_NONZERO,
        LAYOUT_DIFFERENT,
        LAYOUT_DIFFERENT_NONZERO,
        MENU,
        MENU_NONZERO,
        RAW,
        RAW_NONZERO;

    }
}

