/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.analyze.data.ResourceData;
import sk.styk.martin.bakalarka.statistics.data.LocalizationsStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopListProcessorBase;
import sk.styk.martin.bakalarka.utils.data.MathStatistics;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class LocalizationsStatisticsProcessor
extends TopListProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(LocalizationsStatisticsProcessor.class);
    private List<File> jsons;
    private LocalizationsStatistics localizationsStatistics;

    public LocalizationsStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static LocalizationsStatisticsProcessor ofFiles(List<File> jsons) {
        return new LocalizationsStatisticsProcessor(jsons);
    }

    public LocalizationsStatistics process() {
        this.localizationsStatistics = new LocalizationsStatistics();
        int manifestFound = 0;
        HashMap<String, PercentagePair> localizationsMap = new HashMap<String, PercentagePair>();
        HashMap<String, PercentagePair> localizationsMapNormalized = new HashMap<String, PercentagePair>();
        ArrayList<Double> numLocaleList = new ArrayList<Double>();
        ArrayList<Double> numLocaleListListNonZeros = new ArrayList<Double>();
        ArrayList<Double> numStringResourcesList = new ArrayList<Double>();
        ArrayList<Double> numStringResourcesListNonDefault = new ArrayList<Double>();
        this.requestMaxValues(Type.LOCALE);
        this.requestMaxValues(Type.STRING_XML_RESOURCES);
        RecordPair<Number, String> localeRecordPair = null;
        RecordPair<Number, String> stringXmlRecordPair = null;
        for (int i = 0; i < this.jsons.size(); ++i) {
            List<String> localizations;
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            File f = this.jsons.get(i);
            ApkData data = JsonUtils.fromJson(f);
            ResourceData resourceData = null;
            if (data == null || data.getResourceData() == null) continue;
            ++manifestFound;
            resourceData = data.getResourceData();
            Integer numStringResources = resourceData.getNumberOfStringResource();
            if (numStringResources != null) {
                numStringResourcesList.add(numStringResources.doubleValue());
                if (numStringResources > 1) {
                    numStringResourcesListNonDefault.add(numStringResources.doubleValue());
                }
                stringXmlRecordPair = this.processMaxExtreme((Enum)Type.STRING_XML_RESOURCES, numStringResources, data.getFileName());
            }
            if ((localizations = resourceData.getLocale()) == null) continue;
            HashSet<String> alreadyAddedForApk = new HashSet<String>();
            for (String locale : localizations) {
                Integer oldValue;
                PercentagePair percentagePair;
                String localeNormalized = this.getNormalizedLocale(locale);
                if (alreadyAddedForApk.add(localeNormalized.toLowerCase())) {
                    if (localizationsMapNormalized.containsKey(localeNormalized.toLowerCase())) {
                        percentagePair = (PercentagePair)localizationsMapNormalized.get(localeNormalized.toLowerCase());
                        oldValue = percentagePair.getCount().intValue();
                        oldValue = oldValue + 1;
                        percentagePair.setCount(oldValue);
                    } else {
                        localizationsMapNormalized.put(localeNormalized.toLowerCase(), new PercentagePair((Number)1, null));
                    }
                }
                if (localizationsMap.containsKey(locale.toLowerCase())) {
                    percentagePair = (PercentagePair)localizationsMap.get(locale.toLowerCase());
                    oldValue = percentagePair.getCount().intValue();
                    oldValue = oldValue + 1;
                    percentagePair.setCount(oldValue);
                    continue;
                }
                localizationsMap.put(locale.toLowerCase(), new PercentagePair((Number)1, null));
            }
            Integer localizationsSize = localizations.size();
            numLocaleList.add(localizationsSize.doubleValue());
            if (localizationsSize != 0) {
                numLocaleListListNonZeros.add(localizationsSize.doubleValue());
            }
            localeRecordPair = this.processMaxExtreme((Enum)Type.LOCALE, localizationsSize, data.getFileName());
        }
        this.localizationsStatistics.setAnalyzedApks(manifestFound);
        this.setValues(Type.STRING_XML_RESOURCES, numStringResourcesList, manifestFound, stringXmlRecordPair);
        this.setValues(Type.STRING_XML_RESOURCES_NON_DEFAULT, numStringResourcesListNonDefault, manifestFound, stringXmlRecordPair);
        this.setValues(Type.LOCALE, numLocaleList, manifestFound, localeRecordPair);
        this.setValues(Type.LOCALE_NON_ZERO, numLocaleListListNonZeros, manifestFound, localeRecordPair);
        this.localizationsStatistics.setTopLocalizations(this.getTopValuesMap(localizationsMap, numLocaleList.size(), "localizations"));
        this.localizationsStatistics.setTopLocalizationsNormalized(this.getTopValuesMap(localizationsMapNormalized, numLocaleList.size(), "localizationsNormalized"));
        return this.localizationsStatistics;
    }

    private String getNormalizedLocale(String old) {
        if (old.length() <= 2) {
            return old;
        }
        if (old.charAt(2) == '-') {
            return old.substring(0, 2);
        }
        return old;
    }

    private void setValues(Type type, List<Double> list, Integer total, RecordPair max) {
        if (this.localizationsStatistics == null) {
            throw new NullPointerException("localizationsStatistics");
        }
        logger.info("Started processing " + type.toString());
        MathStatistics mathStatistics = new MathStatistics(new PercentagePair((Number)list.size(), total), list, null, max);
        switch (type) {
            case STRING_XML_RESOURCES: {
                this.localizationsStatistics.setDefaultStringXmlEntries(mathStatistics);
                break;
            }
            case STRING_XML_RESOURCES_NON_DEFAULT: {
                this.localizationsStatistics.setDefaultStringXmlEntriesNonDefault(mathStatistics);
                break;
            }
            case LOCALE: {
                this.localizationsStatistics.setLocalizationNumber(mathStatistics);
                break;
            }
            case LOCALE_NON_ZERO: {
                this.localizationsStatistics.setLocalizationNumberNonZero(mathStatistics);
            }
        }
        logger.info("Finished processing " + type.toString());
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    private static enum Type {
        STRING_XML_RESOURCES,
        STRING_XML_RESOURCES_NON_DEFAULT,
        LOCALE,
        LOCALE_NON_ZERO;

    }
}

