/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.AndroidManifestData;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.statistics.data.LibrariesStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopListProcessorBase;
import sk.styk.martin.bakalarka.utils.data.MathStatistics;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class LibrariesStatisticsProcessor
extends TopListProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(LibrariesStatisticsProcessor.class);
    private List<File> jsons;
    private LibrariesStatistics librariesStatistics;

    public LibrariesStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static LibrariesStatisticsProcessor ofFiles(List<File> jsons) {
        return new LibrariesStatisticsProcessor(jsons);
    }

    public LibrariesStatistics process() {
        this.librariesStatistics = new LibrariesStatistics();
        HashMap<String, Integer> topLibraries = new HashMap<String, Integer>();
        ArrayList<Double> librariesNumbersList = new ArrayList<Double>();
        ArrayList<Double> librariesNumbersListNonZero = new ArrayList<Double>();
        this.requestMaxValues("libs");
        RecordPair<Number, String> libsRecordPair = null;
        int manifestFound = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            File f = this.jsons.get(i);
            ApkData data = JsonUtils.fromJson(f);
            AndroidManifestData manifestData = null;
            if (data == null || data.getAndroidManifest() == null) continue;
            ++manifestFound;
            manifestData = data.getAndroidManifest();
            List<String> librariesList = manifestData.getUsesLibrary();
            if (librariesList == null) continue;
            int listSize = librariesList.size();
            librariesNumbersList.add(new Double(listSize));
            if (listSize != 0) {
                librariesNumbersListNonZero.add(new Double(listSize));
            }
            libsRecordPair = this.processMaxExtreme("libs", (Integer)listSize, data.getFileName());
            for (String perm : librariesList) {
                String permLower = perm.toLowerCase();
                if (topLibraries.containsKey(permLower)) {
                    Integer oldValue = (Integer)topLibraries.get(permLower);
                    oldValue = oldValue + 1;
                    topLibraries.put(permLower, oldValue);
                    continue;
                }
                topLibraries.put(permLower, 1);
            }
        }
        this.librariesStatistics.setAnalyzedApks(manifestFound);
        this.setValues(manifestFound, librariesNumbersList, false, libsRecordPair);
        this.setValues(manifestFound, librariesNumbersListNonZero, true, libsRecordPair);
        this.librariesStatistics.setTopLibraries(this.getTopValuesMapInteger(topLibraries, librariesNumbersList.size(), "libraries"));
        return this.librariesStatistics;
    }

    private void setValues(int manifestFound, List<Double> librariesNumbersList, boolean isNonZero, RecordPair max) {
        if (librariesNumbersList == null) {
            throw new NullPointerException("librariesNumbersList null");
        }
        logger.info("Started processing libraries");
        MathStatistics mathStatistics = new MathStatistics(new PercentagePair((Number)librariesNumbersList.size(), manifestFound), librariesNumbersList, null, max);
        if (isNonZero) {
            this.librariesStatistics.setLibrariesNonZero(mathStatistics);
        } else {
            this.librariesStatistics.setLibraries(mathStatistics);
        }
        logger.info("Finished processing permissions");
        logger.info("Finished processing libraries");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

