/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.statistics.data.InstallLocationStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.helpers.PercentageHelper;
import sk.styk.martin.bakalarka.statistics.processors.helpers.SortingHelper;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class InstallLocationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(InstallLocationProcessor.class);
    private List<File> jsons;
    private InstallLocationStatistics installLocationStatistics;

    public InstallLocationProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static InstallLocationProcessor ofFiles(List<File> jsons) {
        return new InstallLocationProcessor(jsons);
    }

    public InstallLocationStatistics process() {
        this.installLocationStatistics = new InstallLocationStatistics();
        HashMap<String, PercentagePair> stats = new HashMap<String, PercentagePair>();
        int installLocationTagFound = 0;
        int manifestFound = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            File f;
            ApkData data;
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            if ((data = JsonUtils.fromJson(f = this.jsons.get(i))) == null || data.getAndroidManifest() == null) continue;
            ++manifestFound;
            String installLocation = data.getAndroidManifest().getInstallLocation();
            if (installLocation != null) {
                ++installLocationTagFound;
            } else {
                installLocation = "internalOnly";
            }
            if (stats.containsKey(installLocation)) {
                PercentagePair percentagePair = (PercentagePair)stats.get(installLocation);
                Integer value = percentagePair.getCount().intValue();
                value = value + 1;
                percentagePair.setCount(value);
                continue;
            }
            stats.put(installLocation, new PercentagePair((Number)1, null));
        }
        this.installLocationStatistics.setAnalyzedApks(manifestFound);
        this.installLocationStatistics.setInstallLocationTagFoundInApks(installLocationTagFound);
        this.setInstallLocations(stats, manifestFound);
        return this.installLocationStatistics;
    }

    private void setInstallLocations(Map<String, PercentagePair> map, Integer wholeData) {
        logger.info("Started processing Install Locations chart");
        if (wholeData == null) {
            throw new IllegalArgumentException("wholeData");
        }
        if (map == null) {
            throw new IllegalArgumentException("topLibraries");
        }
        for (Map.Entry<String, PercentagePair> entry : map.entrySet()) {
            PercentagePair percentagePair = entry.getValue();
            Integer number = percentagePair.getCount().intValue();
            BigDecimal percentage = PercentageHelper.getPercentage(number.doubleValue(), wholeData.intValue());
            percentagePair.setPercentage(percentage);
        }
        this.installLocationStatistics.setInstallLocationTable(SortingHelper.sortByValue(map));
        logger.info("Finished processing Install Locations chart");
    }
}

