/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.analyze.data.HashData;
import sk.styk.martin.bakalarka.statistics.data.FileStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopValueProcessorBase;
import sk.styk.martin.bakalarka.utils.data.MathStatistics;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class FileStatisticsProcessor
extends TopValueProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(FileStatisticsProcessor.class);
    private List<File> jsons;
    private FileStatistics fileStatistics;

    public FileStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static FileStatisticsProcessor ofFiles(List<File> jsons) {
        return new FileStatisticsProcessor(jsons);
    }

    public FileStatistics process() {
        this.fileStatistics = new FileStatistics();
        ArrayList<Double> layoutDirectorySizeList = new ArrayList<Double>();
        ArrayList<Double> drawableDirectorySizeList = new ArrayList<Double>();
        ArrayList<Double> otherDirectorySizeList = new ArrayList<Double>();
        ArrayList<Double> apkTotalFilesList = new ArrayList<Double>();
        this.requestMaxValues(Type.LAYOUT);
        this.requestMaxValues(Type.DRAWABLE);
        this.requestMaxValues(Type.OTHER);
        this.requestMaxValues(Type.ALL);
        RecordPair<Number, String> layoutRecordPairMax = null;
        RecordPair<Number, String> drawableRecordPairMax = null;
        RecordPair<Number, String> otherRecordPairMax = null;
        RecordPair<Number, String> allRecordPairMax = null;
        this.requestMinValues(Type.LAYOUT);
        this.requestMinValues(Type.DRAWABLE);
        this.requestMinValues(Type.OTHER);
        this.requestMinValues(Type.ALL);
        RecordPair<Number, String> layoutRecordPairMin = null;
        RecordPair<Number, String> drawableRecordPairMin = null;
        RecordPair<Number, String> otherRecordPairMin = null;
        RecordPair<Number, String> allRecordPairMin = null;
        int hashDataFound = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            File f = this.jsons.get(i);
            ApkData data = JsonUtils.fromJson(f);
            HashData hashData = null;
            if (data == null || data.getFileDigest() == null) continue;
            hashData = data.getFileDigest();
            int drawable = hashData.getDrawableHash() == null ? 0 : hashData.getDrawableHash().size();
            int layout = hashData.getLayoutHash() == null ? 0 : hashData.getLayoutHash().size();
            int other = hashData.getOtherHash() == null ? 0 : hashData.getOtherHash().size() + 2;
            int total = drawable + layout + other;
            if (drawable == 0 && layout == 0 && other == 0) continue;
            ++hashDataFound;
            if (drawable != 0) {
                drawableDirectorySizeList.add(new Double(drawable));
                drawableRecordPairMax = this.processMaxExtreme((Enum)Type.DRAWABLE, (Integer)drawable, data.getFileName());
                drawableRecordPairMin = this.processMinExtreme((Enum)Type.DRAWABLE, (Integer)drawable, data.getFileName());
            }
            if (layout != 0) {
                layoutDirectorySizeList.add(new Double(layout));
                layoutRecordPairMax = this.processMaxExtreme((Enum)Type.LAYOUT, (Integer)layout, data.getFileName());
                layoutRecordPairMin = this.processMinExtreme((Enum)Type.LAYOUT, (Integer)layout, data.getFileName());
            }
            if (other != 0) {
                otherDirectorySizeList.add(new Double(other));
                otherRecordPairMax = this.processMaxExtreme((Enum)Type.OTHER, (Integer)other, data.getFileName());
                otherRecordPairMin = this.processMinExtreme((Enum)Type.OTHER, (Integer)other, data.getFileName());
            }
            allRecordPairMax = this.processMaxExtreme((Enum)Type.ALL, (Integer)total, data.getFileName());
            allRecordPairMin = this.processMinExtreme((Enum)Type.ALL, (Integer)total, data.getFileName());
            apkTotalFilesList.add(new Double(total));
        }
        this.fileStatistics.setAnalyzedApks(hashDataFound);
        this.setValues(Type.LAYOUT, layoutDirectorySizeList, layoutDirectorySizeList.size(), layoutRecordPairMin, layoutRecordPairMax);
        this.setValues(Type.DRAWABLE, drawableDirectorySizeList, drawableDirectorySizeList.size(), drawableRecordPairMin, drawableRecordPairMax);
        this.setValues(Type.OTHER, otherDirectorySizeList, otherDirectorySizeList.size(), otherRecordPairMin, otherRecordPairMax);
        this.setValues(Type.ALL, apkTotalFilesList, hashDataFound, allRecordPairMin, allRecordPairMax);
        return this.fileStatistics;
    }

    private void setValues(Type type, List<Double> list, int resourceDataFound, RecordPair min2, RecordPair max) {
        if (this.fileStatistics == null) {
            throw new NullPointerException("fileStatistics null");
        }
        logger.info("Started processing files " + type.toString());
        MathStatistics mathStatistics = new MathStatistics(new PercentagePair((Number)list.size(), resourceDataFound), list, min2, max);
        switch (type) {
            case LAYOUT: {
                this.fileStatistics.setFilesInLayoutFolder(mathStatistics);
                break;
            }
            case DRAWABLE: {
                this.fileStatistics.setFilesInDrawableFolder(mathStatistics);
                break;
            }
            case OTHER: {
                this.fileStatistics.setOtherFiles(mathStatistics);
                break;
            }
            case ALL: {
                this.fileStatistics.setAllFiles(mathStatistics);
            }
        }
        logger.info("Finished processing files " + type.toString());
    }

    private static enum Type {
        LAYOUT,
        DRAWABLE,
        OTHER,
        ALL;

    }
}

