/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.statistics.data.FileSizeStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopValueProcessorBase;
import sk.styk.martin.bakalarka.statistics.processors.helpers.ConversionHelper;
import sk.styk.martin.bakalarka.utils.data.MathStatistics;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class FileSizeStatisticsProcessor
extends TopValueProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(FileSizeStatisticsProcessor.class);
    private List<File> jsons;
    private FileSizeStatistics fileSizeStatistics;

    public FileSizeStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static FileSizeStatisticsProcessor ofFiles(List<File> jsons) {
        return new FileSizeStatisticsProcessor(jsons);
    }

    public FileSizeStatistics process() {
        this.fileSizeStatistics = new FileSizeStatistics();
        ArrayList<Double> fileSizeList = new ArrayList<Double>();
        ArrayList<Double> arscSizeList = new ArrayList<Double>();
        ArrayList<Double> dexSizeList = new ArrayList<Double>();
        this.requestMaxValues(Type.FILE_SIZE);
        this.requestMaxValues(Type.DEX_SIZE);
        this.requestMaxValues(Type.ARSC_SIZE);
        RecordPair<Number, String> fileRecordPairMax = null;
        RecordPair<Number, String> dexRecordPairMax = null;
        RecordPair<Number, String> arscRecordPairMax = null;
        this.requestMinValues(Type.FILE_SIZE);
        this.requestMinValues(Type.DEX_SIZE);
        this.requestMinValues(Type.ARSC_SIZE);
        RecordPair<Number, String> fileRecordPairMin = null;
        RecordPair<Number, String> dexRecordPairMin = null;
        RecordPair<Number, String> arscRecordPairMin = null;
        for (int i = 0; i < this.jsons.size(); ++i) {
            Double dexSizeValue;
            Double arscSizeValue;
            File f;
            ApkData data;
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            if ((data = JsonUtils.fromJson(f = this.jsons.get(i))) == null) continue;
            Double fileSizeValue = this.getValue(Type.FILE_SIZE, data);
            if (fileSizeValue != null) {
                fileSizeList.add(fileSizeValue);
                fileRecordPairMax = this.processMaxExtreme((Enum)Type.FILE_SIZE, (Long)fileSizeValue.longValue(), data.getFileName());
                fileRecordPairMin = this.processMinExtreme((Enum)Type.FILE_SIZE, (Long)fileSizeValue.longValue(), data.getFileName());
            }
            if ((arscSizeValue = this.getValue(Type.ARSC_SIZE, data)) != null) {
                arscSizeList.add(arscSizeValue);
                arscRecordPairMax = this.processMaxExtreme((Enum)Type.ARSC_SIZE, (Long)arscSizeValue.longValue(), data.getFileName());
                arscRecordPairMin = this.processMinExtreme((Enum)Type.ARSC_SIZE, (Long)arscSizeValue.longValue(), data.getFileName());
            }
            if ((dexSizeValue = this.getValue(Type.DEX_SIZE, data)) == null) continue;
            dexSizeList.add(dexSizeValue);
            dexRecordPairMax = this.processMaxExtreme((Enum)Type.DEX_SIZE, (Long)dexSizeValue.longValue(), data.getFileName());
            dexRecordPairMin = this.processMinExtreme((Enum)Type.DEX_SIZE, (Long)dexSizeValue.longValue(), data.getFileName());
        }
        this.setValues(Type.FILE_SIZE, ConversionHelper.toDoubleArray(fileSizeList), fileSizeList.size(), fileRecordPairMin, fileRecordPairMax);
        this.setValues(Type.ARSC_SIZE, ConversionHelper.toDoubleArray(arscSizeList), arscSizeList.size(), arscRecordPairMin, arscRecordPairMax);
        this.setValues(Type.DEX_SIZE, ConversionHelper.toDoubleArray(dexSizeList), dexSizeList.size(), dexRecordPairMin, dexRecordPairMax);
        return this.fileSizeStatistics;
    }

    private void setValues(Type type, double[] array, Integer size, RecordPair minimum, RecordPair maximum) {
        if (this.fileSizeStatistics == null) {
            throw new NullPointerException("fileSizeStatistics");
        }
        logger.info("Started processing " + type.toString());
        Double mean = StatUtils.mean(array);
        Double median = StatUtils.percentile(array, 50.0);
        Double variance = StatUtils.variance(array);
        Double deviation = Math.sqrt(variance);
        MathStatistics mathStatistics = new MathStatistics(new PercentagePair((Number)size, this.jsons.size()), mean, median, null, maximum, minimum, variance, deviation);
        switch (type) {
            case ARSC_SIZE: {
                this.fileSizeStatistics.setArscSize(mathStatistics);
                break;
            }
            case DEX_SIZE: {
                this.fileSizeStatistics.setDexSize(mathStatistics);
                break;
            }
            case FILE_SIZE: {
                this.fileSizeStatistics.setFileSize(mathStatistics);
            }
        }
        logger.info("Finished processing " + type.toString());
    }

    private Double getValue(Type type, ApkData data) {
        Long value = null;
        switch (type) {
            case ARSC_SIZE: {
                value = data.getArscSize();
                break;
            }
            case DEX_SIZE: {
                value = data.getDexSize();
                break;
            }
            case FILE_SIZE: {
                value = data.getFileSize();
            }
        }
        return value == null || value == 0L ? null : Double.valueOf(value.doubleValue());
    }

    private static enum Type {
        FILE_SIZE,
        DEX_SIZE,
        ARSC_SIZE;

    }
}

