/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.AndroidManifestData;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.statistics.data.FeaturesStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopListProcessorBase;
import sk.styk.martin.bakalarka.utils.data.MathStatistics;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class FeaturesStatisticsProcessor
extends TopListProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(FeaturesStatisticsProcessor.class);
    private List<File> jsons;
    private FeaturesStatistics featuresStatistics;

    public FeaturesStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static FeaturesStatisticsProcessor ofFiles(List<File> jsons) {
        return new FeaturesStatisticsProcessor(jsons);
    }

    public FeaturesStatistics process() {
        this.featuresStatistics = new FeaturesStatistics();
        HashMap<String, Integer> topFeatures = new HashMap<String, Integer>();
        ArrayList<Double> featuresNumbersList = new ArrayList<Double>();
        ArrayList<Double> featuresNumbersListNonZero = new ArrayList<Double>();
        this.requestMaxValues("features");
        RecordPair<Number, String> recordPair = null;
        int manifestFound = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            File f = this.jsons.get(i);
            ApkData data = JsonUtils.fromJson(f);
            AndroidManifestData manifestData = null;
            if (data == null || data.getAndroidManifest() == null) continue;
            ++manifestFound;
            manifestData = data.getAndroidManifest();
            List<String> featuresList = manifestData.getUsesFeature();
            if (featuresList == null) continue;
            int listSize = featuresList.size();
            featuresNumbersList.add(new Double(listSize));
            if (listSize != 0) {
                featuresNumbersListNonZero.add(new Double(listSize));
            }
            recordPair = this.processMaxExtreme("features", (Integer)listSize, data.getFileName());
            for (String perm : featuresList) {
                String permLower = perm.toLowerCase();
                if (topFeatures.containsKey(permLower)) {
                    Integer oldValue = (Integer)topFeatures.get(permLower);
                    oldValue = oldValue + 1;
                    topFeatures.put(permLower, oldValue);
                    continue;
                }
                topFeatures.put(permLower, 1);
            }
        }
        this.featuresStatistics.setAnalyzedApks(manifestFound);
        this.setValues(manifestFound, featuresNumbersList, false, recordPair);
        this.setValues(manifestFound, featuresNumbersListNonZero, true, recordPair);
        this.featuresStatistics.setTopFeatures(this.getTopValuesMapInteger(topFeatures, featuresNumbersList.size(), "features"));
        return this.featuresStatistics;
    }

    private void setValues(int manifestFound, List<Double> featuresNumbersList, boolean isNonZero, RecordPair maxRecordPair) {
        if (featuresNumbersList == null) {
            throw new NullPointerException("featuresNumbersList null");
        }
        logger.info("Started processing features");
        MathStatistics mathStatistics = new MathStatistics(new PercentagePair((Number)featuresNumbersList.size(), manifestFound), featuresNumbersList, null, maxRecordPair);
        if (isNonZero) {
            this.featuresStatistics.setFeaturesNonZero(mathStatistics);
        } else {
            this.featuresStatistics.setFeatures(mathStatistics);
        }
        logger.info("Finished processing features");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

