/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.analyze.data.ResourceData;
import sk.styk.martin.bakalarka.statistics.data.DrawableStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopValueProcessorBase;
import sk.styk.martin.bakalarka.utils.data.MathStatistics;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class DrawableStatisticsProcessors
extends TopValueProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(DrawableStatisticsProcessors.class);
    private List<File> jsons;
    private DrawableStatistics drawableStatistics;
    private ResourceData resourceData;

    public DrawableStatisticsProcessors(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static DrawableStatisticsProcessors ofFiles(List<File> jsons) {
        return new DrawableStatisticsProcessors(jsons);
    }

    public DrawableStatistics process() {
        this.drawableStatistics = new DrawableStatistics();
        ArrayList<Double> pngList = new ArrayList<Double>();
        ArrayList<Double> pngListNonZero = new ArrayList<Double>();
        ArrayList<Double> jpgList = new ArrayList<Double>();
        ArrayList<Double> jpgListNonZero = new ArrayList<Double>();
        ArrayList<Double> gifList = new ArrayList<Double>();
        ArrayList<Double> gifListNonZero = new ArrayList<Double>();
        ArrayList<Double> xmlList = new ArrayList<Double>();
        ArrayList<Double> xmlListNonZero = new ArrayList<Double>();
        ArrayList<Double> ninePatchList = new ArrayList<Double>();
        ArrayList<Double> ninePatchListNonZero = new ArrayList<Double>();
        ArrayList<Double> differentDrawablesList = new ArrayList<Double>();
        ArrayList<Double> differentDrawablesListNonZero = new ArrayList<Double>();
        ArrayList<Double> ldpiList = new ArrayList<Double>();
        ArrayList<Double> ldpiListNonZero = new ArrayList<Double>();
        ArrayList<Double> mdpiList = new ArrayList<Double>();
        ArrayList<Double> mdpiListNonZero = new ArrayList<Double>();
        ArrayList<Double> hdpiList = new ArrayList<Double>();
        ArrayList<Double> hpdiListNonZero = new ArrayList<Double>();
        ArrayList<Double> xhdpiList = new ArrayList<Double>();
        ArrayList<Double> xhpdiListNonZero = new ArrayList<Double>();
        ArrayList<Double> xxhdpiList = new ArrayList<Double>();
        ArrayList<Double> xxhpdiListNonZero = new ArrayList<Double>();
        ArrayList<Double> xxxhdpiList = new ArrayList<Double>();
        ArrayList<Double> xxxhpdiListNonZero = new ArrayList<Double>();
        ArrayList<Double> unspecifiedDpiList = new ArrayList<Double>();
        ArrayList<Double> unspecifiedDpiListNonZero = new ArrayList<Double>();
        ArrayList<Double> nodpiList = new ArrayList<Double>();
        ArrayList<Double> nodpiListNonZero = new ArrayList<Double>();
        ArrayList<Double> tvdpiList = new ArrayList<Double>();
        ArrayList<Double> tvdpiListNonZero = new ArrayList<Double>();
        this.requestMaxValues(Type.PNG);
        this.requestMaxValues(Type.JPG);
        this.requestMaxValues(Type.GIF);
        this.requestMaxValues(Type.XML);
        this.requestMaxValues(Type.NINE_PATCH);
        this.requestMaxValues(Type.DIFFERENT_DRAWABLES);
        this.requestMaxValues(Type.LDPI);
        this.requestMaxValues(Type.MDPI);
        this.requestMaxValues(Type.HDPI);
        this.requestMaxValues(Type.XHDPI);
        this.requestMaxValues(Type.XXHDPI);
        this.requestMaxValues(Type.XXXHDPI);
        this.requestMaxValues(Type.UNSPECIFIED_DPI);
        this.requestMaxValues(Type.TVDPI);
        this.requestMaxValues(Type.NODPI);
        RecordPair<Number, String> pngRecordPair = null;
        RecordPair<Number, String> jpgRecordPair = null;
        RecordPair<Number, String> gifRecordPair = null;
        RecordPair<Number, String> xmlRecordPair = null;
        RecordPair<Number, String> ninePatchRecordPair = null;
        RecordPair<Number, String> differentDrawablesRecordPair = null;
        RecordPair<Number, String> ldpiRecordPair = null;
        RecordPair<Number, String> mdpiRecordPair = null;
        RecordPair<Number, String> hdpiRecordPair = null;
        RecordPair<Number, String> xhdpiRecordPair = null;
        RecordPair<Number, String> xxhdpiRecordPair = null;
        RecordPair<Number, String> xxxhdpiRecordPair = null;
        RecordPair<Number, String> unspecifiedDpiRecordPair = null;
        RecordPair<Number, String> tvdpiRecordPair = null;
        RecordPair<Number, String> nodpiRecordPair = null;
        int resourceDataFound = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            File f;
            ApkData data;
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            if ((data = JsonUtils.fromJson(f = this.jsons.get(i))) == null || data.getResourceData() == null) continue;
            ++resourceDataFound;
            this.resourceData = data.getResourceData();
            this.obtainValue(this.resourceData.getPngDrawables(), pngList, pngListNonZero);
            pngRecordPair = this.processMaxExtreme((Enum)Type.PNG, this.resourceData.getPngDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getJpgDrawables(), jpgList, jpgListNonZero);
            jpgRecordPair = this.processMaxExtreme((Enum)Type.JPG, this.resourceData.getJpgDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getGifDrawables(), gifList, gifListNonZero);
            gifRecordPair = this.processMaxExtreme((Enum)Type.GIF, this.resourceData.getGifDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getXmlDrawables(), xmlList, xmlListNonZero);
            xmlRecordPair = this.processMaxExtreme((Enum)Type.XML, this.resourceData.getXmlDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getNinePatchDrawables(), ninePatchList, ninePatchListNonZero);
            ninePatchRecordPair = this.processMaxExtreme((Enum)Type.NINE_PATCH, this.resourceData.getNinePatchDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getDifferentDrawables(), differentDrawablesList, differentDrawablesListNonZero);
            differentDrawablesRecordPair = this.processMaxExtreme((Enum)Type.DIFFERENT_DRAWABLES, this.resourceData.getDifferentDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getLdpiDrawables(), ldpiList, ldpiListNonZero);
            ldpiRecordPair = this.processMaxExtreme((Enum)Type.LDPI, this.resourceData.getLdpiDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getMdpiDrawables(), mdpiList, mdpiListNonZero);
            mdpiRecordPair = this.processMaxExtreme((Enum)Type.MDPI, this.resourceData.getMdpiDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getHdpiDrawables(), hdpiList, hpdiListNonZero);
            hdpiRecordPair = this.processMaxExtreme((Enum)Type.HDPI, this.resourceData.getHdpiDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getXhdpiDrawables(), xhdpiList, xhpdiListNonZero);
            xhdpiRecordPair = this.processMaxExtreme((Enum)Type.XHDPI, this.resourceData.getXhdpiDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getXxhdpiDrawables(), xxhdpiList, xxhpdiListNonZero);
            xxhdpiRecordPair = this.processMaxExtreme((Enum)Type.XXHDPI, this.resourceData.getXxhdpiDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getXxxhdpiDrawables(), xxxhdpiList, xxxhpdiListNonZero);
            xxxhdpiRecordPair = this.processMaxExtreme((Enum)Type.XXXHDPI, this.resourceData.getXxxhdpiDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getUnspecifiedDpiDrawables(), unspecifiedDpiList, unspecifiedDpiListNonZero);
            unspecifiedDpiRecordPair = this.processMaxExtreme((Enum)Type.UNSPECIFIED_DPI, this.resourceData.getUnspecifiedDpiDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getNodpiDrawables(), nodpiList, nodpiListNonZero);
            nodpiRecordPair = this.processMaxExtreme((Enum)Type.NODPI, this.resourceData.getNodpiDrawables(), data.getFileName());
            this.obtainValue(this.resourceData.getTvdpiDrawables(), tvdpiList, tvdpiListNonZero);
            tvdpiRecordPair = this.processMaxExtreme((Enum)Type.TVDPI, this.resourceData.getTvdpiDrawables(), data.getFileName());
        }
        this.drawableStatistics.setAnalyzedApks(resourceDataFound);
        this.setValues(Type.PNG, pngList, resourceDataFound, pngRecordPair);
        this.setValues(Type.PNG_NONZERO, pngListNonZero, resourceDataFound, pngRecordPair);
        this.setValues(Type.JPG, jpgList, resourceDataFound, jpgRecordPair);
        this.setValues(Type.JPG_NONZERO, jpgListNonZero, resourceDataFound, jpgRecordPair);
        this.setValues(Type.GIF, gifList, resourceDataFound, gifRecordPair);
        this.setValues(Type.GIF_NONZERO, gifListNonZero, resourceDataFound, gifRecordPair);
        this.setValues(Type.XML, xmlList, resourceDataFound, xmlRecordPair);
        this.setValues(Type.XML_NONZERO, xmlListNonZero, resourceDataFound, xmlRecordPair);
        this.setValues(Type.NINE_PATCH, ninePatchList, resourceDataFound, ninePatchRecordPair);
        this.setValues(Type.NINE_PATCH_NONZERO, ninePatchListNonZero, resourceDataFound, ninePatchRecordPair);
        this.setValues(Type.DIFFERENT_DRAWABLES, differentDrawablesList, resourceDataFound, differentDrawablesRecordPair);
        this.setValues(Type.DIFFERENT_DRAWABLES_NONZERO, differentDrawablesListNonZero, resourceDataFound, differentDrawablesRecordPair);
        this.setValues(Type.LDPI, ldpiList, resourceDataFound, ldpiRecordPair);
        this.setValues(Type.LDPI_NONZERO, ldpiListNonZero, resourceDataFound, ldpiRecordPair);
        this.setValues(Type.MDPI, mdpiList, resourceDataFound, mdpiRecordPair);
        this.setValues(Type.MDPI_NONZERO, mdpiListNonZero, resourceDataFound, mdpiRecordPair);
        this.setValues(Type.HDPI, hdpiList, resourceDataFound, hdpiRecordPair);
        this.setValues(Type.HDPI_NONZERO, hpdiListNonZero, resourceDataFound, hdpiRecordPair);
        this.setValues(Type.XHDPI, xhdpiList, resourceDataFound, xhdpiRecordPair);
        this.setValues(Type.XHDPI_NONZERO, xhpdiListNonZero, resourceDataFound, xhdpiRecordPair);
        this.setValues(Type.XXHDPI, xxhdpiList, resourceDataFound, xxhdpiRecordPair);
        this.setValues(Type.XXHDPI_NONZERO, xxhpdiListNonZero, resourceDataFound, xxhdpiRecordPair);
        this.setValues(Type.XXXHDPI, xxxhdpiList, resourceDataFound, xxxhdpiRecordPair);
        this.setValues(Type.XXXHDPI_NONZERO, xxxhpdiListNonZero, resourceDataFound, xxxhdpiRecordPair);
        this.setValues(Type.UNSPECIFIED_DPI, unspecifiedDpiList, resourceDataFound, unspecifiedDpiRecordPair);
        this.setValues(Type.UNSPECIFIED_DPI_NONZERO, unspecifiedDpiListNonZero, resourceDataFound, unspecifiedDpiRecordPair);
        this.setValues(Type.TVDPI, tvdpiList, resourceDataFound, tvdpiRecordPair);
        this.setValues(Type.TVDPI_NONZERO, tvdpiListNonZero, resourceDataFound, tvdpiRecordPair);
        this.setValues(Type.NODPI, nodpiList, resourceDataFound, nodpiRecordPair);
        this.setValues(Type.NODPI_NONZERO, nodpiListNonZero, resourceDataFound, nodpiRecordPair);
        return this.drawableStatistics;
    }

    private void setValues(Type type, List<Double> list, int resourceDataFound, RecordPair maxRecordPair) {
        if (this.drawableStatistics == null) {
            throw new NullPointerException("drawableStatistics null");
        }
        logger.info("Started processing drawables " + type.toString());
        MathStatistics mathStatistics = new MathStatistics(new PercentagePair((Number)list.size(), resourceDataFound), list, null, maxRecordPair);
        switch (type) {
            case PNG: {
                this.drawableStatistics.setPngDrawables(mathStatistics);
                break;
            }
            case PNG_NONZERO: {
                this.drawableStatistics.setPngDrawablesNonZero(mathStatistics);
                break;
            }
            case JPG: {
                this.drawableStatistics.setJpgDrawables(mathStatistics);
                break;
            }
            case JPG_NONZERO: {
                this.drawableStatistics.setJpgDrawablesNonZero(mathStatistics);
                break;
            }
            case GIF: {
                this.drawableStatistics.setGifDrawables(mathStatistics);
                break;
            }
            case GIF_NONZERO: {
                this.drawableStatistics.setGifDrawablesNonZero(mathStatistics);
                break;
            }
            case XML: {
                this.drawableStatistics.setXmlDrawables(mathStatistics);
                break;
            }
            case XML_NONZERO: {
                this.drawableStatistics.setXmlDrawablesNonZero(mathStatistics);
                break;
            }
            case NINE_PATCH: {
                this.drawableStatistics.setNinePatchDrawables(mathStatistics);
                break;
            }
            case NINE_PATCH_NONZERO: {
                this.drawableStatistics.setNinePatchDrawablesNonZero(mathStatistics);
                break;
            }
            case DIFFERENT_DRAWABLES: {
                this.drawableStatistics.setDifferentDrawables(mathStatistics);
                break;
            }
            case DIFFERENT_DRAWABLES_NONZERO: {
                this.drawableStatistics.setDifferentDrawablesNonZero(mathStatistics);
                break;
            }
            case LDPI: {
                this.drawableStatistics.setLdpiDrawables(mathStatistics);
                break;
            }
            case LDPI_NONZERO: {
                this.drawableStatistics.setLdpiDrawablesNonZero(mathStatistics);
                break;
            }
            case MDPI: {
                this.drawableStatistics.setMdpiDrawables(mathStatistics);
                break;
            }
            case MDPI_NONZERO: {
                this.drawableStatistics.setMdpiDrawablesNonZero(mathStatistics);
                break;
            }
            case HDPI: {
                this.drawableStatistics.setHdpiDrawables(mathStatistics);
                break;
            }
            case HDPI_NONZERO: {
                this.drawableStatistics.setHdpiDrawablesNonZero(mathStatistics);
                break;
            }
            case XHDPI: {
                this.drawableStatistics.setXhdpiDrawables(mathStatistics);
                break;
            }
            case XHDPI_NONZERO: {
                this.drawableStatistics.setXhdpiDrawablesNonZero(mathStatistics);
                break;
            }
            case XXHDPI: {
                this.drawableStatistics.setXxhdpiDrawables(mathStatistics);
                break;
            }
            case XXHDPI_NONZERO: {
                this.drawableStatistics.setXxhdpiDrawablesNonZero(mathStatistics);
                break;
            }
            case XXXHDPI: {
                this.drawableStatistics.setXxxhdpiDrawables(mathStatistics);
                break;
            }
            case XXXHDPI_NONZERO: {
                this.drawableStatistics.setXxxhdpiDrawablesNonZero(mathStatistics);
                break;
            }
            case UNSPECIFIED_DPI: {
                this.drawableStatistics.setUnspecifiedDpiDrawables(mathStatistics);
                break;
            }
            case UNSPECIFIED_DPI_NONZERO: {
                this.drawableStatistics.setUnspecifiedDpiDrawablesNonZero(mathStatistics);
                break;
            }
            case TVDPI: {
                this.drawableStatistics.setTvdpiDrawables(mathStatistics);
                break;
            }
            case TVDPI_NONZERO: {
                this.drawableStatistics.setTvdpiDrawablesNonZero(mathStatistics);
                break;
            }
            case NODPI: {
                this.drawableStatistics.setNodpiDrawables(mathStatistics);
                break;
            }
            case NODPI_NONZERO: {
                this.drawableStatistics.setNodpiDrawablesNonZero(mathStatistics);
            }
        }
        logger.info("Finished processing drawables " + type.toString());
    }

    private void obtainValue(Integer value, List<Double> list, List<Double> listNonZero) {
        if (value != null) {
            list.add(new Double(value.intValue()));
            if (value != 0) {
                listNonZero.add(new Double(value.intValue()));
            }
        }
    }

    private static enum Type {
        PNG,
        PNG_NONZERO,
        JPG,
        JPG_NONZERO,
        GIF,
        GIF_NONZERO,
        XML,
        XML_NONZERO,
        NINE_PATCH,
        NINE_PATCH_NONZERO,
        DIFFERENT_DRAWABLES,
        DIFFERENT_DRAWABLES_NONZERO,
        LDPI,
        LDPI_NONZERO,
        MDPI,
        MDPI_NONZERO,
        HDPI,
        HDPI_NONZERO,
        XHDPI,
        XHDPI_NONZERO,
        XXHDPI,
        XXHDPI_NONZERO,
        XXXHDPI,
        XXXHDPI_NONZERO,
        UNSPECIFIED_DPI,
        UNSPECIFIED_DPI_NONZERO,
        TVDPI,
        TVDPI_NONZERO,
        NODPI,
        NODPI_NONZERO;

    }
}

