/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.AndroidManifestData;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.statistics.data.DefinedPermissionsStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopListProcessorBase;
import sk.styk.martin.bakalarka.utils.data.MathStatistics;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class DefinedPermissionsStatisticsProcessor
extends TopListProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(DefinedPermissionsStatisticsProcessor.class);
    private List<File> jsons;
    private DefinedPermissionsStatistics permissionsStatistics;

    public DefinedPermissionsStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static DefinedPermissionsStatisticsProcessor ofFiles(List<File> jsons) {
        return new DefinedPermissionsStatisticsProcessor(jsons);
    }

    public DefinedPermissionsStatistics process() {
        this.permissionsStatistics = new DefinedPermissionsStatistics();
        HashMap<String, Integer> topProtectionLevel = new HashMap<String, Integer>();
        ArrayList<Double> permissionsNumbersList = new ArrayList<Double>();
        ArrayList<Double> permissionsNumbersListNonZero = new ArrayList<Double>();
        this.requestMaxValues("perms");
        RecordPair<Number, String> permsRecordPair = null;
        int manifestFound = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            File f = this.jsons.get(i);
            ApkData data = JsonUtils.fromJson(f);
            AndroidManifestData manifestData = null;
            if (data == null || data.getAndroidManifest() == null) continue;
            ++manifestFound;
            manifestData = data.getAndroidManifest();
            List<String> permissionsList = manifestData.getPermissions();
            List<String> protectonLevelList = manifestData.getPermissionsProtectionLevel();
            if (permissionsList == null) continue;
            Integer listSize = permissionsList.size();
            permissionsNumbersList.add(new Double(listSize.intValue()));
            if (listSize != 0) {
                permissionsNumbersListNonZero.add(new Double(listSize.intValue()));
            }
            permsRecordPair = this.processMaxExtreme("perms", (Long)listSize.longValue(), data.getFileName());
            for (String perm : protectonLevelList) {
                String permLower = perm.toLowerCase();
                if (topProtectionLevel.containsKey(permLower)) {
                    Integer oldValue = (Integer)topProtectionLevel.get(permLower);
                    oldValue = oldValue + 1;
                    topProtectionLevel.put(permLower, oldValue);
                    continue;
                }
                topProtectionLevel.put(permLower, 1);
            }
        }
        this.permissionsStatistics.setAnalyzedApks(manifestFound);
        this.setValues(manifestFound, permissionsNumbersList, false, permsRecordPair);
        this.setValues(manifestFound, permissionsNumbersListNonZero, true, permsRecordPair);
        this.permissionsStatistics.setTopProtectionLevel(this.getTopValuesMapInteger(topProtectionLevel, permissionsNumbersList.size(), "permissions protection level"));
        return this.permissionsStatistics;
    }

    private void setValues(int manifestFound, List<Double> permissionsNumbersList, boolean isNonZero, RecordPair recordPairMax) {
        if (permissionsNumbersList == null) {
            throw new NullPointerException("permissionsNumbersList null");
        }
        logger.info("Started processing permissions");
        MathStatistics mathStatistics = new MathStatistics(new PercentagePair((Number)permissionsNumbersList.size(), manifestFound), permissionsNumbersList, null, recordPairMax);
        if (isNonZero) {
            this.permissionsStatistics.setPermissionsNonZero(mathStatistics);
        } else {
            this.permissionsStatistics.setPermissions(mathStatistics);
        }
        logger.info("Finished processing permissions");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

