/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.analyze.data.CertificateData;
import sk.styk.martin.bakalarka.statistics.data.CertificateStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopListProcessorBase;
import sk.styk.martin.bakalarka.statistics.processors.helpers.PercentageHelper;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class CertificateStatisticsProcessor
extends TopListProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(CertificateStatisticsProcessor.class);
    private List<File> jsons;
    private CertificateStatistics certificateStatistics;

    public CertificateStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static CertificateStatisticsProcessor ofFiles(List<File> jsons) {
        return new CertificateStatisticsProcessor(jsons);
    }

    public CertificateStatistics process() {
        this.certificateStatistics = new CertificateStatistics();
        HashMap<Integer, PercentagePair> numberMap = new HashMap<Integer, PercentagePair>();
        HashMap<Integer, PercentagePair> versionMap = new HashMap<Integer, PercentagePair>();
        HashMap<String, PercentagePair> algorithmMap = new HashMap<String, PercentagePair>();
        int certificateFound = 0;
        int appsWithCertificateObtained = 0;
        int versionsObtained = 0;
        int algorithmObtained = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            File f = this.jsons.get(i);
            ApkData data = JsonUtils.fromJson(f);
            List<CertificateData> certificateData = null;
            if (data == null || data.getCertificateDatas() == null || (certificateData = data.getCertificateDatas()).size() <= 0) continue;
            ++appsWithCertificateObtained;
            Integer num = certificateData.size();
            if (numberMap.containsKey(num)) {
                PercentagePair percentagePair = (PercentagePair)numberMap.get(num);
                Integer oldValue = percentagePair.getCount().intValue();
                oldValue = oldValue + 1;
                percentagePair.setCount(oldValue);
            } else {
                numberMap.put(num, new PercentagePair((Number)1, null));
            }
            for (CertificateData cData : certificateData) {
                String algorithm;
                ++certificateFound;
                Integer version = cData.getVersion();
                if (version != null) {
                    ++versionsObtained;
                    if (versionMap.containsKey(version)) {
                        PercentagePair percentagePair = (PercentagePair)versionMap.get(version);
                        Integer oldValue = percentagePair.getCount().intValue();
                        oldValue = oldValue + 1;
                        percentagePair.setCount(oldValue);
                    } else {
                        versionMap.put(version, new PercentagePair((Number)1, null));
                    }
                }
                if ((algorithm = cData.getSignAlgorithm()) == null || algorithm.isEmpty()) continue;
                ++algorithmObtained;
                if (algorithmMap.containsKey(algorithm)) {
                    PercentagePair percentagePair = (PercentagePair)algorithmMap.get(algorithm);
                    Integer oldValue = percentagePair.getCount().intValue();
                    oldValue = oldValue + 1;
                    percentagePair.setCount(oldValue);
                    continue;
                }
                algorithmMap.put(algorithm, new PercentagePair((Number)1, null));
            }
        }
        this.certificateStatistics.setAnalyzedApks(appsWithCertificateObtained);
        this.certificateStatistics.setSignAlgorithmObtained(new PercentagePair((Number)algorithmObtained, PercentageHelper.getPercentage(algorithmObtained, certificateFound)));
        this.certificateStatistics.setVersionObtained(new PercentagePair((Number)versionsObtained, PercentageHelper.getPercentage(versionsObtained, certificateFound)));
        this.certificateStatistics.setNumberOfCertificates(this.getTopValuesMap(numberMap, appsWithCertificateObtained, Type.NUMBER.toString()));
        this.certificateStatistics.setVersionMap(this.getTopValuesMap(versionMap, certificateFound, Type.VERSION.toString()));
        this.certificateStatistics.setSignAlgorithmMap(this.getTopValuesMap(algorithmMap, certificateFound, Type.ALGORITHM.toString()));
        return this.certificateStatistics;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    private static enum Type {
        VERSION,
        ALGORITHM,
        NUMBER;

    }
}

