/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.statistics.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.AndroidManifestData;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.statistics.data.AppComponentsStatistics;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.statistics.processors.TopValueProcessorBase;
import sk.styk.martin.bakalarka.statistics.processors.helpers.ConversionHelper;
import sk.styk.martin.bakalarka.utils.data.MathStatistics;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;
import sk.styk.martin.bakalarka.utils.data.RecordPair;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class AppComponentsStatisticsProcessor
extends TopValueProcessorBase {
    private static final Logger logger = LoggerFactory.getLogger(AppComponentsStatisticsProcessor.class);
    private List<File> jsons;
    private AppComponentsStatistics appComponentsStatistics;

    public AppComponentsStatisticsProcessor(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons");
        }
        this.jsons = jsons;
    }

    public static AppComponentsStatisticsProcessor ofFiles(List<File> jsons) {
        return new AppComponentsStatisticsProcessor(jsons);
    }

    public AppComponentsStatistics process() {
        this.appComponentsStatistics = new AppComponentsStatistics();
        ArrayList<Double> activityList = new ArrayList<Double>();
        ArrayList<Double> serviceList = new ArrayList<Double>();
        ArrayList<Double> receiverList = new ArrayList<Double>();
        ArrayList<Double> providerList = new ArrayList<Double>();
        ArrayList<Double> activityListNonZero = new ArrayList<Double>();
        ArrayList<Double> serviceListNonZero = new ArrayList<Double>();
        ArrayList<Double> receiverListNonZero = new ArrayList<Double>();
        ArrayList<Double> providerListNonZero = new ArrayList<Double>();
        this.requestMaxValues(Type.ACTIVITY);
        this.requestMaxValues(Type.BROADCAST_RECEIVER);
        this.requestMaxValues(Type.CONTENT_PROVIDER);
        this.requestMaxValues(Type.SERVICE);
        RecordPair<Number, String> activityRecordPair = null;
        RecordPair<Number, String> receiverRecordPair = null;
        RecordPair<Number, String> providerRecordPair = null;
        RecordPair<Number, String> serviceRecordPair = null;
        int manifestFound = 0;
        for (int i = 0; i < this.jsons.size(); ++i) {
            Double receiverValue;
            Double providerValue;
            Double serviceValue;
            if (i % StatisticsProcessor.PRINT_MESSAGE_INTERVAL == 0) {
                logger.info("Loading json number " + i);
            }
            File f = this.jsons.get(i);
            logger.trace("Processing " + f.getName());
            ApkData data = JsonUtils.fromJson(f);
            AndroidManifestData manifestData = null;
            if (data == null || data.getAndroidManifest() == null) continue;
            manifestData = data.getAndroidManifest();
            ++manifestFound;
            Double activityValue = this.getValue(Type.ACTIVITY, manifestData);
            if (activityValue != null) {
                activityList.add(activityValue);
                if (activityValue != 0.0) {
                    activityListNonZero.add(activityValue);
                }
                activityRecordPair = this.processMaxExtreme((Enum)Type.ACTIVITY, (Long)activityValue.longValue(), data.getFileName());
            }
            if ((serviceValue = this.getValue(Type.SERVICE, manifestData)) != null) {
                serviceList.add(serviceValue);
                if (serviceValue != 0.0) {
                    serviceListNonZero.add(serviceValue);
                }
                serviceRecordPair = this.processMaxExtreme((Enum)Type.SERVICE, (Long)serviceValue.longValue(), data.getFileName());
            }
            if ((providerValue = this.getValue(Type.CONTENT_PROVIDER, manifestData)) != null) {
                providerList.add(providerValue);
                if (providerValue != 0.0) {
                    providerListNonZero.add(providerValue);
                }
                providerRecordPair = this.processMaxExtreme((Enum)Type.CONTENT_PROVIDER, (Long)providerValue.longValue(), data.getFileName());
            }
            if ((receiverValue = this.getValue(Type.BROADCAST_RECEIVER, manifestData)) == null) continue;
            receiverList.add(receiverValue);
            if (receiverValue != 0.0) {
                receiverListNonZero.add(receiverValue);
            }
            receiverRecordPair = this.processMaxExtreme((Enum)Type.BROADCAST_RECEIVER, (Long)receiverValue.longValue(), data.getFileName());
        }
        this.appComponentsStatistics.setAnalyzedApks(manifestFound);
        this.setValues(Type.ACTIVITY, ConversionHelper.toDoubleArray(activityList), new PercentagePair((Number)activityList.size(), manifestFound), activityRecordPair);
        this.setValues(Type.SERVICE, ConversionHelper.toDoubleArray(serviceList), new PercentagePair((Number)serviceList.size(), manifestFound), serviceRecordPair);
        this.setValues(Type.CONTENT_PROVIDER, ConversionHelper.toDoubleArray(providerList), new PercentagePair((Number)providerList.size(), manifestFound), providerRecordPair);
        this.setValues(Type.BROADCAST_RECEIVER, ConversionHelper.toDoubleArray(receiverList), new PercentagePair((Number)receiverList.size(), manifestFound), receiverRecordPair);
        this.setValues(Type.ACTIVITY_NONZERO, ConversionHelper.toDoubleArray(activityListNonZero), new PercentagePair((Number)activityListNonZero.size(), manifestFound), activityRecordPair);
        this.setValues(Type.SERVICE_NONZERO, ConversionHelper.toDoubleArray(serviceListNonZero), new PercentagePair((Number)serviceListNonZero.size(), manifestFound), serviceRecordPair);
        this.setValues(Type.CONTENT_PROVIDER_NONZERO, ConversionHelper.toDoubleArray(providerListNonZero), new PercentagePair((Number)providerListNonZero.size(), manifestFound), providerRecordPair);
        this.setValues(Type.BROADCAST_RECEIVER_NONZERO, ConversionHelper.toDoubleArray(receiverListNonZero), new PercentagePair((Number)receiverListNonZero.size(), manifestFound), receiverRecordPair);
        return this.appComponentsStatistics;
    }

    private void setValues(Type type, double[] array, PercentagePair size, RecordPair maxValue) {
        if (this.appComponentsStatistics == null) {
            throw new NullPointerException("appComponentsStatistics");
        }
        logger.info("Started processing " + type.toString());
        MathStatistics mathStatistics = new MathStatistics(size, array, null, maxValue);
        switch (type) {
            case ACTIVITY: {
                this.appComponentsStatistics.setActivities(mathStatistics);
                break;
            }
            case SERVICE: {
                this.appComponentsStatistics.setServices(mathStatistics);
                break;
            }
            case BROADCAST_RECEIVER: {
                this.appComponentsStatistics.setBroadcastReceivers(mathStatistics);
                break;
            }
            case CONTENT_PROVIDER: {
                this.appComponentsStatistics.setContentProviders(mathStatistics);
                break;
            }
            case ACTIVITY_NONZERO: {
                this.appComponentsStatistics.setActivitiesNonZero(mathStatistics);
                break;
            }
            case SERVICE_NONZERO: {
                this.appComponentsStatistics.setServicesNonZero(mathStatistics);
                break;
            }
            case BROADCAST_RECEIVER_NONZERO: {
                this.appComponentsStatistics.setBroadcastReceiversNonZero(mathStatistics);
                break;
            }
            case CONTENT_PROVIDER_NONZERO: {
                this.appComponentsStatistics.setContentProvidersNonZero(mathStatistics);
            }
        }
        logger.info("Finished processing " + type.toString());
    }

    private Double getValue(Type type, AndroidManifestData data) {
        Integer value = null;
        switch (type) {
            case ACTIVITY: {
                value = data.getNumberOfActivities();
                break;
            }
            case SERVICE: {
                value = data.getNumberOfServices();
                break;
            }
            case BROADCAST_RECEIVER: {
                value = data.getNumberOfBroadcastReceivers();
                break;
            }
            case CONTENT_PROVIDER: {
                value = data.getNumberOfContentProviders();
            }
        }
        return value == null ? null : Double.valueOf(value.doubleValue());
    }

    private static enum Type {
        ACTIVITY,
        SERVICE,
        BROADCAST_RECEIVER,
        CONTENT_PROVIDER,
        ACTIVITY_NONZERO,
        SERVICE_NONZERO,
        BROADCAST_RECEIVER_NONZERO,
        CONTENT_PROVIDER_NONZERO;

    }
}

