/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.execute.tasks;

import java.io.File;
import java.util.List;
import sk.styk.martin.bakalarka.execute.tasks.Task;
import sk.styk.martin.bakalarka.statistics.processors.StatisticsProcessor;
import sk.styk.martin.bakalarka.utils.files.FileFinder;

public class StatisticsTask
implements Task {
    private String inputDirectory;
    private String outDirectory;

    @Override
    public Task setInputDirectory(String inputDirectory) {
        if (inputDirectory == null || inputDirectory.isEmpty()) {
            throw new IllegalArgumentException("input");
        }
        this.inputDirectory = inputDirectory;
        return this;
    }

    @Override
    public Task setOutputDirectory(String outDirectory) {
        if (outDirectory == null || outDirectory.isEmpty()) {
            throw new IllegalArgumentException("outDirectory");
        }
        this.outDirectory = outDirectory;
        return this;
    }

    @Override
    public void execute() {
        FileFinder ff = new FileFinder(new File(this.inputDirectory));
        List<File> jsons = ff.getJsonFilesInDirectories();
        StatisticsProcessor statisticsProcessor = new StatisticsProcessor(jsons);
        statisticsProcessor.setOutputFile(new File(this.outDirectory));
        statisticsProcessor.processFiles();
    }
}

