/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.execute.tasks;

import java.io.File;
import java.util.List;
import sk.styk.martin.bakalarka.analyze.processors.ApkProcessor;
import sk.styk.martin.bakalarka.execute.tasks.Task;
import sk.styk.martin.bakalarka.utils.files.ApkFile;
import sk.styk.martin.bakalarka.utils.files.FileFinder;

public class AnalyzeTask
implements Task {
    private String inputDirectory;
    private String outDirectory;

    @Override
    public Task setInputDirectory(String inputDirectory) {
        if (inputDirectory == null || inputDirectory.isEmpty()) {
            throw new IllegalArgumentException("input");
        }
        this.inputDirectory = inputDirectory;
        return this;
    }

    @Override
    public Task setOutputDirectory(String outDirectory) {
        if (outDirectory == null || outDirectory.isEmpty()) {
            throw new IllegalArgumentException("outDirectory");
        }
        this.outDirectory = outDirectory;
        return this;
    }

    @Override
    public void execute() {
        ApkProcessor analyzer;
        File analyzedFile = new File(this.inputDirectory);
        if (analyzedFile.isDirectory()) {
            FileFinder ff = new FileFinder(new File(this.inputDirectory));
            List<ApkFile> apks = ff.getApkFilesInDirectories();
            analyzer = new ApkProcessor(apks);
        } else {
            ApkFile apk = new ApkFile(analyzedFile);
            analyzer = new ApkProcessor(apk);
        }
        File outputDirectory = new File(this.outDirectory);
        analyzer.processFiles(outputDirectory);
    }
}

