/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.execute.arguments;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.execute.arguments.Arguments;
import sk.styk.martin.bakalarka.execute.arguments.TaskMode;

public class ArgumentsFactory {
    private static final Logger logger = LoggerFactory.getLogger(ArgumentsFactory.class);
    private static final String OPTION_ANALYZE = "analyze";
    private static final String OPTION_COMPARE = "compare";
    private static final String OPTION_STATISTICS = "statistics";
    private static final String OPTION_INPUT_SHORT = "in";
    private static final String OPTION_INPUT_LONG = "input-dir";
    private static final String OPTION_OUTPUT_SHORT = "out";
    private static final String OPTION_OUTPUT_LONG = "output-dir";
    private final String[] args;
    private TaskMode taskMode;
    private String inputDirectory;
    private String outputDirectory;

    public ArgumentsFactory(String[] args) {
        this.args = args;
    }

    public Arguments parseArguments() throws ParseException {
        String val;
        DefaultParser parser = new DefaultParser();
        Options options = this.createOptions();
        CommandLine line = null;
        try {
            line = parser.parse(options, this.args);
        }
        catch (ParseException exp) {
            logger.error("Unexpected exception during parsing of cli attributes:" + exp.getMessage());
            throw exp;
        }
        if (line.hasOption(OPTION_ANALYZE)) {
            this.taskMode = TaskMode.ANALYZE;
        }
        if (line.hasOption(OPTION_COMPARE)) {
            this.taskMode = TaskMode.COMPARE;
        }
        if (line.hasOption(OPTION_STATISTICS)) {
            this.taskMode = TaskMode.STATISTICS;
        }
        if (line.hasOption(OPTION_INPUT_SHORT)) {
            this.inputDirectory = val = line.getOptionValue(OPTION_INPUT_SHORT);
        }
        if (line.hasOption(OPTION_OUTPUT_SHORT)) {
            this.outputDirectory = val = line.getOptionValue(OPTION_OUTPUT_SHORT);
        }
        return new Arguments(this.taskMode, this.inputDirectory, this.outputDirectory);
    }

    private Options createOptions() {
        Options options = new Options();
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.setRequired(true);
        optionGroup.addOption(Option.builder(OPTION_ANALYZE).desc("Analyze APK files. Json file with result will be created for every file").numberOfArgs(0).build());
        optionGroup.addOption(Option.builder(OPTION_COMPARE).desc("Compare all APK files metadata. This operation requires json files created by operation analyze.").numberOfArgs(0).build());
        optionGroup.addOption(Option.builder(OPTION_STATISTICS).desc("Compare statistics of APK files metadata. This operation requires json files created by operation analyze.").numberOfArgs(0).build());
        options.addOptionGroup(optionGroup);
        options.addOption(Option.builder(OPTION_INPUT_SHORT).longOpt(OPTION_INPUT_LONG).desc("Directory with APK or JSON files required for operation.").required().hasArg().numberOfArgs(1).build());
        options.addOption(Option.builder(OPTION_OUTPUT_SHORT).longOpt(OPTION_OUTPUT_LONG).desc("Directory where output of operation will be stored.").required().hasArg().numberOfArgs(1).build());
        return options;
    }
}

