/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.compare.processors;

import java.io.File;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import sk.styk.martin.bakalarka.compare.data.ComparisonResult;
import sk.styk.martin.bakalarka.compare.data.HashCompareResult;
import sk.styk.martin.bakalarka.compare.data.MetadataCompareResult;
import sk.styk.martin.bakalarka.compare.processors.SimilarityThreshold;
import sk.styk.martin.bakalarka.compare.processors.SimilarityThresholdFactory;
import sk.styk.martin.bakalarka.compare.processors.SimilarityType;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;

public class SimilarityEvaluator {
    private SimilarityThreshold similarityThreshold;
    private SimilarityType basicEvaluateResult;

    public SimilarityType basicEvaluate(ComparisonResult comparisonResult) {
        Boolean versionEvaluate;
        if (comparisonResult == null) {
            throw new IllegalArgumentException("comparisonResult is null");
        }
        MetadataCompareResult metadataResult = comparisonResult.getMetadataCompareResult();
        if (metadataResult == null) {
            comparisonResult.setSimilar(SimilarityType.NOT_SIMILAR);
            return SimilarityType.NOT_SIMILAR;
        }
        if (this.similarityThreshold == null) {
            this.similarityThreshold = SimilarityThresholdFactory.getInstance(new File("similarity.properties"));
        }
        Boolean fileSize = this.compareRatios(metadataResult.getFileSizeDifference(), this.similarityThreshold.getMaxFilesizeRatioDifference());
        Boolean activities = this.compareRatios(metadataResult.getNumberOfActivitiesDifference(), this.similarityThreshold.getMaxActivitiesRatioDifference());
        Boolean services = this.compareRatios(metadataResult.getNumberOfServicesDifference(), this.similarityThreshold.getMaxServicesRatioDifference());
        Boolean receivers = this.compareRatios(metadataResult.getNumberOfBroadcastReceiversDifference(), this.similarityThreshold.getMaxReceiversRatioDifference());
        Boolean providers = this.compareRatios(metadataResult.getNumberOfContentProvidersDifference(), this.similarityThreshold.getMaxProvidersRatioDifference());
        Boolean layout = this.compareRatios(metadataResult.getNumberOfDifferentLayoutsDifference(), this.similarityThreshold.getMaxDifferentLayoutsRatioDifference());
        Boolean drawable = this.compareRatios(metadataResult.getNumberOfDifferentDrawablesDifference(), this.similarityThreshold.getMaxDifferentDrawablesRatioDifference());
        boolean evaluateResult = this.evaluateBooleans(Arrays.asList(fileSize, activities, services, receivers, providers, layout, drawable), this.similarityThreshold.getMinBooleanEvaluationThreshold());
        Boolean certificateEvaluate = metadataResult.getCertificateSame();
        Boolean bl = versionEvaluate = metadataResult.getVersionCode() == null ? null : metadataResult.getVersionCode().getSame();
        if (!evaluateResult) {
            this.basicEvaluateResult = SimilarityType.NOT_SIMILAR;
        } else if (certificateEvaluate == null && versionEvaluate == null) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_UNDETERMINED_CERTIFICATE_UNDETERMINED_VERSION;
        } else if (certificateEvaluate == null && Boolean.TRUE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_UNDETERMINED_CERTIFICATE_SAME_VERSION;
        } else if (certificateEvaluate == null && Boolean.FALSE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_UNDETERMINED_CERTIFICATE_DIFFERENT_VERSION;
        } else if (Boolean.TRUE.equals(certificateEvaluate) && versionEvaluate == null) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_SAME_CERTIFICATE_UNDETERMINED_VERSION;
        } else if (Boolean.TRUE.equals(certificateEvaluate) && Boolean.TRUE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_SAME_CERTIFICATE_SAME_VERSION;
        } else if (Boolean.TRUE.equals(certificateEvaluate) && Boolean.FALSE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_SAME_CERTIFICATE_DIFFERENT_VERSION;
        } else if (Boolean.FALSE.equals(certificateEvaluate) && versionEvaluate == null) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_DIFFERENT_CERTIFICATE_UNDETERMINED_VERSION;
        } else if (Boolean.FALSE.equals(certificateEvaluate) && Boolean.TRUE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_DIFFERENT_CERTIFICATE_SAME_VERSION;
        } else if (Boolean.FALSE.equals(certificateEvaluate) && Boolean.FALSE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_DIFFERENT_CERTIFICATE_DIFFERENT_VERSION;
        }
        comparisonResult.setSimilar(this.basicEvaluateResult);
        return this.basicEvaluateResult;
    }

    public SimilarityType fullEvaluate(ComparisonResult comparisonResult) {
        if (comparisonResult == null) {
            throw new IllegalArgumentException("comparisonResult is null");
        }
        if (this.basicEvaluateResult != null && this.basicEvaluateResult.equals((Object)SimilarityType.NOT_SIMILAR)) {
            comparisonResult.setSimilar(SimilarityType.NOT_SIMILAR);
            return SimilarityType.NOT_SIMILAR;
        }
        HashCompareResult hashCompareResult = comparisonResult.getHashCompareResult();
        if (hashCompareResult == null) {
            SimilarityType isSimilar = this.basicEvaluateResult == null ? this.basicEvaluate(comparisonResult) : this.basicEvaluateResult;
            comparisonResult.setSimilar(isSimilar);
            return isSimilar;
        }
        if (this.similarityThreshold == null) {
            this.similarityThreshold = new SimilarityThreshold();
        }
        Boolean drawables = this.compareRatios(hashCompareResult.getJaccardIndexDrawables(), (Number)this.similarityThreshold.getMinIdenticalDrawablesInApkJaccardIndex(), true);
        Boolean layouts = this.compareRatios(hashCompareResult.getJaccardIndexLayouts(), (Number)this.similarityThreshold.getMinIdenticalLayoutsInApkJaccardIndex(), true);
        Boolean others = this.compareRatios(hashCompareResult.getJaccardIndexOthers(), (Number)this.similarityThreshold.getMinIdenticalOthersInApkJaccardIndex(), true);
        Boolean all = this.compareRatios(hashCompareResult.getJaccardIndexAll(), (Number)this.similarityThreshold.getMinIdenticalAllInApkJaccardIndex(), true);
        boolean result = this.evaluateBooleans(Arrays.asList(drawables, layouts, others, all), 85);
        Boolean certificateEvaluate = comparisonResult.getMetadataCompareResult() == null ? null : comparisonResult.getMetadataCompareResult().getCertificateSame();
        Boolean versionEvaluate = null;
        if (comparisonResult.getMetadataCompareResult() != null && comparisonResult.getMetadataCompareResult().getVersionCode() != null) {
            versionEvaluate = comparisonResult.getMetadataCompareResult().getVersionCode().getSame();
        }
        if (!result) {
            this.basicEvaluateResult = SimilarityType.NOT_SIMILAR;
        } else if (certificateEvaluate == null && versionEvaluate == null) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_UNDETERMINED_CERTIFICATE_UNDETERMINED_VERSION;
        } else if (certificateEvaluate == null && Boolean.TRUE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_UNDETERMINED_CERTIFICATE_SAME_VERSION;
        } else if (certificateEvaluate == null && Boolean.FALSE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_UNDETERMINED_CERTIFICATE_DIFFERENT_VERSION;
        } else if (Boolean.TRUE.equals(certificateEvaluate) && versionEvaluate == null) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_SAME_CERTIFICATE_UNDETERMINED_VERSION;
        } else if (Boolean.TRUE.equals(certificateEvaluate) && Boolean.TRUE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_SAME_CERTIFICATE_SAME_VERSION;
        } else if (Boolean.TRUE.equals(certificateEvaluate) && Boolean.FALSE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_SAME_CERTIFICATE_DIFFERENT_VERSION;
        } else if (Boolean.FALSE.equals(certificateEvaluate) && versionEvaluate == null) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_DIFFERENT_CERTIFICATE_UNDETERMINED_VERSION;
        } else if (Boolean.FALSE.equals(certificateEvaluate) && Boolean.TRUE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_DIFFERENT_CERTIFICATE_SAME_VERSION;
        } else if (Boolean.FALSE.equals(certificateEvaluate) && Boolean.FALSE.equals(versionEvaluate)) {
            this.basicEvaluateResult = SimilarityType.SIMILAR_DIFFERENT_CERTIFICATE_DIFFERENT_VERSION;
        }
        comparisonResult.setSimilar(this.basicEvaluateResult);
        return this.basicEvaluateResult;
    }

    private Boolean compareRatios(PercentagePair percentagePair, Number threshold) {
        return this.compareRatios(percentagePair, threshold, false);
    }

    private Boolean compareRatios(PercentagePair percentagePair, Number threshold, boolean isMinCriterium) {
        if (percentagePair == null) {
            return null;
        }
        return this.compareRatios(percentagePair.getPercentage(), threshold, isMinCriterium);
    }

    private Boolean compareRatios(BigDecimal percent, Number threshold, boolean isMinCriterium) {
        if (percent == null) {
            return null;
        }
        return isMinCriterium ? threshold.doubleValue() < percent.doubleValue() : percent.doubleValue() < threshold.doubleValue();
    }

    private Boolean evaluateBooleans(List<Boolean> booleans, int threshold) {
        int allSize = booleans.size();
        int falseSize = 0;
        int nullSize = 0;
        int trueSize = 0;
        for (Boolean b : booleans) {
            if (b == null) {
                ++nullSize;
                continue;
            }
            if (!b.booleanValue()) {
                ++falseSize;
                continue;
            }
            if (!b.booleanValue()) continue;
            ++trueSize;
        }
        int allSize2 = allSize - nullSize;
        return allSize2 > 0 ? trueSize * 100 / allSize2 > threshold : Boolean.valueOf(false);
    }

    public SimilarityThreshold getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public void setSimilarityThreshold(SimilarityThreshold similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }
}

