/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.compare.processors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.compare.data.AttributeComparisonResult;
import sk.styk.martin.bakalarka.compare.data.MetadataCompareResult;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;

public class MetadataPairCompare {
    private ApkData apkDataA;
    private ApkData apkDataB;
    private MetadataCompareResult result;
    private boolean isBasicCompared = false;

    public MetadataPairCompare(ApkData apkDataA, ApkData apkDataB) {
        if (apkDataA == null) {
            throw new IllegalArgumentException("apkDataA");
        }
        if (apkDataB == null) {
            throw new IllegalArgumentException("apkDataB");
        }
        this.apkDataA = apkDataA;
        this.apkDataB = apkDataB;
    }

    protected static BigDecimal getPercentage(long valueA, long valueB) {
        Long difference = valueB - valueA;
        Long bigger = valueA > valueB ? valueA : valueB;
        if (valueA == valueB) {
            return new BigDecimal(0);
        }
        if (bigger == 0L) {
            return null;
        }
        Double result = Math.abs(100.0 * difference.doubleValue() / bigger.doubleValue());
        return new BigDecimal(result);
    }

    public MetadataCompareResult basicCompare() {
        this.result = new MetadataCompareResult();
        this.compareFileSize();
        if (this.apkDataB.getAndroidManifest() != null && this.apkDataA.getAndroidManifest() != null) {
            this.compareActivities();
            this.compareServices();
            this.compareProviders();
            this.compareReceivers();
            this.compareVersionCode();
        }
        if (this.apkDataA.getResourceData() != null && this.apkDataB.getResourceData() != null) {
            this.compareNumberOfDifferentDrawables();
            this.compareNumberOfDifferentLayoutResources();
        }
        if (this.apkDataA.getCertificateDatas().size() > 0 && this.apkDataB.getCertificateDatas().size() > 0) {
            this.compareCertificate();
        }
        this.isBasicCompared = true;
        return this.result;
    }

    public MetadataCompareResult fullCompare() {
        if (!this.isBasicCompared) {
            this.result = this.basicCompare();
        }
        this.compareDexSize();
        this.compareArscSize();
        if (this.apkDataB.getAndroidManifest() != null && this.apkDataA.getAndroidManifest() != null) {
            this.comparePackageName();
            this.compareInstallLocation();
            this.compareUsedMinSdks();
            this.compareUsedMaxSdks();
            this.compareUsedTargetSdks();
            this.compareSupportsScreensResizeable();
            this.compareSupportsScreensAnyDensity();
            this.compareSupportsScreensXLarge();
            this.compareSupportsScreensLarge();
            this.compareSupportsScreensNormal();
            this.compareSupportsScreensSmall();
            this.compareLibraries();
            this.compareFeatures();
            this.comparePermission();
            this.compareDefinedPermissions();
        }
        if (this.apkDataA.getCertificateDatas().size() > 0 && this.apkDataB.getCertificateDatas().size() > 0) {
            this.compareCertificateSignAlgorithm();
            this.compareCertificateStartDate();
            this.compareCertificateEndDate();
            this.compareCertificatePublicKey();
            this.compareCertificateVersion();
            this.compareCertificateIssuer();
            this.compareCertificateSubject();
        }
        if (this.apkDataA.getResourceData() != null && this.apkDataB.getResourceData() != null) {
            this.compareLocales();
            this.compareNumberOfStringResources();
            this.compareNumberOfXmlDrawables();
            this.compareNumberOfJpgDrawables();
            this.compareNumberOfPngDrawables();
            this.compareNumberOfGifDrawables();
            this.compareNumberOfNinePatchDrawables();
            this.compareNumberOfLdpiDrawables();
            this.compareNumberOfMdpiDrawables();
            this.compareNumberOfHdpiDrawables();
            this.compareNumberOfXhdpiDrawables();
            this.compareNumberOfXxhdpiDrawables();
            this.compareNumberOfXxxhdpiDrawables();
            this.compareNumberOfTvdpiDrawables();
            this.compareNumberOfNodpiDrawables();
            this.compareNumberOfUnspecifiedDpiDrawables();
            this.compareNumberOfLayoutResources();
            this.compareNumberOfMenuResources();
            this.compareNumberOfRawResources();
        }
        return this.result;
    }

    private void compareFileSize() {
        if (this.apkDataA.getFileSize() == null || this.apkDataB.getFileSize() == null) {
            return;
        }
        Long diffSize = this.apkDataB.getFileSize() - this.apkDataA.getFileSize();
        this.result.setFileSizeDifference(new PercentagePair((Number)diffSize, MetadataPairCompare.getPercentage(this.apkDataA.getFileSize(), this.apkDataB.getFileSize())));
    }

    private void compareDexSize() {
        if (this.apkDataA.getDexSize() == null || this.apkDataB.getDexSize() == null) {
            return;
        }
        Long diffSize = this.apkDataB.getDexSize() - this.apkDataA.getDexSize();
        this.result.setDexSizeDifference(new PercentagePair((Number)diffSize, MetadataPairCompare.getPercentage(this.apkDataA.getDexSize(), this.apkDataB.getDexSize())));
    }

    private void compareArscSize() {
        if (this.apkDataA.getArscSize() == null || this.apkDataB.getArscSize() == null) {
            return;
        }
        Long diffSize = this.apkDataB.getArscSize() - this.apkDataA.getArscSize();
        this.result.setArscSizeDifference(new PercentagePair((Number)diffSize, MetadataPairCompare.getPercentage(this.apkDataA.getArscSize(), this.apkDataB.getArscSize())));
    }

    private void comparePackageName() {
        String nameA = this.apkDataA.getAndroidManifest().getPackageName();
        String nameB = this.apkDataB.getAndroidManifest().getPackageName();
        if (nameA == null || nameB == null) {
            return;
        }
        this.result.setPackageName(new AttributeComparisonResult<String>(nameA, nameB));
    }

    private void compareVersionCode() {
        String valueA = this.apkDataA.getAndroidManifest().getVersionCode();
        String valueB = this.apkDataB.getAndroidManifest().getVersionCode();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setVersionCode(new AttributeComparisonResult<String>(valueA, valueB));
    }

    private void compareInstallLocation() {
        String valueA = this.apkDataA.getAndroidManifest().getInstallLocation();
        String valueB = this.apkDataB.getAndroidManifest().getInstallLocation();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setInstallLocation(new AttributeComparisonResult<String>(valueA, valueB));
    }

    private void compareUsedMinSdks() {
        String valueA = this.apkDataA.getAndroidManifest().getUsesMinSdkVersion();
        String valueB = this.apkDataB.getAndroidManifest().getUsesMinSdkVersion();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setUsesMinSdkVersion(new AttributeComparisonResult<String>(valueA, valueB));
    }

    private void compareUsedTargetSdks() {
        String valueA = this.apkDataA.getAndroidManifest().getUsesTargetSdkVersion();
        String valueB = this.apkDataB.getAndroidManifest().getUsesTargetSdkVersion();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setUsesTargetSdkVersion(new AttributeComparisonResult<String>(valueA, valueB));
    }

    private void compareUsedMaxSdks() {
        String valueA = this.apkDataA.getAndroidManifest().getUsesMaxSdkVersion();
        String valueB = this.apkDataB.getAndroidManifest().getUsesMaxSdkVersion();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setUsesMaxSdkVersion(new AttributeComparisonResult<String>(valueA, valueB));
    }

    private void compareSupportsScreensResizeable() {
        Boolean valueA = this.apkDataA.getAndroidManifest().getSupportsScreensResizeable();
        Boolean valueB = this.apkDataB.getAndroidManifest().getSupportsScreensResizeable();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setSupportsScreensResizeable(new AttributeComparisonResult<Boolean>(valueA, valueB));
    }

    private void compareSupportsScreensSmall() {
        Boolean valueA = this.apkDataA.getAndroidManifest().getSupportsScreensSmall();
        Boolean valueB = this.apkDataB.getAndroidManifest().getSupportsScreensSmall();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setSupportsScreensSmall(new AttributeComparisonResult<Boolean>(valueA, valueB));
    }

    private void compareSupportsScreensNormal() {
        Boolean valueA = this.apkDataA.getAndroidManifest().getSupportsScreensNormal();
        Boolean valueB = this.apkDataB.getAndroidManifest().getSupportsScreensNormal();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setSupportsScreensNormal(new AttributeComparisonResult<Boolean>(valueA, valueB));
    }

    private void compareSupportsScreensLarge() {
        Boolean valueA = this.apkDataA.getAndroidManifest().getSupportsScreensLarge();
        Boolean valueB = this.apkDataB.getAndroidManifest().getSupportsScreensLarge();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setSupportsScreensLarge(new AttributeComparisonResult<Boolean>(valueA, valueB));
    }

    private void compareSupportsScreensXLarge() {
        Boolean valueA = this.apkDataA.getAndroidManifest().getSupportsScreensXlarge();
        Boolean valueB = this.apkDataB.getAndroidManifest().getSupportsScreensXlarge();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setSupportsScreensXlarge(new AttributeComparisonResult<Boolean>(valueA, valueB));
    }

    private void compareSupportsScreensAnyDensity() {
        Boolean valueA = this.apkDataA.getAndroidManifest().getSupportsScreensAnyDensity();
        Boolean valueB = this.apkDataB.getAndroidManifest().getSupportsScreensAnyDensity();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setSupportsScreensAnyDensity(new AttributeComparisonResult<Boolean>(valueA, valueB));
    }

    private void compareActivities() {
        Integer valueA = this.apkDataA.getAndroidManifest().getNumberOfActivities();
        Integer valueB = this.apkDataB.getAndroidManifest().getNumberOfActivities();
        if (valueA == null || valueB == null) {
            return;
        }
        Integer difference = valueB - valueA;
        this.result.setNumberOfActivitiesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
        if (difference == 0) {
            return;
        }
        ArrayList<String> namesOfActivitiesA = new ArrayList<String>(this.apkDataA.getAndroidManifest().getNamesOfActivities());
        ArrayList<String> namesOfActivitiesB = new ArrayList<String>(this.apkDataB.getAndroidManifest().getNamesOfActivities());
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        this.compareLists(namesOfActivitiesA, namesOfActivitiesB, additionalInA, additionalInB);
        this.result.setAdditionalActivitiesInA(additionalInA);
        this.result.setAdditionalActivitiesInB(additionalInB);
    }

    private void compareServices() {
        Integer valueA = this.apkDataA.getAndroidManifest().getNumberOfServices();
        Integer valueB = this.apkDataB.getAndroidManifest().getNumberOfServices();
        if (valueA == null || valueB == null) {
            return;
        }
        Integer difference = valueB - valueA;
        this.result.setNumberOfServicesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
        if (difference == 0) {
            return;
        }
        ArrayList<String> namesOfServicesA = new ArrayList<String>(this.apkDataA.getAndroidManifest().getNamesOfServices());
        ArrayList<String> namesOfServicesB = new ArrayList<String>(this.apkDataB.getAndroidManifest().getNamesOfServices());
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        this.compareLists(namesOfServicesA, namesOfServicesB, additionalInA, additionalInB);
        this.result.setAdditionalServicesInA(additionalInA);
        this.result.setAdditionalServicesInB(additionalInB);
    }

    private void compareProviders() {
        Integer valueA = this.apkDataA.getAndroidManifest().getNumberOfContentProviders();
        Integer valueB = this.apkDataB.getAndroidManifest().getNumberOfContentProviders();
        if (valueA == null || valueB == null) {
            return;
        }
        Integer difference = valueB - valueA;
        this.result.setNumberOfContentProvidersDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
        if (difference == 0) {
            return;
        }
        ArrayList<String> namesInA = new ArrayList<String>(this.apkDataA.getAndroidManifest().getNamesOfContentProviders());
        ArrayList<String> namesInB = new ArrayList<String>(this.apkDataB.getAndroidManifest().getNamesOfContentProviders());
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        this.compareLists(namesInA, namesInB, additionalInA, additionalInB);
        this.result.setAdditionalContentProvidersInA(additionalInA);
        this.result.setAdditionalContentProvidersInB(additionalInB);
    }

    private void compareReceivers() {
        Integer valueA = this.apkDataA.getAndroidManifest().getNumberOfBroadcastReceivers();
        Integer valueB = this.apkDataB.getAndroidManifest().getNumberOfBroadcastReceivers();
        if (valueA == null || valueB == null) {
            return;
        }
        Integer difference = valueB - valueA;
        this.result.setNumberOfBroadcastReceiversDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
        if (difference == 0) {
            return;
        }
        ArrayList<String> namesInA = new ArrayList<String>(this.apkDataA.getAndroidManifest().getNamesOfBroadcastReceivers());
        ArrayList<String> namesInB = new ArrayList<String>(this.apkDataB.getAndroidManifest().getNamesOfBroadcastReceivers());
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        this.compareLists(namesInA, namesInB, additionalInA, additionalInB);
        this.result.setAdditionalBroadcastReceiversInA(additionalInA);
        this.result.setAdditionalBroadcastReceiversInA(additionalInB);
    }

    private void comparePermission() {
        Integer valueA = this.apkDataA.getAndroidManifest().getUsesPermissions().size();
        Integer valueB = this.apkDataB.getAndroidManifest().getUsesPermissions().size();
        if (valueA == null || valueB == null) {
            return;
        }
        Integer difference = valueB - valueA;
        this.result.setNumberOfPermissionsDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
        if (difference == 0) {
            return;
        }
        ArrayList<String> namesInA = new ArrayList<String>(this.apkDataA.getAndroidManifest().getUsesPermissions());
        ArrayList<String> namesInB = new ArrayList<String>(this.apkDataB.getAndroidManifest().getUsesPermissions());
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        this.compareLists(namesInA, namesInB, additionalInA, additionalInB);
        this.result.setAdditionalPermissionsInA(additionalInA);
        this.result.setAdditionalPermissionsInB(additionalInB);
    }

    private void compareLibraries() {
        Integer valueA = this.apkDataA.getAndroidManifest().getUsesLibrary().size();
        Integer valueB = this.apkDataB.getAndroidManifest().getUsesLibrary().size();
        if (valueA == null || valueB == null) {
            return;
        }
        Integer difference = valueB - valueA;
        this.result.setNumberOfLibrariesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
        if (difference == 0) {
            return;
        }
        ArrayList<String> namesInA = new ArrayList<String>(this.apkDataA.getAndroidManifest().getUsesLibrary());
        ArrayList<String> namesInB = new ArrayList<String>(this.apkDataB.getAndroidManifest().getUsesLibrary());
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        this.compareLists(namesInA, namesInB, additionalInA, additionalInB);
        this.result.setAdditionalLibrariesInA(additionalInA);
        this.result.setAdditionalLibrariesInB(additionalInB);
    }

    private void compareFeatures() {
        Integer valueA = this.apkDataA.getAndroidManifest().getUsesFeature().size();
        Integer valueB = this.apkDataB.getAndroidManifest().getUsesFeature().size();
        if (valueA == null || valueB == null) {
            return;
        }
        Integer difference = valueB - valueA;
        this.result.setNumberOfFeaturesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
        if (difference == 0) {
            return;
        }
        ArrayList<String> namesInA = new ArrayList<String>(this.apkDataA.getAndroidManifest().getUsesFeature());
        ArrayList<String> namesInB = new ArrayList<String>(this.apkDataB.getAndroidManifest().getUsesFeature());
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        this.compareLists(namesInA, namesInB, additionalInA, additionalInB);
        this.result.setAdditionalFeaturesInA(additionalInA);
        this.result.setAdditionalFeaturesInB(additionalInB);
    }

    private void compareDefinedPermissions() {
        Integer valueA = this.apkDataA.getAndroidManifest().getPermissions().size();
        Integer valueB = this.apkDataB.getAndroidManifest().getPermissions().size();
        if (valueA == null || valueB == null) {
            return;
        }
        Integer difference = valueB - valueA;
        this.result.setNumberOfDefinedPermissionsDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
        if (difference == 0) {
            return;
        }
        ArrayList<String> namesInA = new ArrayList<String>(this.apkDataA.getAndroidManifest().getPermissions());
        ArrayList<String> namesInB = new ArrayList<String>(this.apkDataB.getAndroidManifest().getPermissions());
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        this.compareLists(namesInA, namesInB, additionalInA, additionalInB);
        this.result.setAdditionalDefinedPermissionsInA(additionalInA);
        this.result.setAdditionalDefinedPermissionsInB(additionalInB);
    }

    private void compareCertificateSignAlgorithm() {
        String valueA = this.apkDataA.getCertificateDatas().get(0).getSignAlgorithm();
        String valueB = this.apkDataB.getCertificateDatas().get(0).getSignAlgorithm();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setCertificateSignAlgorithmSame(new AttributeComparisonResult<String>(valueA, valueB));
    }

    private void compareCertificateStartDate() {
        Date valueA = this.apkDataA.getCertificateDatas().get(0).getStartDate();
        Date valueB = this.apkDataB.getCertificateDatas().get(0).getStartDate();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setCertificateStartDateSame(new AttributeComparisonResult<Date>(valueA, valueB));
    }

    private void compareCertificateEndDate() {
        Date valueA = this.apkDataA.getCertificateDatas().get(0).getEndDate();
        Date valueB = this.apkDataB.getCertificateDatas().get(0).getEndDate();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setCertificateEndDateSame(new AttributeComparisonResult<Date>(valueA, valueB));
    }

    private void compareCertificatePublicKey() {
        String valueA = this.apkDataA.getCertificateDatas().get(0).getPublicKeyMd5();
        String valueB = this.apkDataB.getCertificateDatas().get(0).getPublicKeyMd5();
        if (valueA == null || valueB == null) {
            return;
        }
        boolean isSame = valueA.equals(valueB);
        this.result.setCertificatePublicKeySame(isSame);
    }

    private void compareCertificate() {
        String valueA = this.apkDataA.getCertificateDatas().get(0).getCertMd5();
        String valueB = this.apkDataB.getCertificateDatas().get(0).getCertMd5();
        if (valueA == null || valueB == null) {
            return;
        }
        boolean isSame = valueA.equals(valueB);
        this.result.setCertificateSame(isSame);
    }

    private void compareCertificateVersion() {
        Integer valueA = this.apkDataA.getCertificateDatas().get(0).getVersion();
        Integer valueB = this.apkDataB.getCertificateDatas().get(0).getVersion();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setCertificateVersionSame(new AttributeComparisonResult<Integer>(valueA, valueB));
    }

    private void compareCertificateIssuer() {
        String valueA = this.apkDataA.getCertificateDatas().get(0).getIssuerName();
        String valueB = this.apkDataB.getCertificateDatas().get(0).getIssuerName();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setCertificateIssuerNameSame(new AttributeComparisonResult<String>(valueA, valueB));
    }

    private void compareCertificateSubject() {
        String valueA = this.apkDataA.getCertificateDatas().get(0).getSubjectName();
        String valueB = this.apkDataB.getCertificateDatas().get(0).getSubjectName();
        if (valueA == null || valueB == null) {
            return;
        }
        this.result.setCertificateSubjectNameSame(new AttributeComparisonResult<String>(valueA, valueB));
    }

    private void compareLocales() {
        List<String> valueA = this.apkDataA.getResourceData().getLocale();
        List<String> valueB = this.apkDataB.getResourceData().getLocale();
        if (valueA == null || valueB == null) {
            return;
        }
        Integer difference = valueB.size() - valueA.size();
        this.result.setNumberOfLocalesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.size(), valueB.size())));
        if (difference == 0) {
            return;
        }
        ArrayList<String> namesInA = new ArrayList<String>(valueA);
        ArrayList<String> namesInB = new ArrayList<String>(valueB);
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        this.compareLists(namesInA, namesInB, additionalInA, additionalInB);
        this.result.setAdditionalLocalesInA(additionalInA);
        this.result.setAdditionalLocalesInB(additionalInB);
    }

    private void compareNumberOfStringResources() {
        Integer valueA = this.apkDataA.getResourceData().getNumberOfStringResource();
        Integer valueB = this.apkDataB.getResourceData().getNumberOfStringResource();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfStringResourceDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfPngDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getPngDrawables();
        Integer valueB = this.apkDataB.getResourceData().getPngDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfPngDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfJpgDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getJpgDrawables();
        Integer valueB = this.apkDataB.getResourceData().getJpgDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfJpgDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfGifDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getGifDrawables();
        Integer valueB = this.apkDataB.getResourceData().getGifDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfGifDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfNinePatchDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getNinePatchDrawables();
        Integer valueB = this.apkDataB.getResourceData().getNinePatchDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfNinePatchDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfXmlDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getXmlDrawables();
        Integer valueB = this.apkDataB.getResourceData().getXmlDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfXmlDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfLdpiDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getLdpiDrawables();
        Integer valueB = this.apkDataB.getResourceData().getLdpiDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfLdpiDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfMdpiDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getMdpiDrawables();
        Integer valueB = this.apkDataB.getResourceData().getMdpiDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfMdpiDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfHdpiDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getHdpiDrawables();
        Integer valueB = this.apkDataB.getResourceData().getHdpiDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfHdpiDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfXhdpiDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getXhdpiDrawables();
        Integer valueB = this.apkDataB.getResourceData().getXhdpiDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfXhdpiDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfXxhdpiDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getXxhdpiDrawables();
        Integer valueB = this.apkDataB.getResourceData().getXxhdpiDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfXxhdpiDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfXxxhdpiDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getXxxhdpiDrawables();
        Integer valueB = this.apkDataB.getResourceData().getXxxhdpiDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfXxxhdpiDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfUnspecifiedDpiDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getUnspecifiedDpiDrawables();
        Integer valueB = this.apkDataB.getResourceData().getUnspecifiedDpiDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfUnspecifiedDpiDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfNodpiDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getNodpiDrawables();
        Integer valueB = this.apkDataB.getResourceData().getNodpiDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfNodpihdpiDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfTvdpiDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getTvdpiDrawables();
        Integer valueB = this.apkDataB.getResourceData().getTvdpiDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfTvdpiDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfRawResources() {
        Integer valueA = this.apkDataA.getResourceData().getRawResources();
        Integer valueB = this.apkDataB.getResourceData().getRawResources();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfRawResourcesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfMenuResources() {
        Integer valueA = this.apkDataA.getResourceData().getMenu();
        Integer valueB = this.apkDataB.getResourceData().getMenu();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfMenusDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfLayoutResources() {
        Integer valueA = this.apkDataA.getResourceData().getLayouts();
        Integer valueB = this.apkDataB.getResourceData().getLayouts();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfLayoutsDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfDifferentLayoutResources() {
        Integer valueA = this.apkDataA.getResourceData().getDifferentLayouts();
        Integer valueB = this.apkDataB.getResourceData().getDifferentLayouts();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfDifferentLayoutsDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private void compareNumberOfDifferentDrawables() {
        Integer valueA = this.apkDataA.getResourceData().getDifferentDrawables();
        Integer valueB = this.apkDataB.getResourceData().getDifferentDrawables();
        if (valueA == null || valueB == null) {
            return;
        }
        int difference = valueB - valueA;
        this.result.setNumberOfDifferentDrawablesDifference(new PercentagePair((Number)difference, MetadataPairCompare.getPercentage(valueA.intValue(), valueB.intValue())));
    }

    private <X> void compareLists(List<X> inputA, List<X> inputB, List<X> additionalA, List<X> additionalB) {
        if (inputA == null || inputB == null) {
            return;
        }
        additionalA.addAll(inputA);
        additionalB.addAll(inputB);
        for (X value : inputA) {
            if (!inputB.contains(value)) continue;
            additionalA.remove(value);
            additionalB.remove(value);
        }
    }

    private String getDifferenceString(Object valueA, Object valueB) {
        return "Apk A : " + valueA.toString() + " ; Apk B : " + valueB.toString();
    }
}

