/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.compare.processors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sk.styk.martin.bakalarka.analyze.data.HashData;
import sk.styk.martin.bakalarka.compare.data.HashCompareResult;
import sk.styk.martin.bakalarka.utils.data.PercentagePair;

public class HashPairCompare {
    private HashData hashDataA;
    private HashData hashDataB;
    private HashCompareResult result;

    public HashPairCompare(HashData hashDataA, HashData hashDataB) {
        if (hashDataA == null) {
            throw new IllegalArgumentException("hashDataA");
        }
        if (hashDataB == null) {
            throw new IllegalArgumentException("hashDataB");
        }
        this.hashDataA = hashDataA;
        this.hashDataB = hashDataB;
    }

    public HashCompareResult hashCompare() {
        if (this.result != null) {
            return this.result;
        }
        this.result = new HashCompareResult();
        this.compareArsc();
        this.compareDex();
        this.compareDrawable();
        this.compareLayouts();
        this.compareOther();
        this.compareAll();
        return this.result;
    }

    private void compareArsc() {
        String arscA = this.hashDataA.getArscHash();
        String arscB = this.hashDataB.getArscHash();
        if (arscA != null && arscB != null) {
            this.result.setArscIdentical(arscA.equals(arscB));
        }
    }

    private void compareDex() {
        String dexA = this.hashDataA.getDexHash();
        String dexB = this.hashDataB.getDexHash();
        if (dexA != null && dexB != null) {
            this.result.setDexIdentical(dexA.equals(dexB));
        }
    }

    private void compareDrawable() {
        String additionFile;
        Map<String, String> mapA = this.hashDataA.getDrawableHash();
        Map<String, String> mapB = this.hashDataB.getDrawableHash();
        if (mapA == null || mapB == null) {
            return;
        }
        HashSet<String> keysA = new HashSet<String>(mapA.keySet());
        HashSet<String> keysB = new HashSet<String>(mapB.keySet());
        this.compare(keysA, keysB);
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        ArrayList<String> modified = new ArrayList<String>();
        for (String string : keysA) {
            additionFile = mapA.get(string);
            additionalInA.add(additionFile);
        }
        for (String string : keysB) {
            additionFile = mapB.get(string);
            additionalInB.add(additionFile);
        }
        ArrayList addtionalInAclone = new ArrayList(additionalInA);
        for (String s3 : addtionalInAclone) {
            if (!additionalInB.contains(s3)) continue;
            modified.add(s3);
            additionalInA.remove(s3);
            additionalInB.remove(s3);
        }
        this.result.setAdditionalDrawableFilesA(additionalInA);
        this.result.setAdditionalDrawableFilesB(additionalInB);
        this.result.setModifiedDrawableFiles(modified);
        this.result.setTotalDrawablesA(mapA.keySet().size());
        this.result.setTotalDrawablesB(mapB.keySet().size());
        int n = mapA.keySet().size() > mapB.keySet().size() ? mapA.keySet().size() : mapB.keySet().size();
        this.result.setIdenticalDrawables(new PercentagePair((Number)(mapA.keySet().size() - keysA.size()), this.getPercentage(mapA.keySet().size() - keysA.size(), n)));
        this.result.setJaccardIndexDrawables(this.getJaccardIndex(mapA.values(), mapB.values()));
    }

    private void compareLayouts() {
        String additionFile;
        Map<String, String> mapA = this.hashDataA.getLayoutHash();
        Map<String, String> mapB = this.hashDataB.getLayoutHash();
        if (mapA == null || mapB == null) {
            return;
        }
        HashSet<String> keysA = new HashSet<String>(mapA.keySet());
        HashSet<String> keysB = new HashSet<String>(mapB.keySet());
        this.compare(keysA, keysB);
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        ArrayList<String> modified = new ArrayList<String>();
        for (String string : keysA) {
            additionFile = mapA.get(string);
            additionalInA.add(additionFile);
        }
        for (String string : keysB) {
            additionFile = mapB.get(string);
            additionalInB.add(additionFile);
        }
        ArrayList addtionalInAclone = new ArrayList(additionalInA);
        for (String s3 : addtionalInAclone) {
            if (!additionalInB.contains(s3)) continue;
            modified.add(s3);
            additionalInA.remove(s3);
            additionalInB.remove(s3);
        }
        this.result.setAdditionaLayoutFilesA(additionalInA);
        this.result.setAdditionaLayoutFilesB(additionalInB);
        this.result.setModifiedLayoutFiles(modified);
        this.result.setTotalLayoutsA(mapA.keySet().size());
        this.result.setTotalLayoutsB(mapB.keySet().size());
        int n = mapA.keySet().size() > mapB.keySet().size() ? mapA.keySet().size() : mapB.keySet().size();
        this.result.setIdenticalLayouts(new PercentagePair((Number)(mapA.keySet().size() - keysA.size()), this.getPercentage(mapA.keySet().size() - keysA.size(), n)));
        this.result.setJaccardIndexLayouts(this.getJaccardIndex(mapA.values(), mapB.values()));
    }

    private void compareAll() {
        HashSet<String> mapA = new HashSet<String>();
        HashSet<String> mapB = new HashSet<String>();
        if (this.hashDataA.getArscHash() != null) {
            mapA.add(this.hashDataA.getArscHash());
        }
        if (this.hashDataB.getArscHash() != null) {
            mapB.add(this.hashDataB.getArscHash());
        }
        if (this.hashDataA.getDexHash() != null) {
            mapA.add(this.hashDataA.getDexHash());
        }
        if (this.hashDataB.getDexHash() != null) {
            mapB.add(this.hashDataB.getDexHash());
        }
        if (this.hashDataA.getDrawableHash() != null) {
            mapA.addAll(this.hashDataA.getDrawableHash().values());
        }
        if (this.hashDataB.getDrawableHash() != null) {
            mapB.addAll(this.hashDataB.getDrawableHash().values());
        }
        if (this.hashDataA.getLayoutHash() != null) {
            mapA.addAll(this.hashDataA.getLayoutHash().values());
        }
        if (this.hashDataB.getLayoutHash() != null) {
            mapB.addAll(this.hashDataB.getLayoutHash().values());
        }
        if (this.hashDataA.getOtherHash() != null) {
            mapA.addAll(this.hashDataA.getOtherHash().values());
        }
        if (this.hashDataB.getOtherHash() != null) {
            mapB.addAll(this.hashDataB.getOtherHash().values());
        }
        this.result.setJaccardIndexAll(this.getJaccardIndex(mapA, mapB));
    }

    private void compareOther() {
        String additionFile;
        Map<String, String> mapA = this.hashDataA.getOtherHash();
        Map<String, String> mapB = this.hashDataB.getOtherHash();
        if (mapA == null || mapB == null) {
            return;
        }
        HashSet<String> keysA = new HashSet<String>(mapA.keySet());
        HashSet<String> keysB = new HashSet<String>(mapB.keySet());
        this.compare(keysA, keysB);
        ArrayList<String> additionalInA = new ArrayList<String>();
        ArrayList<String> additionalInB = new ArrayList<String>();
        ArrayList<String> modified = new ArrayList<String>();
        for (String string : keysA) {
            additionFile = mapA.get(string);
            additionalInA.add(additionFile);
        }
        for (String string : keysB) {
            additionFile = mapB.get(string);
            additionalInB.add(additionFile);
        }
        ArrayList addtionalInAclone = new ArrayList(additionalInA);
        for (String s3 : addtionalInAclone) {
            if (!additionalInB.contains(s3)) continue;
            modified.add(s3);
            additionalInA.remove(s3);
            additionalInB.remove(s3);
        }
        this.result.setAdditionalOtherFilesA(additionalInA);
        this.result.setAdditionalOtherFilesB(additionalInB);
        this.result.setModifiedOtherFiles(modified);
        this.result.setTotalOthersA(mapA.keySet().size());
        this.result.setTotalOthersB(mapB.keySet().size());
        int n = mapA.keySet().size() > mapB.keySet().size() ? mapA.keySet().size() : mapB.keySet().size();
        this.result.setIdenticalOthers(new PercentagePair((Number)(mapA.keySet().size() - keysA.size()), this.getPercentage(mapA.keySet().size() - keysA.size(), n)));
        this.result.setJaccardIndexOthers(this.getJaccardIndex(mapA.values(), mapB.values()));
    }

    private void compare(Set<String> keysA, Set<String> keysB) {
        HashSet<String> keysAClone = new HashSet<String>(keysA);
        for (String value : keysAClone) {
            if (!keysB.contains(value)) continue;
            keysB.remove(value);
            keysA.remove(value);
        }
    }

    private BigDecimal getPercentage(Integer part, Integer bigger) {
        Double result = Math.abs(100.0 * part.doubleValue() / bigger.doubleValue());
        return new BigDecimal(result);
    }

    private BigDecimal getJaccardIndex(Collection<String> setA, Collection<String> setB) {
        HashSet<String> union = new HashSet<String>(setA.size() + setB.size());
        union.addAll(setA);
        union.addAll(setB);
        double sizeA = setA.size();
        double sizeB = setB.size();
        double sizeUnion = union.size();
        return new BigDecimal((sizeA + sizeB - sizeUnion) / sizeUnion);
    }
}

