/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.compare.processors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.compare.data.ComparisonResult;
import sk.styk.martin.bakalarka.compare.processors.ApkPairCompare;
import sk.styk.martin.bakalarka.compare.processors.HashPairCompare;
import sk.styk.martin.bakalarka.compare.processors.MetadataPairCompare;
import sk.styk.martin.bakalarka.compare.processors.SimilarityEvaluator;
import sk.styk.martin.bakalarka.compare.processors.SimilarityType;

public class ApkPairCompareSimilarImpl
implements ApkPairCompare {
    private static final Logger logger = LoggerFactory.getLogger(ApkPairCompare.class);
    private ApkData dataA;
    private ApkData dataB;
    private ComparisonResult comparisonResult;
    private HashPairCompare hashComparator;
    private MetadataPairCompare metadataComparator;
    private SimilarityEvaluator similarityEvaluator;

    public ApkPairCompareSimilarImpl(ApkData dataA, ApkData dataB) {
        if (dataA == null || dataB == null) {
            throw new IllegalArgumentException("data is null");
        }
        this.dataA = dataA;
        this.dataB = dataB;
        this.hashComparator = new HashPairCompare(dataA.getFileDigest(), dataB.getFileDigest());
        this.metadataComparator = new MetadataPairCompare(dataA, dataB);
        this.similarityEvaluator = new SimilarityEvaluator();
    }

    @Override
    public ComparisonResult compare() {
        logger.trace("Start compare " + this.dataA.getFileName() + " and " + this.dataB.getFileName());
        this.comparisonResult = new ComparisonResult(this.dataA.getFileName(), this.dataB.getFileName());
        this.comparisonResult.setMetadataCompareResult(this.metadataComparator.basicCompare());
        SimilarityType isBasicallySimilar = this.similarityEvaluator.basicEvaluate(this.comparisonResult);
        if (isBasicallySimilar == null || SimilarityType.NOT_SIMILAR.equals((Object)isBasicallySimilar)) {
            logger.trace("Basically not similar " + this.dataA.getFileName() + " and " + this.dataB.getFileName());
            return this.comparisonResult;
        }
        this.comparisonResult.setMetadataCompareResult(this.metadataComparator.fullCompare());
        this.comparisonResult.setHashCompareResult(this.hashComparator.hashCompare());
        SimilarityType isDetailedSimilar = this.similarityEvaluator.fullEvaluate(this.comparisonResult);
        logger.trace("Finished compare " + this.dataA.getFileName() + " and " + this.dataB.getFileName() + "with result" + (Object)((Object)isDetailedSimilar));
        return this.comparisonResult;
    }

    @Override
    public SimilarityEvaluator getSimilarityEvaluator() {
        return this.similarityEvaluator;
    }

    @Override
    public void setSimilarityEvaluator(SimilarityEvaluator similarityEvaluator) {
        this.similarityEvaluator = similarityEvaluator;
    }
}

