/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.compare.processors;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.compare.data.ComparisonResult;
import sk.styk.martin.bakalarka.compare.processors.ApkPairCompareSimilarImpl;
import sk.styk.martin.bakalarka.compare.processors.SimilarityType;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class ApkDataCompareTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ApkDataCompareTask.class);
    private ApkData apkDataA;
    private ApkData apkDataB;
    private File outputDirectoryBase;

    public ApkDataCompareTask(ApkData apkDataA, ApkData apkDataB, File outputDirectory) {
        if (apkDataA == null) {
            throw new IllegalArgumentException("apkDataA null");
        }
        if (apkDataB == null) {
            throw new IllegalArgumentException("apkDataB null");
        }
        this.apkDataA = apkDataA;
        this.apkDataB = apkDataB;
        this.outputDirectoryBase = outputDirectory;
    }

    @Override
    public void run() {
        logger.trace("start " + this.apkDataA.getFileName() + " " + this.apkDataB.getFileName());
        ApkPairCompareSimilarImpl apkPairCompare = new ApkPairCompareSimilarImpl(this.apkDataA, this.apkDataB);
        ComparisonResult comparisonResult = apkPairCompare.compare();
        SimilarityType similar = comparisonResult.getSimilar();
        if (similar == null || similar.equals((Object)SimilarityType.NOT_SIMILAR)) {
            logger.info("APK A :" + comparisonResult.getNameA() + " APK B : " + comparisonResult.getNameB() + " not similar");
        } else {
            logger.info("APK A :" + comparisonResult.getNameA() + " APK B : " + comparisonResult.getNameB() + " -> " + similar.toString());
            if (this.isWriteToFile()) {
                JsonUtils.toJson(comparisonResult, new File(this.outputDirectoryBase, similar.toString()));
            } else {
                logger.info(comparisonResult.toString());
            }
        }
        logger.trace("end " + this.apkDataA.getFileName() + " " + this.apkDataB.getFileName());
    }

    private boolean isWriteToFile() {
        return this.outputDirectoryBase != null;
    }
}

