/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.compare.processors;

import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.compare.processors.ApkDataCompareTask;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class ApkBatchCompare {
    private static final Logger logger = LoggerFactory.getLogger(ApkBatchCompare.class);
    private List<File> jsons;

    public ApkBatchCompare(List<File> jsons) {
        if (jsons == null || jsons.isEmpty()) {
            throw new IllegalArgumentException("jsons not valid");
        }
        for (File f : jsons) {
            if (f.getName().endsWith("json")) continue;
            throw new IllegalArgumentException("file " + f.getName() + "is not a json");
        }
        this.jsons = jsons;
    }

    public void processFiles(File outputDirectory) {
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(numberOfProcessors);
        int jsonsSize = this.jsons.size();
        for (int i = 0; i < jsonsSize - 1; ++i) {
            ApkData apkDataA = JsonUtils.fromJson(this.jsons.get(i));
            for (int j = i + 1; j < jsonsSize; ++j) {
                ApkData apkDataB = JsonUtils.fromJson(this.jsons.get(j));
                try {
                    pool.submit(new ApkDataCompareTask(apkDataA, apkDataB, outputDirectory));
                    continue;
                }
                catch (Exception e) {
                    logger.error("One of json were not loaded " + this.jsons.get(i).getName() + this.jsons.get(j).getName());
                }
            }
        }
        pool.shutdown();
        try {
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn(e.toString());
        }
    }
}

