/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.analyze.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.w3c.dom.Document;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.analyze.data.ResourceData;
import sk.styk.martin.bakalarka.analyze.processors.helpers.XmlParsingHelper;
import sk.styk.martin.bakalarka.utils.files.ApkFile;
import sk.styk.martin.bakalarka.utils.files.FileFinder;

public class ResourceProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ResourceProcessor.class);
    private Marker apkNameMarker;
    private ApkData data;
    private ApkFile apkFile;
    private ResourceData resourceData;
    private FileFinder resourceDirectoryFileFinder;

    public ResourceProcessor(ApkData data, ApkFile apkFile) {
        if (data == null) {
            throw new IllegalArgumentException("data null");
        }
        if (apkFile == null) {
            throw new IllegalArgumentException("apkFile null");
        }
        this.data = data;
        this.apkFile = apkFile;
        this.apkNameMarker = apkFile.getMarker();
    }

    public ResourceProcessor(ApkFile apkFile) {
        if (apkFile == null) {
            throw new IllegalArgumentException("apkFile null");
        }
        this.apkFile = apkFile;
        this.apkNameMarker = apkFile.getMarker();
    }

    public static ResourceProcessor getInstance(ApkData data, ApkFile apkFile) {
        return new ResourceProcessor(data, apkFile);
    }

    public static ResourceProcessor getInstance(ApkFile apkFile) {
        return new ResourceProcessor(apkFile);
    }

    public ResourceData processResources() {
        logger.trace(this.apkNameMarker + "Started processing of resources");
        File resFolder = new File(this.apkFile.getDecompiledDirectoryWithDecompiledData(), "res");
        if (!resFolder.exists()) {
            logger.warn(this.apkNameMarker + "res directory doesn`t exists, aborting getting of resources");
            return null;
        }
        try {
            this.resourceDirectoryFileFinder = new FileFinder(resFolder);
        }
        catch (Exception e) {
            logger.warn(this.apkNameMarker + "res directory doesn`t exists, aborting getting of resources");
            return null;
        }
        this.resourceData = new ResourceData();
        this.resourceData.setLocale(this.getStringLocalizations());
        this.resourceData.setNumberOfStringResource(this.getNumberOfStringResource());
        this.resourceData.setRawResources(this.getNumberOfRawResources());
        this.processDrawableResources();
        this.processLayoutResources();
        this.processMenuResources();
        if (this.data != null) {
            this.data.setResourceData(this.resourceData);
        }
        logger.trace(this.apkNameMarker + "Finished processing of localizations");
        return this.resourceData;
    }

    private Integer getNumberOfRawResources() {
        List<File> directoriesRaw = this.resourceDirectoryFileFinder.getDirectoriesStartsWithExpression("raw");
        if (directoriesRaw == null) {
            logger.warn(this.apkNameMarker + "res/raw directory doesn`t exists");
            return 0;
        }
        return new FileFinder(directoriesRaw).getAllFilesInDirectories().size();
    }

    private void processDrawableResources() {
        List<File> drawableFiles = null;
        List<File> directories = null;
        try {
            directories = this.resourceDirectoryFileFinder.getDirectoriesContainingExpression("drawable");
            FileFinder ff = new FileFinder(directories);
            drawableFiles = ff.getDrawableResourceFiles();
        }
        catch (IllegalArgumentException e) {
            logger.warn(this.apkNameMarker + "res/drawable directory doesn`t exists");
            return;
        }
        this.resourceData.setDifferentDrawables(this.processDifferentFileNames(drawableFiles));
        this.processDrawablesTypes(drawableFiles);
        this.processDrawableDirectories(directories);
    }

    private void processLayoutResources() {
        List<File> layoutFiles = null;
        List<File> directories = null;
        try {
            directories = this.resourceDirectoryFileFinder.getDirectoriesContainingExpression("layout");
            FileFinder ff = new FileFinder(directories);
            layoutFiles = ff.getXmlFilesInDirectories();
        }
        catch (IllegalArgumentException e) {
            logger.warn(this.apkNameMarker + "res/layout directory doesn`t exists");
            return;
        }
        this.resourceData.setDifferentLayouts(this.processDifferentFileNames(layoutFiles));
        this.resourceData.setLayouts(layoutFiles.size());
    }

    private void processMenuResources() {
        List<File> menuFiles = null;
        List<File> menuDirectories = null;
        try {
            menuDirectories = this.resourceDirectoryFileFinder.getDirectoriesContainingExpression("menu");
            FileFinder ff = new FileFinder(menuDirectories);
            menuFiles = ff.getXmlFilesInDirectories();
        }
        catch (IllegalArgumentException e) {
            logger.warn(this.apkNameMarker + "res/menu directory doesn`t exists");
            return;
        }
        this.resourceData.setMenu(menuFiles.size());
    }

    private List<String> getStringLocalizations() {
        List<File> files = this.resourceDirectoryFileFinder.getStringResourceFilesInDirectories();
        ArrayList<String> localizations = new ArrayList<String>();
        for (File f : files) {
            this.processLocalization(f, localizations);
        }
        return localizations;
    }

    private void processLocalization(File f, List<String> localizations) {
        String parentName = null;
        try {
            parentName = f.getParentFile().getName();
        }
        catch (Exception e) {
            logger.warn("parent of file " + f.getPath() + " not found");
            return;
        }
        String REGEX = "values-(\\D*)";
        Pattern p = Pattern.compile(REGEX);
        Matcher matcher = p.matcher(parentName);
        if (matcher.find()) {
            localizations.add(matcher.group(1));
        }
    }

    private Integer getNumberOfStringResource() {
        Document document;
        File file = null;
        try {
            file = new File(this.apkFile.getDecompiledDirectoryWithDecompiledData(), "res" + File.separator + "values" + File.separator + "strings.xml");
            document = XmlParsingHelper.getNormalizedDocument(file);
        }
        catch (Exception e) {
            logger.warn(this.apkNameMarker + "strings.xml doesn`t exists");
            return null;
        }
        return XmlParsingHelper.getListOfTagAttributeValues(document, "string", "name").size();
    }

    private void processDrawablesTypes(List<File> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        int numJpg = 0;
        int numGif = 0;
        int numPng = 0;
        int numXml = 0;
        int ninePatchPng = 0;
        for (File f : files) {
            String name = f.getName();
            if (name.endsWith(".jpg") || name.endsWith(".JPG") || name.endsWith(".jpeg") || name.endsWith(".JPEG")) {
                ++numJpg;
                continue;
            }
            if (name.endsWith(".gif") || name.endsWith(".GIF")) {
                ++numGif;
                continue;
            }
            if (name.endsWith(".9.png") || name.endsWith(".9.PNG")) {
                ++ninePatchPng;
                continue;
            }
            if (name.endsWith(".png") || name.endsWith(".PNG")) {
                ++numPng;
                continue;
            }
            if (!name.endsWith(".xml") && !name.endsWith(".XML")) continue;
            ++numXml;
        }
        this.resourceData.setGifDrawables(numGif);
        this.resourceData.setPngDrawables(numPng);
        this.resourceData.setJpgDrawables(numJpg);
        this.resourceData.setXmlDrawables(numXml);
        this.resourceData.setNinePatchDrawables(ninePatchPng);
    }

    private Integer processDifferentFileNames(List<File> files) {
        if (files == null || files.isEmpty()) {
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        for (File f : files) {
            names.add(f.getName());
        }
        return names.size();
    }

    private void processDrawableDirectories(List<File> directories) {
        boolean success = false;
        int withoutdpi = 0;
        int ldpi = 0;
        int mdpi = 0;
        int hdpi = 0;
        int xhdpi = 0;
        int xxhdpi = 0;
        int xxxhdpi = 0;
        int nodpi = 0;
        int tvdpi = 0;
        if (directories == null || directories.isEmpty()) {
            return;
        }
        for (File dir : directories) {
            FileFinder ff = new FileFinder(dir);
            int size = ff.getDrawableResourceFiles().size();
            if (size <= 0) continue;
            success = true;
            if (dir.getName().contains("ldpi")) {
                ldpi += size;
                continue;
            }
            if (dir.getName().contains("mdpi")) {
                mdpi += size;
                continue;
            }
            if (dir.getName().contains("xxxhdpi")) {
                xxxhdpi += size;
                continue;
            }
            if (dir.getName().contains("xxhdpi")) {
                xxhdpi += size;
                continue;
            }
            if (dir.getName().contains("xhdpi")) {
                xhdpi += size;
                continue;
            }
            if (dir.getName().contains("hdpi")) {
                hdpi += size;
                continue;
            }
            if (dir.getName().contains("nodpi")) {
                nodpi += size;
                continue;
            }
            if (dir.getName().contains("tvdpi")) {
                tvdpi += size;
                continue;
            }
            if (!dir.getName().contains("drawable")) continue;
            withoutdpi += size;
        }
        if (success) {
            this.resourceData.setLdpiDrawables(ldpi);
            this.resourceData.setMdpiDrawables(mdpi);
            this.resourceData.setHdpiDrawables(hdpi);
            this.resourceData.setXhdpiDrawables(xhdpi);
            this.resourceData.setXxhdpiDrawables(xxhdpi);
            this.resourceData.setXxxhdpiDrawables(xxxhdpi);
            this.resourceData.setNodpiDrawables(nodpi);
            this.resourceData.setTvdpiDrawables(tvdpi);
            this.resourceData.setUnspecifiedDpiDrawables(withoutdpi);
        }
    }
}

