/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.analyze.processors;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.utils.files.ApkFile;

public class FileInfoProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FileInfoProcessor.class);
    private Marker apkNameMarker;
    private ApkData data;
    private ApkFile apkFile;

    public FileInfoProcessor(ApkData data, ApkFile apkFile) {
        if (data == null) {
            throw new IllegalArgumentException("data null");
        }
        if (apkFile == null) {
            throw new IllegalArgumentException("apkFile null");
        }
        this.data = data;
        this.apkFile = apkFile;
        this.apkNameMarker = apkFile.getMarker();
    }

    public FileInfoProcessor(ApkFile apkFile) {
        if (apkFile == null) {
            throw new IllegalArgumentException("apkFile null");
        }
        this.data = new ApkData();
        this.apkFile = apkFile;
        this.apkNameMarker = apkFile.getMarker();
    }

    public static FileInfoProcessor getInstance(ApkData data, ApkFile apkFile) {
        return new FileInfoProcessor(data, apkFile);
    }

    public static FileInfoProcessor getInstance(ApkFile apkFile) {
        return new FileInfoProcessor(apkFile);
    }

    public ApkData processFileInfo() {
        logger.trace(this.apkNameMarker + "Started processing of file info");
        this.getFileName();
        this.getSourceOfFile();
        this.getFileSize();
        this.getDexSize();
        this.getArscSize();
        logger.trace(this.apkNameMarker + "Finished processing of file info");
        return this.data;
    }

    private void getFileName() {
        this.data.setFileName(this.apkFile.getName());
    }

    private void getSourceOfFile() {
        String parentFolderName;
        try {
            parentFolderName = this.apkFile.getParentFile().getName();
        }
        catch (Exception e) {
            return;
        }
        if (parentFolderName.contains("playdrone")) {
            this.data.setSourceOfFile("Playdrone(originally from Google PlayStore)");
            return;
        }
        if (parentFolderName.contains("androidApksFree")) {
            this.data.setSourceOfFile("www.androidapksfree.com");
            return;
        }
        if (parentFolderName.contains("ApkMania")) {
            this.data.setSourceOfFile("www.androidapkmaniafull.com");
            return;
        }
        if (parentFolderName.contains("torrent")) {
            this.data.setSourceOfFile("torrent");
            return;
        }
        if (parentFolderName.contains("ulozto")) {
            this.data.setSourceOfFile("www.uloz.to");
            return;
        }
        if (parentFolderName.contains("zippy")) {
            this.data.setSourceOfFile("www.zippyshare.com");
            return;
        }
        if (parentFolderName.contains("Test") || parentFolderName.contains("test")) {
            this.data.setSourceOfFile("test - works)");
            return;
        }
        if (parentFolderName.contains("appsApk")) {
            this.data.setSourceOfFile("www.appsApk.com");
            return;
        }
    }

    private void getFileSize() {
        this.data.setFileSize(this.apkFile.length());
    }

    private void getDexSize() {
        File dexFile = new File(this.apkFile.getUnzipDirectoryWithUnzipedData(), "classes.dex");
        Long length = dexFile.length();
        if (length != null && length != 0L) {
            this.data.setDexSize(length);
        }
    }

    private void getArscSize() {
        File file = new File(this.apkFile.getUnzipDirectoryWithUnzipedData(), "resources.arsc");
        Long length = file.length();
        if (length != null && length != 0L) {
            this.data.setArscSize(length);
        }
    }
}

