/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.analyze.processors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.analyze.processors.AndroidManifestProcessor;
import sk.styk.martin.bakalarka.analyze.processors.ApkProcessingTask;
import sk.styk.martin.bakalarka.analyze.processors.CertificateProcessor;
import sk.styk.martin.bakalarka.analyze.processors.FileInfoProcessor;
import sk.styk.martin.bakalarka.analyze.processors.HashProcessor;
import sk.styk.martin.bakalarka.analyze.processors.ResourceProcessor;
import sk.styk.martin.bakalarka.utils.files.ApkFile;

public class ApkProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ApkProcessor.class);
    private List<ApkFile> apks;

    public ApkProcessor(List<ApkFile> apks) {
        if (apks == null || apks.isEmpty()) {
            throw new IllegalArgumentException("apks not valid");
        }
        this.apks = apks;
    }

    public ApkProcessor(ApkFile apk) {
        if (this.apks == null || !apk.exists()) {
            throw new IllegalArgumentException("apks not valid");
        }
        this.apks = new ArrayList<ApkFile>();
        this.apks.add(apk);
    }

    public static ApkProcessor ofFiles(List<ApkFile> apks) {
        return new ApkProcessor(apks);
    }

    public static ApkProcessor ofFile(ApkFile apk) {
        return new ApkProcessor(apk);
    }

    public List<ApkData> processFiles() {
        ArrayList<ApkData> statistics = new ArrayList<ApkData>();
        for (ApkFile f : this.apks) {
            statistics.add(this.processFile(f));
        }
        return statistics;
    }

    public void processFiles(File outputDirectory) {
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(numberOfProcessors);
        for (ApkFile f : this.apks) {
            pool.submit(new ApkProcessingTask(f, outputDirectory));
        }
        pool.shutdown();
        try {
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn(e.toString());
        }
    }

    public ApkData processFile(ApkFile apk) {
        logger.info(apk.getMarker() + "Started processing of file " + apk.getName());
        ApkData data = new ApkData();
        FileInfoProcessor.getInstance(data, apk).processFileInfo();
        CertificateProcessor.getInstance(data, apk).processCertificates();
        HashProcessor.getInstance(data, apk).getHashes();
        AndroidManifestProcessor.getInstance(data, apk).processAndroidManifest();
        ResourceProcessor.getInstance(data, apk).processResources();
        apk.cleanApkWorkingDirectory();
        logger.info(apk.getMarker() + "Finished processing of file " + apk.getName());
        return data;
    }
}

