/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.analyze.processors;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.analyze.processors.AndroidManifestProcessor;
import sk.styk.martin.bakalarka.analyze.processors.CertificateProcessor;
import sk.styk.martin.bakalarka.analyze.processors.FileInfoProcessor;
import sk.styk.martin.bakalarka.analyze.processors.HashProcessor;
import sk.styk.martin.bakalarka.analyze.processors.ResourceProcessor;
import sk.styk.martin.bakalarka.utils.files.ApkFile;
import sk.styk.martin.bakalarka.utils.files.JsonUtils;

public class ApkProcessingTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ApkProcessingTask.class);
    private ApkFile apk;
    private File outputDirectory;

    public ApkProcessingTask(ApkFile apk, File outputDirectory) {
        if (apk == null) {
            throw new IllegalArgumentException("apk file is null");
        }
        if (outputDirectory == null) {
            throw new IllegalArgumentException("output directory is null");
        }
        this.apk = apk;
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void run() {
        ApkData data = this.processFile(this.apk);
        JsonUtils.toJson(data, this.outputDirectory);
    }

    private ApkData processFile(ApkFile apk) {
        logger.info(apk.getMarker() + "Started processing of file " + apk.getName());
        ApkData data = new ApkData();
        FileInfoProcessor.getInstance(data, apk).processFileInfo();
        CertificateProcessor.getInstance(data, apk).processCertificates();
        HashProcessor.getInstance(data, apk).getHashes();
        AndroidManifestProcessor.getInstance(data, apk).processAndroidManifest();
        ResourceProcessor.getInstance(data, apk).processResources();
        apk.cleanApkWorkingDirectory();
        logger.info(apk.getMarker() + "Finished processing of file " + apk.getName());
        return data;
    }
}

