/*
 * Decompiled with CFR 0.152.
 */
package sk.styk.martin.bakalarka.analyze.processors;

import fr.xgouchet.axml.CompressedXmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sk.styk.martin.bakalarka.analyze.data.AndroidManifestData;
import sk.styk.martin.bakalarka.analyze.data.ApkData;
import sk.styk.martin.bakalarka.analyze.processors.helpers.XmlParsingHelper;
import sk.styk.martin.bakalarka.utils.files.ApkFile;

public class AndroidManifestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AndroidManifestProcessor.class);
    private Marker apkNameMarker;
    private Document document;
    private ApkData data;
    private File manifestFile;
    private AndroidManifestData manifestData;
    private ApkFile apkFile;

    public AndroidManifestProcessor(ApkData data, ApkFile apkFile) {
        if (data == null) {
            throw new IllegalArgumentException("data null");
        }
        if (apkFile == null) {
            throw new IllegalArgumentException("apkFile null");
        }
        this.data = data;
        this.apkFile = apkFile;
        this.apkNameMarker = apkFile.getMarker();
    }

    public AndroidManifestProcessor(ApkFile apkFile) {
        if (apkFile == null) {
            throw new IllegalArgumentException("apkFile null");
        }
        this.data = null;
        this.apkFile = apkFile;
        this.apkNameMarker = apkFile.getMarker();
    }

    public static AndroidManifestProcessor getInstance(ApkData data, ApkFile apkFile) {
        return new AndroidManifestProcessor(data, apkFile);
    }

    public static AndroidManifestProcessor getInstance(ApkFile apkFile) {
        return new AndroidManifestProcessor(apkFile);
    }

    public AndroidManifestData processAndroidManifest() {
        logger.trace(this.apkNameMarker + "Started processing AndroidManifest");
        this.manifestData = new AndroidManifestData();
        boolean isSuccessXmlDecompress = this.processUsingXmlDecompress();
        boolean isSuccessDecompilation = false;
        if (!isSuccessXmlDecompress) {
            isSuccessDecompilation = this.processUsingDecompilation();
        }
        if (!isSuccessDecompilation && !isSuccessXmlDecompress) {
            this.manifestData = null;
        }
        if (this.data != null) {
            this.data.setAndroidManifest(this.manifestData);
        }
        logger.trace(this.apkNameMarker + "Finished processing of AndroidManifest");
        return this.manifestData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUsingXmlDecompress() {
        boolean isSuccess;
        InputStream manifestStream = null;
        logger.trace(this.apkNameMarker + "Using XML decompress method");
        try {
            this.manifestFile = new File(this.apkFile.getUnzipDirectoryWithUnzipedData(), "AndroidManifest.xml");
            manifestStream = new FileInputStream(this.manifestFile);
            this.document = new CompressedXmlParser().parseDOM(manifestStream);
            this.document.getDocumentElement().normalize();
            this.getManifestTagData();
            this.getAppComponents();
            this.getUsedPermissions();
            this.getUsedLibraries();
            this.getUsedFeatures();
            this.getDefinedPermissions();
            this.getUsesSdk();
            this.getSupportScreens();
            isSuccess = true;
        }
        catch (Exception e) {
            logger.error(this.apkNameMarker + e.toString());
            isSuccess = false;
        }
        finally {
            this.document = null;
            try {
                manifestStream.close();
            }
            catch (Exception e) {
                logger.warn(e.toString());
            }
        }
        return isSuccess;
    }

    private boolean processUsingDecompilation() {
        boolean isSuccess;
        logger.trace(this.apkNameMarker + "Using Apktool decompilation method");
        try {
            this.manifestFile = new File(this.apkFile.getDecompiledDirectoryWithDecompiledData(), "AndroidManifest.xml");
            this.document = XmlParsingHelper.getNormalizedDocument(this.manifestFile);
            this.getManifestTagData();
            this.getAppComponents();
            this.getUsedPermissions();
            this.getUsedLibraries();
            this.getUsedFeatures();
            this.getDefinedPermissions();
            this.getUsesSdk();
            this.getSupportScreens();
            isSuccess = true;
        }
        catch (Exception e) {
            logger.error(this.apkNameMarker + e.toString());
            isSuccess = false;
        }
        finally {
            this.document = null;
        }
        return isSuccess;
    }

    private void getManifestTagData() {
        Element element = XmlParsingHelper.getSingleAppearingElementByTag(this.document, "manifest");
        if (element != null) {
            this.manifestData.setPackageName(XmlParsingHelper.getSingleNonEmptyStringAtributeFromElement(element, "package"));
            this.manifestData.setVersionCode(XmlParsingHelper.getSingleNonEmptyStringAtributeFromElement(element, "android:versionCode"));
            String installLocation = XmlParsingHelper.getSingleNonEmptyStringAtributeFromElement(element, "android:installLocation");
            if (installLocation != null) {
                if (installLocation.equalsIgnoreCase("0")) {
                    this.manifestData.setInstallLocation("auto");
                } else if (installLocation.equalsIgnoreCase("1")) {
                    this.manifestData.setInstallLocation("internalOnly");
                } else if (installLocation.equalsIgnoreCase("2")) {
                    this.manifestData.setInstallLocation("preferExternal");
                } else {
                    this.manifestData.setInstallLocation(installLocation);
                }
            }
        }
    }

    private void getAppComponents() {
        List<String> activityList = XmlParsingHelper.getListOfTagAttributeValues(this.document, "activity", "android:name");
        List<String> serviceList = XmlParsingHelper.getListOfTagAttributeValues(this.document, "service", "android:name");
        List<String> receiverList = XmlParsingHelper.getListOfTagAttributeValues(this.document, "receiver", "android:name");
        List<String> providerList = XmlParsingHelper.getListOfTagAttributeValues(this.document, "provider", "android:name");
        this.manifestData.setNumberOfActivities(activityList.size());
        this.manifestData.setNumberOfServices(serviceList.size());
        this.manifestData.setNumberOfBroadcastReceivers(receiverList.size());
        this.manifestData.setNumberOfContentProviders(providerList.size());
        this.manifestData.setNamesOfActivities(activityList);
        this.manifestData.setNamesOfServices(serviceList);
        this.manifestData.setNamesOfBroadcastReceivers(receiverList);
        this.manifestData.setNamesOfContentProviders(providerList);
    }

    private void getDefinedPermissions() {
        List<String> result = XmlParsingHelper.getListOfTagAttributeValues(this.document, "permission", "android:name");
        this.manifestData.setPermissions(result);
        List<String> protectionLevel = XmlParsingHelper.getListOfTagAttributeValues(this.document, "permission", "android:protectionLevel");
        ArrayList<String> protectionLevelToString = new ArrayList<String>();
        for (String s2 : protectionLevel) {
            if (s2 == null) continue;
            if (s2.equalsIgnoreCase("0")) {
                protectionLevelToString.add("auto");
                continue;
            }
            if (s2.equalsIgnoreCase("1")) {
                protectionLevelToString.add("dangerous");
                continue;
            }
            if (s2.equalsIgnoreCase("2")) {
                protectionLevelToString.add("signature");
                continue;
            }
            if (s2.equalsIgnoreCase("3")) {
                protectionLevelToString.add("signatureOrSystem");
                continue;
            }
            protectionLevelToString.add(s2);
        }
        for (int i = result.size(); i > protectionLevel.size(); --i) {
            protectionLevelToString.add("auto");
        }
        this.manifestData.setPermissionsProtectionLevel(protectionLevelToString);
    }

    private void getUsedPermissions() {
        List<String> result = XmlParsingHelper.getListOfTagAttributeValues(this.document, "uses-permission", "android:name");
        this.manifestData.setUsesPermissions(result);
    }

    private void getUsedLibraries() {
        List<String> result = XmlParsingHelper.getListOfTagAttributeValues(this.document, "uses-library", "android:name");
        this.manifestData.setUsesLibrary(result);
    }

    private void getUsedFeatures() {
        List<String> result = XmlParsingHelper.getListOfTagAttributeValues(this.document, "uses-feature", "android:name");
        this.manifestData.setUsesFeature(result);
    }

    private void getUsesSdk() {
        Element element = XmlParsingHelper.getSingleAppearingElementByTag(this.document, "uses-sdk");
        if (element != null) {
            this.manifestData.setUsesTargetSdkVersion(element.getAttribute("android:targetSdkVersion"));
            this.manifestData.setUsesMinSdkVersion(element.getAttribute("android:minSdkVersion"));
            this.manifestData.setUsesMaxSdkVersion(element.getAttribute("android:maxSdkVersion"));
        }
    }

    private void getSupportScreens() {
        Element element = XmlParsingHelper.getSingleAppearingElementByTag(this.document, "supports-screens");
        if (element != null) {
            this.manifestData.setSupportsScreensResizeable(XmlParsingHelper.getBooleanElementAtribute(element, "android:resizeable"));
            this.manifestData.setSupportsScreensAnyDensity(XmlParsingHelper.getBooleanElementAtribute(element, "android:anyDensity"));
            this.manifestData.setSupportsScreensSmall(XmlParsingHelper.getBooleanElementAtribute(element, "android:smallScreens"));
            this.manifestData.setSupportsScreensNormal(XmlParsingHelper.getBooleanElementAtribute(element, "android:normalScreens"));
            this.manifestData.setSupportsScreensLarge(XmlParsingHelper.getBooleanElementAtribute(element, "android:largeScreens"));
            this.manifestData.setSupportsScreensXlarge(XmlParsingHelper.getBooleanElementAtribute(element, "android:xlargeScreens"));
        }
    }
}

