/*
 * Decompiled with CFR 0.152.
 */
package fr.xgouchet.axml;

import fr.xgouchet.axml.Attribute;
import fr.xgouchet.axml.CompressedXmlDomListener;
import fr.xgouchet.axml.CompressedXmlParserListener;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CompressedXmlParser {
    public static final String TAG = "CXP";
    public static final int WORD_START_DOCUMENT = 524291;
    public static final int WORD_STRING_TABLE = 0x1C0001;
    public static final int WORD_RES_TABLE = 524672;
    public static final int WORD_START_NS = 0x100100;
    public static final int WORD_END_NS = 0x100101;
    public static final int WORD_START_TAG = 0x100102;
    public static final int WORD_END_TAG = 0x100103;
    public static final int WORD_TEXT = 0x100104;
    public static final int WORD_EOS = -1;
    public static final int WORD_SIZE = 4;
    private static final Logger logger = LoggerFactory.getLogger(CompressedXmlParser.class);
    private static final int TYPE_ID_REF = 0x1000008;
    private static final int TYPE_ATTR_REF = 0x2000008;
    private static final int TYPE_STRING = 0x3000008;
    private static final int TYPE_DIMEN = 0x5000008;
    private static final int TYPE_FRACTION = 0x6000008;
    private static final int TYPE_INT = 0x10000008;
    private static final int TYPE_FLOAT = 0x4000008;
    private static final int TYPE_FLAGS = 0x11000008;
    private static final int TYPE_BOOL = 301989896;
    private static final int TYPE_COLOR = 469762056;
    private static final int TYPE_COLOR2 = 486539272;
    private static final String[] DIMEN = new String[]{"px", "dp", "sp", "pt", "in", "mm"};
    private CompressedXmlParserListener mListener;
    private Map<String, String> mNamespaces = new HashMap<String, String>();
    private byte[] mData;
    private String[] mStringsTable;
    private int[] mResourcesIds;
    private int mStringsCount;
    private int mStylesCount;
    private int mResCount;
    private int mParserOffset;

    public void parse(InputStream input, CompressedXmlParserListener listener) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException("CompressedXmlParser Listener can' be null");
        }
        this.mListener = listener;
        this.mData = new byte[input.available()];
        input.read(this.mData);
        input.close();
        this.parseCompressedXml();
    }

    public Document parseDOM(InputStream input) throws IOException, ParserConfigurationException {
        CompressedXmlDomListener dom = new CompressedXmlDomListener();
        this.parse(input, dom);
        return dom.getDocument();
    }

    private void parseCompressedXml() {
        block11: while (this.mParserOffset < this.mData.length) {
            int word0 = this.getLEWord(this.mParserOffset);
            switch (word0) {
                case 524291: {
                    this.parseStartDocument();
                    continue block11;
                }
                case 0x1C0001: {
                    this.parseStringTable();
                    continue block11;
                }
                case 524672: {
                    this.parseResourceTable();
                    continue block11;
                }
                case 0x100100: {
                    this.parseNamespace(true);
                    continue block11;
                }
                case 0x100101: {
                    this.parseNamespace(false);
                    continue block11;
                }
                case 0x100102: {
                    this.parseStartTag();
                    continue block11;
                }
                case 0x100103: {
                    this.parseEndTag();
                    continue block11;
                }
                case 0x100104: {
                    this.parseText();
                    continue block11;
                }
                case -1: {
                    this.mListener.endDocument();
                    continue block11;
                }
            }
            this.mParserOffset += 4;
            logger.warn(TAG, (Object)("Unknown word 0x" + Integer.toHexString(word0) + " @" + this.mParserOffset));
        }
        this.mListener.endDocument();
    }

    private void parseStartDocument() {
        this.mListener.startDocument();
        this.mParserOffset += 8;
    }

    private void parseStringTable() {
        int i;
        int chunk = this.getLEWord(this.mParserOffset + 4);
        this.mStringsCount = this.getLEWord(this.mParserOffset + 8);
        this.mStylesCount = this.getLEWord(this.mParserOffset + 12);
        int strOffset = this.mParserOffset + this.getLEWord(this.mParserOffset + 20);
        int styleOffset = this.getLEWord(this.mParserOffset + 24);
        this.mStringsTable = new String[this.mStringsCount];
        for (i = 0; i < this.mStringsCount; ++i) {
            int offset = strOffset + this.getLEWord(this.mParserOffset + (i + 7) * 4);
            this.mStringsTable[i] = this.getStringFromStringTable(offset);
        }
        if (styleOffset > 0) {
            logger.warn(TAG, (Object)"Unread styles");
            for (i = 0; i < this.mStylesCount; ++i) {
            }
        }
        this.mParserOffset += chunk;
    }

    private void parseResourceTable() {
        int chunk = this.getLEWord(this.mParserOffset + 4);
        this.mResCount = chunk / 4 - 2;
        this.mResourcesIds = new int[this.mResCount];
        for (int i = 0; i < this.mResCount; ++i) {
            this.mResourcesIds[i] = this.getLEWord(this.mParserOffset + (i + 2) * 4);
        }
        this.mParserOffset += chunk;
    }

    private void parseNamespace(boolean start) {
        int prefixIdx = this.getLEWord(this.mParserOffset + 16);
        int uriIdx = this.getLEWord(this.mParserOffset + 20);
        String uri = this.getString(uriIdx);
        String prefix = this.getString(prefixIdx);
        if (start) {
            this.mListener.startPrefixMapping(prefix, uri);
            this.mNamespaces.put(uri, prefix);
        } else {
            this.mListener.endPrefixMapping(prefix, uri);
            this.mNamespaces.remove(uri);
        }
        this.mParserOffset += 24;
    }

    private void parseStartTag() {
        String qname;
        String uri;
        int uriIdx = this.getLEWord(this.mParserOffset + 16);
        int nameIdx = this.getLEWord(this.mParserOffset + 20);
        int attrCount = this.getLEWord(this.mParserOffset + 28);
        String name = this.getString(nameIdx);
        if (uriIdx == -1) {
            uri = "";
            qname = name;
        } else {
            uri = this.getString(uriIdx);
            qname = this.mNamespaces.containsKey(uri) ? this.mNamespaces.get(uri) + ':' + name : name;
        }
        this.mParserOffset += 36;
        Attribute[] attrs = new Attribute[attrCount];
        for (int a = 0; a < attrCount; ++a) {
            attrs[a] = this.parseAttribute();
            this.mParserOffset += 20;
        }
        this.mListener.startElement(uri, name, qname, attrs);
    }

    private Attribute parseAttribute() {
        int attrNSIdx = this.getLEWord(this.mParserOffset);
        int attrNameIdx = this.getLEWord(this.mParserOffset + 4);
        int attrValueIdx = this.getLEWord(this.mParserOffset + 8);
        int attrType = this.getLEWord(this.mParserOffset + 12);
        int attrData = this.getLEWord(this.mParserOffset + 16);
        Attribute attr = new Attribute();
        attr.setName(this.getString(attrNameIdx));
        if (attrNSIdx == -1) {
            attr.setNamespace(null);
            attr.setPrefix(null);
        } else {
            String uri = this.getString(attrNSIdx);
            if (this.mNamespaces.containsKey(uri)) {
                attr.setNamespace(uri);
                attr.setPrefix(this.mNamespaces.get(uri));
            }
        }
        if (attrValueIdx == -1) {
            attr.setValue(this.getAttributeValue(attrType, attrData));
        } else {
            attr.setValue(this.getString(attrValueIdx));
        }
        return attr;
    }

    private void parseText() {
        int strIndex = this.getLEWord(this.mParserOffset + 16);
        String data = this.getString(strIndex);
        this.mListener.characterData(data);
        this.mParserOffset += 28;
    }

    private void parseEndTag() {
        int uriIdx = this.getLEWord(this.mParserOffset + 16);
        int nameIdx = this.getLEWord(this.mParserOffset + 20);
        String name = this.getString(nameIdx);
        String uri = uriIdx == -1 ? "" : this.getString(uriIdx);
        this.mListener.endElement(uri, name, null);
        this.mParserOffset += 24;
    }

    private String getString(int index) {
        String res = index >= 0 && index < this.mStringsCount ? this.mStringsTable[index] : null;
        return res;
    }

    private String getStringFromStringTable(int offset) {
        byte[] chars;
        if (this.mData[offset + 1] == this.mData[offset]) {
            int strLength = this.mData[offset];
            chars = new byte[strLength];
            for (int i = 0; i < strLength; ++i) {
                chars[i] = this.mData[offset + 2 + i];
            }
        } else {
            int strLength = this.mData[offset + 1] << 8 & 0xFF00 | this.mData[offset] & 0xFF;
            chars = new byte[strLength];
            for (int i = 0; i < strLength; ++i) {
                chars[i] = this.mData[offset + 2 + i * 2];
            }
        }
        return new String(chars);
    }

    private int getLEWord(int off) {
        return this.mData[off + 3] << 24 & 0xFF000000 | this.mData[off + 2] << 16 & 0xFF0000 | this.mData[off + 1] << 8 & 0xFF00 | this.mData[off + 0] << 0 & 0xFF;
    }

    private String getAttributeValue(int type, int data) {
        String res;
        switch (type) {
            case 0x3000008: {
                res = this.getString(data);
                break;
            }
            case 0x5000008: {
                res = Integer.toString(data >> 8) + DIMEN[data & 0xFF];
                break;
            }
            case 0x6000008: {
                double fracValue = (double)data / 2.147483647E9;
                res = new DecimalFormat("#.##%").format(fracValue);
                break;
            }
            case 0x4000008: {
                res = Float.toString(Float.intBitsToFloat(data));
                break;
            }
            case 0x10000008: 
            case 0x11000008: {
                res = Integer.toString(data);
                break;
            }
            case 301989896: {
                res = Boolean.toString(data != 0);
                break;
            }
            case 469762056: 
            case 486539272: {
                res = String.format("#%08X", data);
                break;
            }
            case 0x1000008: {
                res = String.format("@id/0x%08X", data);
                break;
            }
            case 0x2000008: {
                res = String.format("?id/0x%08X", data);
                break;
            }
            default: {
                logger.warn(TAG, (Object)("(type=" + Integer.toHexString(type) + ") : " + data + " (0x" + Integer.toHexString(data) + ") @" + this.mParserOffset));
                res = String.format("%08X/0x%08X", type, data);
            }
        }
        return res;
    }
}

