/*
 * Decompiled with CFR 0.152.
 */
package fr.xgouchet.axml;

import fr.xgouchet.axml.Attribute;
import fr.xgouchet.axml.CompressedXmlParserListener;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CompressedXmlDomListener
implements CompressedXmlParserListener {
    private final DocumentBuilder mBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    private Stack<Node> mStack = new Stack();
    private Document mDocument;

    @Override
    public void startDocument() {
        this.mDocument = this.mBuilder.newDocument();
        this.mStack.push(this.mDocument);
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attribute[] attrs) {
        Element elt = this.isEmpty(uri) ? this.mDocument.createElement(localName) : this.mDocument.createElementNS(uri, qName);
        for (Attribute attr : attrs) {
            if (this.isEmpty(attr.getNamespace())) {
                elt.setAttribute(attr.getName(), attr.getValue());
                continue;
            }
            elt.setAttributeNS(attr.getNamespace(), attr.getPrefix() + ':' + attr.getName(), attr.getValue());
        }
        this.mStack.peek().appendChild(elt);
        this.mStack.push(elt);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.mStack.pop();
    }

    @Override
    public void characterData(String data) {
        this.mStack.peek().appendChild(this.mDocument.createCDATASection(data));
    }

    @Override
    public void text(String data) {
        this.mStack.peek().appendChild(this.mDocument.createTextNode(data));
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    public Document getDocument() {
        return this.mDocument;
    }

    private boolean isEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }
}

