/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.common.BrutException;
import brut.util.BrutIO;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    private static Collection<String> mDoNotCompress;

    private ZipUtils() {
    }

    public static void zipFolders(File folder, File zip, File assets, Collection<String> doNotCompress) throws BrutException, IOException {
        mDoNotCompress = doNotCompress;
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zip));
        ZipUtils.zipFolders(folder, zipOutputStream);
        if (assets != null) {
            ZipUtils.processFolder(assets, zipOutputStream, assets.getPath().length() - 6);
        }
        zipOutputStream.close();
    }

    private static void zipFolders(File folder, ZipOutputStream outputStream) throws BrutException, IOException {
        ZipUtils.processFolder(folder, outputStream, folder.getPath().length() + 1);
    }

    private static void processFolder(File folder, ZipOutputStream zipOutputStream, int prefixLength) throws BrutException, IOException {
        for (File file : folder.listFiles()) {
            if (file.isFile()) {
                String cleanedPath = BrutIO.sanitizeUnknownFile(folder, file.getPath().substring(prefixLength));
                ZipEntry zipEntry = new ZipEntry(BrutIO.normalizePath(cleanedPath));
                String extension = FilenameUtils.getExtension(file.getAbsolutePath());
                if (mDoNotCompress != null && (mDoNotCompress.contains(extension) || mDoNotCompress.contains(zipEntry.getName()))) {
                    zipEntry.setMethod(0);
                    zipEntry.setSize(file.length());
                    BufferedInputStream unknownFile = new BufferedInputStream(new FileInputStream(file));
                    CRC32 crc = BrutIO.calculateCrc(unknownFile);
                    zipEntry.setCrc(crc.getValue());
                    unknownFile.close();
                } else {
                    zipEntry.setMethod(8);
                }
                zipOutputStream.putNextEntry(zipEntry);
                try (FileInputStream inputStream = new FileInputStream(file);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                }
                zipOutputStream.closeEntry();
                continue;
            }
            if (!file.isDirectory()) continue;
            ZipUtils.processFolder(file, zipOutputStream, prefixLength);
        }
    }
}

