/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AndrolibException;
import brut.androlib.ApkOptions;
import brut.androlib.ApktoolProperties;
import brut.androlib.meta.MetaInfo;
import brut.androlib.meta.UsesFramework;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResUnknownFiles;
import brut.androlib.res.xml.ResXmlPatcher;
import brut.androlib.src.SmaliBuilder;
import brut.androlib.src.SmaliDecoder;
import brut.common.BrutException;
import brut.common.InvalidUnknownFileException;
import brut.common.RootUnknownFileException;
import brut.common.TraversalUnknownFileException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jf.dexlib2.iface.DexFile;

public class Androlib {
    private final AndrolibResources mAndRes = new AndrolibResources();
    protected final ResUnknownFiles mResUnknownFiles = new ResUnknownFiles();
    public final ApkOptions apkOptions;
    private int mMinSdkVersion = 0;
    private static final Logger LOGGER = Logger.getLogger(Androlib.class.getName());
    private static final String SMALI_DIRNAME = "smali";
    private static final String APK_DIRNAME = "build/apk";
    private static final String UNK_DIRNAME = "unknown";
    private static final String[] APK_RESOURCES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml", "res"};
    private static final String[] APK_RESOURCES_WITHOUT_RES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml"};
    private static final String[] APP_RESOURCES_FILENAMES = new String[]{"AndroidManifest.xml", "res"};
    private static final String[] APK_MANIFEST_FILENAMES = new String[]{"AndroidManifest.xml"};
    private static final String[] APK_STANDARD_ALL_FILENAMES = new String[]{"classes.dex", "AndroidManifest.xml", "resources.arsc", "res", "r", "R", "lib", "libs", "assets", "META-INF", "kotlin"};
    private static final Pattern NO_COMPRESS_PATTERN = Pattern.compile("(jpg|jpeg|png|gif|wav|mp2|mp3|ogg|aac|mpg|mpeg|mid|midi|smf|jet|rtttl|imy|xmf|mp4|m4a|m4v|3gp|3gpp|3g2|3gpp2|amr|awb|wma|wmv|webm|webp|mkv)$");

    public Androlib() {
        this(new ApkOptions());
    }

    public Androlib(ApkOptions apkOptions) {
        this.apkOptions = apkOptions;
        this.mAndRes.apkOptions = apkOptions;
    }

    public ResTable getResTable(ExtFile apkFile) throws AndrolibException {
        return this.mAndRes.getResTable(apkFile, true);
    }

    public ResTable getResTable(ExtFile apkFile, boolean loadMainPkg) throws AndrolibException {
        return this.mAndRes.getResTable(apkFile, loadMainPkg);
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public void decodeSourcesRaw(ExtFile apkFile, File outDir, String filename) throws AndrolibException {
        try {
            LOGGER.info("Copying raw " + filename + " file...");
            apkFile.getDirectory().copyToDir(outDir, filename);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeSourcesSmali(File apkFile, File outDir, String filename, boolean bakDeb, int apiLevel) throws AndrolibException {
        try {
            File smaliDir = filename.equalsIgnoreCase("classes.dex") ? new File(outDir, SMALI_DIRNAME) : new File(outDir, "smali_" + filename.substring(0, filename.indexOf(".")));
            OS.rmdir(smaliDir);
            smaliDir.mkdirs();
            LOGGER.info("Baksmaling " + filename + "...");
            DexFile dexFile = SmaliDecoder.decode(apkFile, smaliDir, filename, bakDeb, apiLevel);
            int minSdkVersion = dexFile.getOpcodes().api;
            if (this.mMinSdkVersion == 0 || this.mMinSdkVersion > minSdkVersion) {
                this.mMinSdkVersion = minSdkVersion;
            }
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeManifestRaw(ExtFile apkFile, File outDir) throws AndrolibException {
        try {
            LOGGER.info("Copying raw manifest...");
            apkFile.getDirectory().copyToDir(outDir, APK_MANIFEST_FILENAMES);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeManifestFull(ExtFile apkFile, File outDir, ResTable resTable) throws AndrolibException {
        this.mAndRes.decodeManifest(resTable, apkFile, outDir);
    }

    public void decodeResourcesRaw(ExtFile apkFile, File outDir) throws AndrolibException {
        try {
            LOGGER.info("Copying raw resources...");
            apkFile.getDirectory().copyToDir(outDir, APK_RESOURCES_FILENAMES);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decodeResourcesFull(ExtFile apkFile, File outDir, ResTable resTable) throws AndrolibException {
        this.mAndRes.decode(resTable, apkFile, outDir);
    }

    public void decodeManifestWithResources(ExtFile apkFile, File outDir, ResTable resTable) throws AndrolibException {
        this.mAndRes.decodeManifestWithResources(resTable, apkFile, outDir);
    }

    public void decodeRawFiles(ExtFile apkFile, File outDir, short decodeAssetMode) throws AndrolibException {
        LOGGER.info("Copying assets and libs...");
        try {
            Directory in = apkFile.getDirectory();
            if (decodeAssetMode == 1 && in.containsDir("assets")) {
                in.copyToDir(outDir, "assets");
            }
            if (in.containsDir("lib")) {
                in.copyToDir(outDir, "lib");
            }
            if (in.containsDir("libs")) {
                in.copyToDir(outDir, "libs");
            }
            if (in.containsDir("kotlin")) {
                in.copyToDir(outDir, "kotlin");
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void recordUncompressedFiles(ExtFile apkFile, Collection<String> uncompressedFilesOrExts) throws AndrolibException {
        try {
            Directory unk = apkFile.getDirectory();
            Set<String> files = unk.getFiles(true);
            for (String file : files) {
                if (!this.isAPKFileNames(file) || unk.getCompressionLevel(file) != 0) continue;
                String ext = "";
                if (unk.getSize(file) != 0L) {
                    ext = FilenameUtils.getExtension(file);
                }
                if (ext.isEmpty() || !NO_COMPRESS_PATTERN.matcher(ext).find()) {
                    ext = file;
                }
                if (uncompressedFilesOrExts.contains(ext)) continue;
                uncompressedFilesOrExts.add(ext);
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean isAPKFileNames(String file) {
        for (String apkFile : APK_STANDARD_ALL_FILENAMES) {
            if (!apkFile.equals(file) && !file.startsWith(apkFile + "/")) continue;
            return true;
        }
        return false;
    }

    public void decodeUnknownFiles(ExtFile apkFile, File outDir) throws AndrolibException {
        LOGGER.info("Copying unknown files...");
        File unknownOut = new File(outDir, UNK_DIRNAME);
        try {
            Directory unk = apkFile.getDirectory();
            Set<String> files = unk.getFiles(true);
            for (String file : files) {
                if (this.isAPKFileNames(file) || file.endsWith(".dex")) continue;
                unk.copyToDir(unknownOut, file);
                this.mResUnknownFiles.addUnknownFileInfo(file, String.valueOf(unk.getCompressionLevel(file)));
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void writeOriginalFiles(ExtFile apkFile, File outDir) throws AndrolibException {
        LOGGER.info("Copying original files...");
        File originalDir = new File(outDir, "original");
        if (!originalDir.exists()) {
            originalDir.mkdirs();
        }
        try {
            Directory in = apkFile.getDirectory();
            if (in.containsFile("AndroidManifest.xml")) {
                in.copyToDir(originalDir, "AndroidManifest.xml");
            }
            if (in.containsDir("META-INF")) {
                in.copyToDir(originalDir, "META-INF");
                if (in.containsDir("META-INF/services")) {
                    LOGGER.info("Copying META-INF/services directory");
                    in.copyToDir(outDir, "META-INF/services");
                }
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void writeMetaFile(File mOutDir, MetaInfo meta) throws AndrolibException {
        try {
            meta.save(new File(mOutDir, "apktool.yml"));
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaInfo readMetaFile(ExtFile appDir) throws AndrolibException {
        try (InputStream in = appDir.getDirectory().getFileInput("apktool.yml");){
            MetaInfo metaInfo = MetaInfo.load(in);
            return metaInfo;
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void build(File appDir, File outFile) throws BrutException {
        this.build(new ExtFile(appDir), outFile);
    }

    public void build(ExtFile appDir, File outFile) throws BrutException {
        LOGGER.info("Using Apktool " + Androlib.getVersion());
        MetaInfo meta = this.readMetaFile(appDir);
        this.apkOptions.isFramework = meta.isFrameworkApk;
        this.apkOptions.resourcesAreCompressed = meta.compressionType;
        this.apkOptions.doNotCompress = meta.doNotCompress;
        this.mAndRes.setSdkInfo(meta.sdkInfo);
        this.mAndRes.setPackageId(meta.packageInfo);
        this.mAndRes.setPackageRenamed(meta.packageInfo);
        this.mAndRes.setVersionInfo(meta.versionInfo);
        this.mAndRes.setSharedLibrary(meta.sharedLibrary);
        this.mAndRes.setSparseResources(meta.sparseResources);
        if (meta.sdkInfo != null && meta.sdkInfo.get("minSdkVersion") != null) {
            String minSdkVersion = meta.sdkInfo.get("minSdkVersion");
            this.mMinSdkVersion = this.mAndRes.getMinSdkVersionFromAndroidCodename(meta, minSdkVersion);
        }
        if (outFile == null) {
            String outFileName = meta.apkFileName;
            outFile = new File(appDir, "dist" + File.separator + (outFileName == null ? "out.apk" : outFileName));
        }
        new File(appDir, APK_DIRNAME).mkdirs();
        File manifest = new File(appDir, "AndroidManifest.xml");
        File manifestOriginal = new File(appDir, "AndroidManifest.xml.orig");
        this.buildSources(appDir);
        this.buildNonDefaultSources(appDir);
        this.buildManifestFile(appDir, manifest, manifestOriginal);
        this.buildResources(appDir, meta.usesFramework);
        this.buildLibs(appDir);
        this.buildCopyOriginalFiles(appDir);
        this.buildApk(appDir, outFile);
        this.buildUnknownFiles(appDir, outFile, meta);
        if (manifest.isFile() && manifest.exists() && manifestOriginal.isFile()) {
            try {
                if (new File(appDir, "AndroidManifest.xml").delete()) {
                    FileUtils.moveFile(manifestOriginal, manifest);
                }
            }
            catch (IOException ex) {
                throw new AndrolibException(ex.getMessage());
            }
        }
        LOGGER.info("Built apk...");
    }

    private void buildManifestFile(File appDir, File manifest, File manifestOriginal) throws AndrolibException {
        if (new File(appDir, "resources.arsc").exists()) {
            return;
        }
        if (manifest.isFile() && manifest.exists()) {
            try {
                if (manifestOriginal.exists()) {
                    manifestOriginal.delete();
                }
                FileUtils.copyFile(manifest, manifestOriginal);
                ResXmlPatcher.fixingPublicAttrsInProviderAttributes(manifest);
            }
            catch (IOException ex) {
                throw new AndrolibException(ex.getMessage());
            }
        }
    }

    public void buildSources(File appDir) throws AndrolibException {
        if (!this.buildSourcesRaw(appDir, "classes.dex") && !this.buildSourcesSmali(appDir, SMALI_DIRNAME, "classes.dex")) {
            LOGGER.warning("Could not find sources");
        }
    }

    public void buildNonDefaultSources(ExtFile appDir) throws AndrolibException {
        try {
            Map<String, Directory> dirs = appDir.getDirectory().getDirs();
            for (Map.Entry<String, Directory> directory : dirs.entrySet()) {
                String filename;
                String name = directory.getKey();
                if (!name.startsWith("smali_") || this.buildSourcesRaw(appDir, filename = name.substring(name.indexOf("_") + 1) + ".dex") || this.buildSourcesSmali(appDir, name, filename)) continue;
                LOGGER.warning("Could not find sources");
            }
            File[] dexFiles = appDir.listFiles();
            if (dexFiles != null) {
                for (File dex : dexFiles) {
                    if (!dex.getName().endsWith(".dex") || dex.getName().equalsIgnoreCase("classes.dex")) continue;
                    this.buildSourcesRaw(appDir, dex.getName());
                }
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean buildSourcesRaw(File appDir, String filename) throws AndrolibException {
        File working = new File(appDir, filename);
        if (!working.exists()) {
            return false;
        }
        File stored = new File(appDir, "build/apk/" + filename);
        if (this.apkOptions.forceBuildAll || this.isModified(working, stored)) {
            LOGGER.info("Copying " + appDir.toString() + " " + filename + " file...");
            try {
                BrutIO.copyAndClose(new FileInputStream(working), new FileOutputStream(stored));
                return true;
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
        return true;
    }

    public boolean buildSourcesSmali(File appDir, String folder, String filename) throws AndrolibException {
        ExtFile smaliDir = new ExtFile(appDir, folder);
        if (!smaliDir.exists()) {
            return false;
        }
        File dex = new File(appDir, "build/apk/" + filename);
        if (!this.apkOptions.forceBuildAll) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (this.apkOptions.forceBuildAll || this.isModified(smaliDir, dex)) {
            LOGGER.info("Smaling " + folder + " folder into " + filename + "...");
            dex.delete();
            SmaliBuilder.build(smaliDir, dex, this.apkOptions.forceApi > 0 ? this.apkOptions.forceApi : this.mMinSdkVersion);
        }
        return true;
    }

    public void buildResources(ExtFile appDir, UsesFramework usesFramework) throws BrutException {
        if (!(this.buildResourcesRaw(appDir) || this.buildResourcesFull(appDir, usesFramework) || this.buildManifest(appDir, usesFramework))) {
            LOGGER.warning("Could not find resources");
        }
    }

    public boolean buildResourcesRaw(ExtFile appDir) throws AndrolibException {
        try {
            if (!new File(appDir, "resources.arsc").exists()) {
                return false;
            }
            File apkDir = new File(appDir, APK_DIRNAME);
            if (!this.apkOptions.forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            if (this.apkOptions.forceBuildAll || this.isModified(this.newFiles(APK_RESOURCES_FILENAMES, appDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir))) {
                LOGGER.info("Copying raw resources...");
                appDir.getDirectory().copyToDir(apkDir, APK_RESOURCES_FILENAMES);
            }
            return true;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean buildResourcesFull(File appDir, UsesFramework usesFramework) throws AndrolibException {
        try {
            if (!new File(appDir, "res").exists()) {
                return false;
            }
            if (!this.apkOptions.forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File apkDir = new File(appDir, APK_DIRNAME);
            File resourceFile = new File(apkDir.getParent(), "resources.zip");
            if (this.apkOptions.forceBuildAll || this.isModified(this.newFiles(APP_RESOURCES_FILENAMES, appDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir)) || this.apkOptions.isAapt2() && !this.isFile(resourceFile)) {
                LOGGER.info("Building resources...");
                if (this.apkOptions.debugMode) {
                    if (this.apkOptions.isAapt2()) {
                        LOGGER.info("Using aapt2 - setting 'debuggable' attribute to 'true' in AndroidManifest.xml");
                        ResXmlPatcher.setApplicationDebugTagTrue(new File(appDir, "AndroidManifest.xml"));
                    } else {
                        ResXmlPatcher.removeApplicationDebugTag(new File(appDir, "AndroidManifest.xml"));
                    }
                }
                File apkFile = File.createTempFile("APKTOOL", null);
                apkFile.delete();
                resourceFile.delete();
                File ninePatch = new File(appDir, "9patch");
                if (!ninePatch.exists()) {
                    ninePatch = null;
                }
                this.mAndRes.aaptPackage(apkFile, new File(appDir, "AndroidManifest.xml"), new File(appDir, "res"), ninePatch, null, this.parseUsesFramework(usesFramework));
                Directory tmpDir = new ExtFile(apkFile).getDirectory();
                try {
                    tmpDir.copyToDir(apkDir, tmpDir.containsDir("res") ? APK_RESOURCES_FILENAMES : APK_RESOURCES_WITHOUT_RES_FILENAMES);
                }
                catch (DirectoryException ex) {
                    LOGGER.warning(ex.getMessage());
                }
                apkFile.delete();
            }
            return true;
        }
        catch (BrutException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean buildManifestRaw(ExtFile appDir) throws AndrolibException {
        try {
            File apkDir = new File(appDir, APK_DIRNAME);
            LOGGER.info("Copying raw AndroidManifest.xml...");
            appDir.getDirectory().copyToDir(apkDir, APK_MANIFEST_FILENAMES);
            return true;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean buildManifest(ExtFile appDir, UsesFramework usesFramework) throws BrutException {
        try {
            if (!new File(appDir, "AndroidManifest.xml").exists()) {
                return false;
            }
            if (!this.apkOptions.forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File apkDir = new File(appDir, APK_DIRNAME);
            if (this.apkOptions.forceBuildAll || this.isModified(this.newFiles(APK_MANIFEST_FILENAMES, appDir), this.newFiles(APK_MANIFEST_FILENAMES, apkDir))) {
                LOGGER.info("Building AndroidManifest.xml...");
                File apkFile = File.createTempFile("APKTOOL", null);
                apkFile.delete();
                File ninePatch = new File(appDir, "9patch");
                if (!ninePatch.exists()) {
                    ninePatch = null;
                }
                this.mAndRes.aaptPackage(apkFile, new File(appDir, "AndroidManifest.xml"), null, ninePatch, null, this.parseUsesFramework(usesFramework));
                Directory tmpDir = new ExtFile(apkFile).getDirectory();
                tmpDir.copyToDir(apkDir, APK_MANIFEST_FILENAMES);
            }
            return true;
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
        catch (AndrolibException ex) {
            LOGGER.warning("Parse AndroidManifest.xml failed, treat it as raw file.");
            return this.buildManifestRaw(appDir);
        }
    }

    public void buildLibs(File appDir) throws AndrolibException {
        this.buildLibrary(appDir, "lib");
        this.buildLibrary(appDir, "libs");
        this.buildLibrary(appDir, "kotlin");
        this.buildLibrary(appDir, "META-INF/services");
    }

    public void buildLibrary(File appDir, String folder) throws AndrolibException {
        File working = new File(appDir, folder);
        if (!working.exists()) {
            return;
        }
        File stored = new File(appDir, "build/apk/" + folder);
        if (this.apkOptions.forceBuildAll || this.isModified(working, stored)) {
            LOGGER.info("Copying libs... (/" + folder + ")");
            try {
                OS.rmdir(stored);
                OS.cpdir(working, stored);
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    public void buildCopyOriginalFiles(File appDir) throws AndrolibException {
        File originalDir;
        if (this.apkOptions.copyOriginalFiles && (originalDir = new File(appDir, "original")).exists()) {
            try {
                LOGGER.info("Copy original files...");
                Directory in = new ExtFile(originalDir).getDirectory();
                if (in.containsFile("AndroidManifest.xml")) {
                    LOGGER.info("Copy AndroidManifest.xml...");
                    in.copyToDir(new File(appDir, APK_DIRNAME), "AndroidManifest.xml");
                }
                if (in.containsDir("META-INF")) {
                    LOGGER.info("Copy META-INF...");
                    in.copyToDir(new File(appDir, APK_DIRNAME), "META-INF");
                }
            }
            catch (DirectoryException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    public void buildUnknownFiles(File appDir, File outFile, MetaInfo meta) throws AndrolibException {
        if (meta.unknownFiles != null) {
            LOGGER.info("Copying unknown files/dir...");
            Map<String, String> files = meta.unknownFiles;
            File tempFile = new File(outFile.getParent(), outFile.getName() + ".apktool_temp");
            boolean renamed = outFile.renameTo(tempFile);
            if (!renamed) {
                throw new AndrolibException("Unable to rename temporary file");
            }
            try (ZipFile inputFile = new ZipFile(tempFile);
                 ZipOutputStream actualOutput = new ZipOutputStream(new FileOutputStream(outFile));){
                this.copyExistingFiles(inputFile, actualOutput);
                this.copyUnknownFiles(appDir, actualOutput, files);
            }
            catch (BrutException | IOException ex) {
                throw new AndrolibException(ex);
            }
            tempFile.delete();
        }
    }

    private void copyExistingFiles(ZipFile inputFile, ZipOutputStream outputFile) throws IOException {
        Enumeration<? extends ZipEntry> entries = inputFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = new ZipEntry(entries.nextElement());
            entry.setCompressedSize(-1L);
            outputFile.putNextEntry(entry);
            if (!entry.isDirectory()) {
                BrutIO.copy(inputFile, outputFile, entry);
            }
            outputFile.closeEntry();
        }
    }

    private void copyUnknownFiles(File appDir, ZipOutputStream outputFile, Map<String, String> files) throws BrutException, IOException {
        File unknownFileDir = new File(appDir, UNK_DIRNAME);
        for (Map.Entry<String, String> unknownFileInfo : files.entrySet()) {
            File inputFile;
            try {
                inputFile = new File(unknownFileDir, BrutIO.sanitizeUnknownFile(unknownFileDir, unknownFileInfo.getKey()));
            }
            catch (InvalidUnknownFileException | RootUnknownFileException | TraversalUnknownFileException exception) {
                LOGGER.warning(String.format("Skipping file %s (%s)", unknownFileInfo.getKey(), exception.getMessage()));
                continue;
            }
            if (inputFile.isDirectory()) continue;
            ZipEntry newEntry = new ZipEntry(unknownFileInfo.getKey());
            int method = Integer.parseInt(unknownFileInfo.getValue());
            LOGGER.fine(String.format("Copying unknown file %s with method %d", unknownFileInfo.getKey(), method));
            if (method == 0) {
                newEntry.setMethod(0);
                newEntry.setSize(inputFile.length());
                newEntry.setCompressedSize(-1L);
                BufferedInputStream unknownFile = new BufferedInputStream(new FileInputStream(inputFile));
                CRC32 crc = BrutIO.calculateCrc(unknownFile);
                newEntry.setCrc(crc.getValue());
            } else {
                newEntry.setMethod(8);
            }
            outputFile.putNextEntry(newEntry);
            BrutIO.copy(inputFile, outputFile);
            outputFile.closeEntry();
        }
    }

    public void buildApk(File appDir, File outApk) throws AndrolibException {
        LOGGER.info("Building apk file...");
        if (outApk.exists()) {
            outApk.delete();
        } else {
            File outDir = outApk.getParentFile();
            if (outDir != null && !outDir.exists()) {
                outDir.mkdirs();
            }
        }
        File assetDir = new File(appDir, "assets");
        if (!assetDir.exists()) {
            assetDir = null;
        }
        this.mAndRes.zipPackage(outApk, new File(appDir, APK_DIRNAME), assetDir);
    }

    public void publicizeResources(File arscFile) throws AndrolibException {
        this.mAndRes.publicizeResources(arscFile);
    }

    public void installFramework(File frameFile) throws AndrolibException {
        this.mAndRes.installFramework(frameFile);
    }

    public void listFrameworks() throws AndrolibException {
        this.mAndRes.listFrameworkDirectory();
    }

    public void emptyFrameworkDirectory() throws AndrolibException {
        this.mAndRes.emptyFrameworkDirectory();
    }

    public boolean isFrameworkApk(ResTable resTable) {
        for (ResPackage pkg : resTable.listMainPackages()) {
            if (pkg.getId() >= 64) continue;
            return true;
        }
        return false;
    }

    public static String getVersion() {
        return ApktoolProperties.get("application.version");
    }

    private File[] parseUsesFramework(UsesFramework usesFramework) throws AndrolibException {
        if (usesFramework == null) {
            return null;
        }
        List<Integer> ids = usesFramework.ids;
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        String tag = usesFramework.tag;
        File[] files = new File[ids.size()];
        int i = 0;
        for (int id : ids) {
            files[i++] = this.mAndRes.getFrameworkApk(id, tag);
        }
        return files;
    }

    private boolean isModified(File working, File stored) {
        return !stored.exists() || BrutIO.recursiveModifiedTime(working) > BrutIO.recursiveModifiedTime(stored);
    }

    private boolean isFile(File working) {
        return working.exists();
    }

    private boolean isModified(File[] working, File[] stored) {
        for (File file : stored) {
            if (file.exists()) continue;
            return true;
        }
        return BrutIO.recursiveModifiedTime(working) > BrutIO.recursiveModifiedTime(stored);
    }

    private File[] newFiles(String[] names, File dir) {
        File[] files = new File[names.length];
        for (int i = 0; i < names.length; ++i) {
            files[i] = new File(dir, names[i]);
        }
        return files;
    }

    public void close() throws IOException {
        this.mAndRes.close();
    }
}

