# Modern Web Development

The Egyptian software development market suffers from a scarcity of expert talent as compared to the international market. In this course we will cover the latest stable software development practice, project architecture, design patterns, and technology, in the field of web development.

This course is aimed at those who intend to pursue a career in software development, or want to create a low cost MVP for a startup. After this course you should be familiar with the current state of the art, capable of making educated decisions about your development stack.

The structure of this course is largely motivated by the notion that novice developer start out adopting frameworks and using libraries without critically thinking about wether this tool is the right fit for the job.

## Course Flow
* This course will be composed of 13 sessions
* Each session will have 2 parts, exercise and discussion
	* During exercise you will be solving the course assignment
	* During discussion we will discuss the next assignment
	* All concepts discussed are documented in the assignments
	* I will be explaining concepts that are unclear
* After each session I will be updating the course material based on our progress.
* Assignments are 10% each because I have to grade you on something.
	* Grades are awarded on completion (deemed complete by me).
	* Assignments are graded during sessions.
	* Grades can be partial depending on completion level.
	* Best 10 assignments are considered
	* Preferably read or start solving the assignment before the session.
	* If your are incapable of completing the assignment you can be granted the permission to complete it before the next exercise slot.
* The first session is a discussion only session.
* The last session is an assignment only session.
* We should all eat pizza at the end of the course.

## You will need

* A Laptop with a bash shell (Unix bases OS or Windows 10 with ubuntu terminal)
* A modern browser e.g. latest google chrome
* Internet
* NodeJS
* Git
* Text Editor such as Atom

## Course Sessions

In this course we will introduce

### 1. Web Applications History

> In this Session we will talk about the existing landscape of things a developer can learn and what we will cover during this course.  

* Setting expectations for the course.
* The problems we will be solving.
* Web application history.
* Setting up an ES6 project with babel and node
* Webpack

**Assignment for next time**

* Build a simple webapp without any libraries
* The basic problems we face
* Split code into sepret files
* OOCSS and BEM

### 2. Life of a Modern Application: Data renders View

> In this session we will start with an recap on the basic Javascript Features and go through Functional Programming Concepts.  

* Flexbox
* es6 feature template strings
* components rendering data to html

**Assignment for next time**

* Complete rendering code to HTML

### 3. Life of a Modern Application: Actions update Data

* DOM Events
* Scoping our code
* Event based Programming with the Observer Pattern

**Assignment for next time**

* Flux architecture (data down action up)

### 4. Life of a Modern Application: Testing

* Unit Testing HTML render
* Pure Functions
* State Store
* Mocks and Stubs
* Dependency Injection

**Assignment for next time**

* Testing our render functions
* Testing our action dispachers
* Testing our actions mutating the store

### 5. Life of a Modern Application: Views trigger Events

* NodeJS: modules
* build tools: gulp
* rendering a virtual dom
* running our test task
* browserify

**Assignment for next time**

* Develop a new kind of todo item called a counter
* todo items can now be edited

### 6. Life of a Modern Application: Asynchronous code

* The Javascript Event Loop
* Promises with fetch
* Creating a simple REST server with express
* Sockets
* Asynchronous
* Reactive Programming


----
						_MIDTERM BREAK_
----


### 7. Continuous Integration and Deployment     
1. Front end with Git pages
		* Resisting Git
		* Deploying your code on github with a CI
		* SSH with Nginx and let’s encrypt
2. Backend with Capistrano (node flight)
		* Deploying on a server with ssh
		* Automating with the CI our git pull request acceptance
		* Using flightplan for deployment

### 8. All you need for an MVP

1. Firebase
	*
	*
2. Testing with Firebase
	*
	*

### 8. Architecture for massive apps: Problems

1. React
	*
	*
2. Progressive Webapps
	*
	*  

### 9. Architecture for massive apps: Frameworks

1. React
	*
	*
2. GraphQL
	*
	*  	 

### 10. React Native Script

1. Setup
	*
	*
2. Push notification
	*


### 11. Extra For Lost Time

1. Electron
	*
	*
2.
	*
	*  	

### 12. Extra For Lost Time

1.
	*
	*
2.
	*
	*  	


## Notes
* Use FAQ sheet



#Course
