---
part: NextBook
title: NextBook Features
---

## User Interface

- Fast and responsive UI, content should be readable and accessible on most devices.
- Looks good even on printouts.
- Good out of the box looks thanks to [tailwindcss](https://tailwindcss.com/).
- Keyboard shortcuts to toggle features (theme, next/previous page navigation).
- Built-in light and dark mode (press <kbd>T</kbd>) for pleasant and safe reading.
- Side menu that keeps reader's read progress (can be disabled).
- In-page dynamic table of contents (if titles are used within the document) with scroolspy.

## SEO

- SEO optimised meta tags.
- robots.txt generated at build time.
- Sitemap generated at built time.
- Great lighthouse scores.

## Functionality & Speed

- A pre-built, single page [JAMSTACK](https://jamstack.org/) application for fast [FCP](https://developer.mozilla.org/en-US/docs/Glossary/First_contentful_paint).
- Fast page loading and pre-loading.
- Cross-page linking with no page reloads.

## Content Creation

- Rich [markdown](https://www.markdownguide.org/) support for content.
- For more interactivity, [MDX](https://mdxjs.com/) power is at your fingertips.
- Fenced code with metadata support allowing code titles, line numbers, links to source, clipboard copying, line highlighting.
- Need even more dynamic features? See [customization & extensibility](#customization--extensibility) below.

## Collaboration & Deployment

- You own your data, content is in plain markdown files, no proprietary formats or apps.
- Collaborate with peers and deploy via familiar GIT workflows as you're used to do with code.
- No hassle, automatic [deployment](https://vercel.com/new) with a single push.

## Customization & Extensibility

- Built on open-source. Nuff said.
- Customizable and easy to read code.
- NextBook is built on top of great and stable software like [Next.js](https://nextjs.org/), [React](https://reactjs.org/), [MDX](https://mdxjs.com/) and [remark](https://github.com/remarkjs/remark). You can leverage everything these libraries are able to offer to improve it further and suit your needs.
