/*
ChromaDB API

This is OpenAPI schema for ChromaDB API.

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// checks if the UpdateEmbedding type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &UpdateEmbedding{}

// UpdateEmbedding struct for UpdateEmbedding
type UpdateEmbedding struct {
	Embeddings []EmbeddingsInner        `json:"embeddings,omitempty"`
	Metadatas  []map[string]interface{} `json:"metadatas,omitempty"`
	Documents  []string                 `json:"documents,omitempty"`
	Ids        []string                 `json:"ids"`
}

// NewUpdateEmbedding instantiates a new UpdateEmbedding object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateEmbedding(ids []string) *UpdateEmbedding {
	this := UpdateEmbedding{}
	this.Ids = ids
	return &this
}

// NewUpdateEmbeddingWithDefaults instantiates a new UpdateEmbedding object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateEmbeddingWithDefaults() *UpdateEmbedding {
	this := UpdateEmbedding{}
	return &this
}

// GetEmbeddings returns the Embeddings field value if set, zero value otherwise.
func (o *UpdateEmbedding) GetEmbeddings() []EmbeddingsInner {
	if o == nil || IsNil(o.Embeddings) {
		var ret []EmbeddingsInner
		return ret
	}
	return o.Embeddings
}

// GetEmbeddingsOk returns a tuple with the Embeddings field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateEmbedding) GetEmbeddingsOk() ([]EmbeddingsInner, bool) {
	if o == nil || IsNil(o.Embeddings) {
		return nil, false
	}
	return o.Embeddings, true
}

// HasEmbeddings returns a boolean if a field has been set.
func (o *UpdateEmbedding) HasEmbeddings() bool {
	if o != nil && !IsNil(o.Embeddings) {
		return true
	}

	return false
}

// SetEmbeddings gets a reference to the given []EmbeddingsInner and assigns it to the Embeddings field.
func (o *UpdateEmbedding) SetEmbeddings(v []EmbeddingsInner) {
	o.Embeddings = v
}

// GetMetadatas returns the Metadatas field value if set, zero value otherwise.
func (o *UpdateEmbedding) GetMetadatas() []map[string]interface{} {
	if o == nil || IsNil(o.Metadatas) {
		var ret []map[string]interface{}
		return ret
	}
	return o.Metadatas
}

// GetMetadatasOk returns a tuple with the Metadatas field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateEmbedding) GetMetadatasOk() ([]map[string]interface{}, bool) {
	if o == nil || IsNil(o.Metadatas) {
		return nil, false
	}
	return o.Metadatas, true
}

// HasMetadatas returns a boolean if a field has been set.
func (o *UpdateEmbedding) HasMetadatas() bool {
	if o != nil && !IsNil(o.Metadatas) {
		return true
	}

	return false
}

// SetMetadatas gets a reference to the given []map[string]interface{} and assigns it to the Metadatas field.
func (o *UpdateEmbedding) SetMetadatas(v []map[string]interface{}) {
	o.Metadatas = v
}

// GetDocuments returns the Documents field value if set, zero value otherwise.
func (o *UpdateEmbedding) GetDocuments() []string {
	if o == nil || IsNil(o.Documents) {
		var ret []string
		return ret
	}
	return o.Documents
}

// GetDocumentsOk returns a tuple with the Documents field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateEmbedding) GetDocumentsOk() ([]string, bool) {
	if o == nil || IsNil(o.Documents) {
		return nil, false
	}
	return o.Documents, true
}

// HasDocuments returns a boolean if a field has been set.
func (o *UpdateEmbedding) HasDocuments() bool {
	if o != nil && !IsNil(o.Documents) {
		return true
	}

	return false
}

// SetDocuments gets a reference to the given []string and assigns it to the Documents field.
func (o *UpdateEmbedding) SetDocuments(v []string) {
	o.Documents = v
}

// GetIds returns the Ids field value
func (o *UpdateEmbedding) GetIds() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.Ids
}

// GetIdsOk returns a tuple with the Ids field value
// and a boolean to check if the value has been set.
func (o *UpdateEmbedding) GetIdsOk() ([]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Ids, true
}

// SetIds sets field value
func (o *UpdateEmbedding) SetIds(v []string) {
	o.Ids = v
}

func (o UpdateEmbedding) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o UpdateEmbedding) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Embeddings) {
		toSerialize["embeddings"] = o.Embeddings
	}
	if !IsNil(o.Metadatas) {
		toSerialize["metadatas"] = o.Metadatas
	}
	if !IsNil(o.Documents) {
		toSerialize["documents"] = o.Documents
	}
	toSerialize["ids"] = o.Ids
	return toSerialize, nil
}

type NullableUpdateEmbedding struct {
	value *UpdateEmbedding
	isSet bool
}

func (v NullableUpdateEmbedding) Get() *UpdateEmbedding {
	return v.value
}

func (v *NullableUpdateEmbedding) Set(val *UpdateEmbedding) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateEmbedding) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateEmbedding) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateEmbedding(val *UpdateEmbedding) *NullableUpdateEmbedding {
	return &NullableUpdateEmbedding{value: val, isSet: true}
}

func (v NullableUpdateEmbedding) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateEmbedding) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
