/*
ChromaDB API

This is OpenAPI schema for ChromaDB API.

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// checks if the QueryResult type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &QueryResult{}

// QueryResult struct for QueryResult
type QueryResult struct {
	Ids        [][]string                 `json:"ids"`
	Embeddings [][]EmbeddingsInner        `json:"embeddings"`
	Documents  [][]string                 `json:"documents"`
	Metadatas  [][]map[string]interface{} `json:"metadatas"`
	Distances  [][]float32                `json:"distances"`
}

// NewQueryResult instantiates a new QueryResult object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewQueryResult(ids [][]string, embeddings [][]EmbeddingsInner, documents [][]string, metadatas [][]map[string]interface{}, distances [][]float32) *QueryResult {
	this := QueryResult{}
	this.Ids = ids
	this.Embeddings = embeddings
	this.Documents = documents
	this.Metadatas = metadatas
	this.Distances = distances
	return &this
}

// NewQueryResultWithDefaults instantiates a new QueryResult object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewQueryResultWithDefaults() *QueryResult {
	this := QueryResult{}
	return &this
}

// GetIds returns the Ids field value
func (o *QueryResult) GetIds() [][]string {
	if o == nil {
		var ret [][]string
		return ret
	}

	return o.Ids
}

// GetIdsOk returns a tuple with the Ids field value
// and a boolean to check if the value has been set.
func (o *QueryResult) GetIdsOk() ([][]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Ids, true
}

// SetIds sets field value
func (o *QueryResult) SetIds(v [][]string) {
	o.Ids = v
}

// GetEmbeddings returns the Embeddings field value
func (o *QueryResult) GetEmbeddings() [][]EmbeddingsInner {
	if o == nil {
		var ret [][]EmbeddingsInner
		return ret
	}

	return o.Embeddings
}

// GetEmbeddingsOk returns a tuple with the Embeddings field value
// and a boolean to check if the value has been set.
func (o *QueryResult) GetEmbeddingsOk() ([][]EmbeddingsInner, bool) {
	if o == nil {
		return nil, false
	}
	return o.Embeddings, true
}

// SetEmbeddings sets field value
func (o *QueryResult) SetEmbeddings(v [][]EmbeddingsInner) {
	o.Embeddings = v
}

// GetDocuments returns the Documents field value
func (o *QueryResult) GetDocuments() [][]string {
	if o == nil {
		var ret [][]string
		return ret
	}

	return o.Documents
}

// GetDocumentsOk returns a tuple with the Documents field value
// and a boolean to check if the value has been set.
func (o *QueryResult) GetDocumentsOk() ([][]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Documents, true
}

// SetDocuments sets field value
func (o *QueryResult) SetDocuments(v [][]string) {
	o.Documents = v
}

// GetMetadatas returns the Metadatas field value
func (o *QueryResult) GetMetadatas() [][]map[string]interface{} {
	if o == nil {
		var ret [][]map[string]interface{}
		return ret
	}

	return o.Metadatas
}

// GetMetadatasOk returns a tuple with the Metadatas field value
// and a boolean to check if the value has been set.
func (o *QueryResult) GetMetadatasOk() ([][]map[string]interface{}, bool) {
	if o == nil {
		return nil, false
	}
	return o.Metadatas, true
}

// SetMetadatas sets field value
func (o *QueryResult) SetMetadatas(v [][]map[string]interface{}) {
	o.Metadatas = v
}

// GetDistances returns the Distances field value
func (o *QueryResult) GetDistances() [][]float32 {
	if o == nil {
		var ret [][]float32
		return ret
	}

	return o.Distances
}

// GetDistancesOk returns a tuple with the Distances field value
// and a boolean to check if the value has been set.
func (o *QueryResult) GetDistancesOk() ([][]float32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Distances, true
}

// SetDistances sets field value
func (o *QueryResult) SetDistances(v [][]float32) {
	o.Distances = v
}

func (o QueryResult) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o QueryResult) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["ids"] = o.Ids
	toSerialize["embeddings"] = o.Embeddings
	toSerialize["documents"] = o.Documents
	toSerialize["metadatas"] = o.Metadatas
	toSerialize["distances"] = o.Distances
	return toSerialize, nil
}

type NullableQueryResult struct {
	value *QueryResult
	isSet bool
}

func (v NullableQueryResult) Get() *QueryResult {
	return v.value
}

func (v *NullableQueryResult) Set(val *QueryResult) {
	v.value = val
	v.isSet = true
}

func (v NullableQueryResult) IsSet() bool {
	return v.isSet
}

func (v *NullableQueryResult) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableQueryResult(val *QueryResult) *NullableQueryResult {
	return &NullableQueryResult{value: val, isSet: true}
}

func (v NullableQueryResult) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableQueryResult) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
