/*
ChromaDB API

This is OpenAPI schema for ChromaDB API.

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// checks if the QueryEmbedding type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &QueryEmbedding{}

// QueryEmbedding struct for QueryEmbedding
type QueryEmbedding struct {
	Where           map[string]interface{} `json:"where,omitempty"`
	WhereDocument   map[string]interface{} `json:"where_document,omitempty"`
	QueryEmbeddings []EmbeddingsInner      `json:"query_embeddings"`
	NResults        *int32                 `json:"n_results,omitempty"`
	Include         []IncludeInner         `json:"include,omitempty"`
}

// NewQueryEmbedding instantiates a new QueryEmbedding object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewQueryEmbedding(queryEmbeddings []EmbeddingsInner) *QueryEmbedding {
	this := QueryEmbedding{}
	this.QueryEmbeddings = queryEmbeddings
	var nResults int32 = 10
	this.NResults = &nResults
	return &this
}

// NewQueryEmbeddingWithDefaults instantiates a new QueryEmbedding object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewQueryEmbeddingWithDefaults() *QueryEmbedding {
	this := QueryEmbedding{}
	var nResults int32 = 10
	this.NResults = &nResults
	return &this
}

// GetWhere returns the Where field value if set, zero value otherwise.
func (o *QueryEmbedding) GetWhere() map[string]interface{} {
	if o == nil || IsNil(o.Where) {
		var ret map[string]interface{}
		return ret
	}
	return o.Where
}

// GetWhereOk returns a tuple with the Where field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *QueryEmbedding) GetWhereOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Where) {
		return map[string]interface{}{}, false
	}
	return o.Where, true
}

// HasWhere returns a boolean if a field has been set.
func (o *QueryEmbedding) HasWhere() bool {
	if o != nil && !IsNil(o.Where) {
		return true
	}

	return false
}

// SetWhere gets a reference to the given map[string]interface{} and assigns it to the Where field.
func (o *QueryEmbedding) SetWhere(v map[string]interface{}) {
	o.Where = v
}

// GetWhereDocument returns the WhereDocument field value if set, zero value otherwise.
func (o *QueryEmbedding) GetWhereDocument() map[string]interface{} {
	if o == nil || IsNil(o.WhereDocument) {
		var ret map[string]interface{}
		return ret
	}
	return o.WhereDocument
}

// GetWhereDocumentOk returns a tuple with the WhereDocument field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *QueryEmbedding) GetWhereDocumentOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.WhereDocument) {
		return map[string]interface{}{}, false
	}
	return o.WhereDocument, true
}

// HasWhereDocument returns a boolean if a field has been set.
func (o *QueryEmbedding) HasWhereDocument() bool {
	if o != nil && !IsNil(o.WhereDocument) {
		return true
	}

	return false
}

// SetWhereDocument gets a reference to the given map[string]interface{} and assigns it to the WhereDocument field.
func (o *QueryEmbedding) SetWhereDocument(v map[string]interface{}) {
	o.WhereDocument = v
}

// GetQueryEmbeddings returns the QueryEmbeddings field value
func (o *QueryEmbedding) GetQueryEmbeddings() []EmbeddingsInner {
	if o == nil {
		var ret []EmbeddingsInner
		return ret
	}

	return o.QueryEmbeddings
}

// GetQueryEmbeddingsOk returns a tuple with the QueryEmbeddings field value
// and a boolean to check if the value has been set.
func (o *QueryEmbedding) GetQueryEmbeddingsOk() ([]EmbeddingsInner, bool) {
	if o == nil {
		return nil, false
	}
	return o.QueryEmbeddings, true
}

// SetQueryEmbeddings sets field value
func (o *QueryEmbedding) SetQueryEmbeddings(v []EmbeddingsInner) {
	o.QueryEmbeddings = v
}

// GetNResults returns the NResults field value if set, zero value otherwise.
func (o *QueryEmbedding) GetNResults() int32 {
	if o == nil || IsNil(o.NResults) {
		var ret int32
		return ret
	}
	return *o.NResults
}

// GetNResultsOk returns a tuple with the NResults field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *QueryEmbedding) GetNResultsOk() (*int32, bool) {
	if o == nil || IsNil(o.NResults) {
		return nil, false
	}
	return o.NResults, true
}

// HasNResults returns a boolean if a field has been set.
func (o *QueryEmbedding) HasNResults() bool {
	if o != nil && !IsNil(o.NResults) {
		return true
	}

	return false
}

// SetNResults gets a reference to the given int32 and assigns it to the NResults field.
func (o *QueryEmbedding) SetNResults(v int32) {
	o.NResults = &v
}

// GetInclude returns the Include field value if set, zero value otherwise.
func (o *QueryEmbedding) GetInclude() []IncludeInner {
	if o == nil || IsNil(o.Include) {
		var ret []IncludeInner
		return ret
	}
	return o.Include
}

// GetIncludeOk returns a tuple with the Include field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *QueryEmbedding) GetIncludeOk() ([]IncludeInner, bool) {
	if o == nil || IsNil(o.Include) {
		return nil, false
	}
	return o.Include, true
}

// HasInclude returns a boolean if a field has been set.
func (o *QueryEmbedding) HasInclude() bool {
	if o != nil && !IsNil(o.Include) {
		return true
	}

	return false
}

// SetInclude gets a reference to the given []IncludeInner and assigns it to the Include field.
func (o *QueryEmbedding) SetInclude(v []IncludeInner) {
	o.Include = v
}

func (o QueryEmbedding) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o QueryEmbedding) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Where) {
		toSerialize["where"] = o.Where
	}
	if !IsNil(o.WhereDocument) {
		toSerialize["where_document"] = o.WhereDocument
	}
	toSerialize["query_embeddings"] = o.QueryEmbeddings
	if !IsNil(o.NResults) {
		toSerialize["n_results"] = o.NResults
	}
	if !IsNil(o.Include) {
		toSerialize["include"] = o.Include
	}
	return toSerialize, nil
}

type NullableQueryEmbedding struct {
	value *QueryEmbedding
	isSet bool
}

func (v NullableQueryEmbedding) Get() *QueryEmbedding {
	return v.value
}

func (v *NullableQueryEmbedding) Set(val *QueryEmbedding) {
	v.value = val
	v.isSet = true
}

func (v NullableQueryEmbedding) IsSet() bool {
	return v.isSet
}

func (v *NullableQueryEmbedding) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableQueryEmbedding(val *QueryEmbedding) *NullableQueryEmbedding {
	return &NullableQueryEmbedding{value: val, isSet: true}
}

func (v NullableQueryEmbedding) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableQueryEmbedding) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
