/*
ChromaDB API

This is OpenAPI schema for ChromaDB API.

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// checks if the GetResult type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &GetResult{}

// GetResult struct for GetResult
type GetResult struct {
	Ids        []string                 `json:"ids"`
	Embeddings []EmbeddingsInner        `json:"embeddings"`
	Documents  []string                 `json:"documents"`
	Metadatas  []map[string]interface{} `json:"metadatas"`
}

// NewGetResult instantiates a new GetResult object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGetResult(ids []string, embeddings []EmbeddingsInner, documents []string, metadatas []map[string]interface{}) *GetResult {
	this := GetResult{}
	this.Ids = ids
	this.Embeddings = embeddings
	this.Documents = documents
	this.Metadatas = metadatas
	return &this
}

// NewGetResultWithDefaults instantiates a new GetResult object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGetResultWithDefaults() *GetResult {
	this := GetResult{}
	return &this
}

// GetIds returns the Ids field value
func (o *GetResult) GetIds() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.Ids
}

// GetIdsOk returns a tuple with the Ids field value
// and a boolean to check if the value has been set.
func (o *GetResult) GetIdsOk() ([]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Ids, true
}

// SetIds sets field value
func (o *GetResult) SetIds(v []string) {
	o.Ids = v
}

// GetEmbeddings returns the Embeddings field value
func (o *GetResult) GetEmbeddings() []EmbeddingsInner {
	if o == nil {
		var ret []EmbeddingsInner
		return ret
	}

	return o.Embeddings
}

// GetEmbeddingsOk returns a tuple with the Embeddings field value
// and a boolean to check if the value has been set.
func (o *GetResult) GetEmbeddingsOk() ([]EmbeddingsInner, bool) {
	if o == nil {
		return nil, false
	}
	return o.Embeddings, true
}

// SetEmbeddings sets field value
func (o *GetResult) SetEmbeddings(v []EmbeddingsInner) {
	o.Embeddings = v
}

// GetDocuments returns the Documents field value
func (o *GetResult) GetDocuments() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.Documents
}

// GetDocumentsOk returns a tuple with the Documents field value
// and a boolean to check if the value has been set.
func (o *GetResult) GetDocumentsOk() ([]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Documents, true
}

// SetDocuments sets field value
func (o *GetResult) SetDocuments(v []string) {
	o.Documents = v
}

// GetMetadatas returns the Metadatas field value
func (o *GetResult) GetMetadatas() []map[string]interface{} {
	if o == nil {
		var ret []map[string]interface{}
		return ret
	}

	return o.Metadatas
}

// GetMetadatasOk returns a tuple with the Metadatas field value
// and a boolean to check if the value has been set.
func (o *GetResult) GetMetadatasOk() ([]map[string]interface{}, bool) {
	if o == nil {
		return nil, false
	}
	return o.Metadatas, true
}

// SetMetadatas sets field value
func (o *GetResult) SetMetadatas(v []map[string]interface{}) {
	o.Metadatas = v
}

func (o GetResult) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o GetResult) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["ids"] = o.Ids
	toSerialize["embeddings"] = o.Embeddings
	toSerialize["documents"] = o.Documents
	toSerialize["metadatas"] = o.Metadatas
	return toSerialize, nil
}

type NullableGetResult struct {
	value *GetResult
	isSet bool
}

func (v NullableGetResult) Get() *GetResult {
	return v.value
}

func (v *NullableGetResult) Set(val *GetResult) {
	v.value = val
	v.isSet = true
}

func (v NullableGetResult) IsSet() bool {
	return v.isSet
}

func (v *NullableGetResult) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGetResult(val *GetResult) *NullableGetResult {
	return &NullableGetResult{value: val, isSet: true}
}

func (v NullableGetResult) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGetResult) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
