# Are You a Quarantine Pro?

<p>
  <!-- iOS -->
  <img alt="Supports Expo iOS" longdesc="Supports Expo iOS" src="https://img.shields.io/badge/iOS-4630EB.svg?style=flat-square&logo=APPLE&labelColor=999999&logoColor=fff" />
  <!-- Android -->
  <img alt="Supports Expo Android" longdesc="Supports Expo Android" src="https://img.shields.io/badge/Android-4630EB.svg?style=flat-square&logo=ANDROID&labelColor=A4C639&logoColor=fff" />  
</p>

[![runs with expo](https://img.shields.io/badge/Runs%20with%20Expo-4630EB.svg?style=flat-square&logo=EXPO&labelColor=f3f3f3&logoColor=000)](https://expo.io/)

This is a **fun** app built for [Jscrambler](https://blog.jscrambler.com/) tutorial during the time of pandemic. The objective includes:

- use [Expo](https://expo.io) SDK `37.x.x`.
- How to use [Expo font hook](https://github.com/byCedric/use-expo/blob/master/packages/font/docs/use-fonts.md) from [Cedric van Putten's](https://github.com/byCedric) collection of `use-expo` [hooks](https://github.com/byCedric/use-expo).
- How to use [date time picker modal](https://github.com/mmazzarolo/react-native-modal-datetime-picker) to select a date.
- Use [momentjs](https://momentjs.com/) to convert the data input provided by the user and calculate the difference between the current date.

The app is all about how long you have been quarantining. As a user, you input the date when you started isolating and the app is going to display a fun message to tell you how far you have come in the quarantine "game".

## Screens: What's inside?

![js16](https://i.imgur.com/R9zCaz7.png)

![ss1](https://i.imgur.com/SnPI2uX.png)

![ss2](https://i.imgur.com/JWb6HQC.png)

![ss3](https://i.imgur.com/JSM5QkN.png)

![ss4](https://i.imgur.com/O2UUusE.png)

![ss5](https://i.imgur.com/HUmzcJK.png)

![ss6](https://i.imgur.com/3vcjgbH.gif)

Yes, this app is completely build using Expo and its modules (_What a great way to build mobile apps!_)

## Installation

It's easy.

- Clone this repo
- before running the app for the first time, make sure to install dependencies: `npm install` or `yarn install`.

```shell
cd CheckQuarantineLevel

yarn install
```

To run the app, use `expo start`.

## License

MIT

---

## Built by

- @amanhimself: [Twitter](https://twitter.com/amanhimself) | [Blog](https://amanhimself.dev) | [Subscribe the newsletter for new React Native posts and tutorials here](https://tinyletter.com/amanhimself)
